/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JSpinner;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public abstract class AbstractEditorDialog
extends TmmDialog {
    private final MediaEntity mediaEntity;
    protected boolean continueQueue = true;
    protected boolean navigateBack = false;
    protected int queueIndex;
    protected int queueSize;

    protected AbstractEditorDialog(String title, String id, MediaEntity mediaEntity) {
        super(title, id);
        this.mediaEntity = mediaEntity;
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    public boolean showDialog() {
        this.setLocationRelativeTo(MainWindow.getInstance());
        this.setVisible(true);
        return this.continueQueue;
    }

    protected void setImageSizeAndCreateLink(LinkLabel lblSize, ImageLabel imageLabel, JButton buttonDelete, MediaFileType type) {
        TmmUIHelper.createLinkForImage(lblSize, imageLabel);
        if (imageLabel.getOriginalImageSize().width == 0 && imageLabel.getOriginalImageSize().height == 0) {
            lblSize.setText("");
            lblSize.setVisible(false);
            buttonDelete.setVisible(false);
            return;
        }
        Dimension dimension = StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl()) && !imageLabel.getImageUrl().equals(this.mediaEntity.getArtworkUrl(type)) ? imageLabel.getOriginalImageSize() : this.mediaEntity.getArtworkDimension(type);
        if (dimension.width == 0 && dimension.height == 0) {
            lblSize.setText(imageLabel.getOriginalImageSize().width + "x" + imageLabel.getOriginalImageSize().height);
        } else {
            lblSize.setText(dimension.width + "x" + dimension.height);
        }
        lblSize.setVisible(true);
        buttonDelete.setVisible(true);
    }

    protected void commitChanges() {
        for (Component component : this.getAllComponents(this.getContentPane())) {
            if (!(component instanceof JSpinner)) continue;
            JSpinner spinner = (JSpinner)component;
            try {
                spinner.commitEdit();
            }
            catch (ParseException parseException) {}
        }
    }

    private List<Component> getAllComponents(Container c) {
        Component[] comps = c.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        for (Component comp : comps) {
            compList.add(comp);
            if (!(comp instanceof Container)) continue;
            compList.addAll(this.getAllComponents((Container)comp));
        }
        return compList;
    }

    protected class NavigateBackAction
    extends AbstractAction {
        public NavigateBackAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.back"));
            this.putValue("SmallIcon", IconManager.BACK_INV);
            this.putValue("SwingLargeIconKey", IconManager.BACK_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractEditorDialog.this.navigateBack = true;
            AbstractEditorDialog.this.setVisible(false);
        }
    }

    protected class AbortQueueAction
    extends AbstractAction {
        public AbortQueueAction(String tooltip) {
            this.putValue("Name", TmmResourceBundle.getString("Button.abortqueue"));
            this.putValue("ShortDescription", tooltip);
            this.putValue("SmallIcon", IconManager.STOP_INV);
            this.putValue("SwingLargeIconKey", IconManager.STOP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractEditorDialog.this.continueQueue = false;
            AbstractEditorDialog.this.setVisible(false);
        }
    }
}

