/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.TmmUILogAppender;
import org.tinymediamanager.ui.TmmUILogCollector;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class LogDialog
extends TmmDialog
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogDialog.class);
    private static final int REFRESH_PERIOD = 1000;
    private JTextArea taLogs;
    private int logByteCount = 0;
    private final Timer timerRefresh;

    public LogDialog() {
        super(TmmResourceBundle.getString("logwindow.title"), "log");
        this.setBounds(5, 5, 1000, 590);
        this.timerRefresh = new Timer(1000, this);
        this.timerRefresh.setInitialDelay(0);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[400lp,grow]"));
        NoBorderScrollPane scrollPane = new NoBorderScrollPane();
        panelContent.add((Component)scrollPane, "cell 0 0,grow");
        this.taLogs = new JTextArea();
        scrollPane.setViewportView(this.taLogs);
        this.taLogs.setEditable(false);
        this.taLogs.setWrapStyleWord(true);
        this.taLogs.setLineWrap(true);
        this.taLogs.setText(TmmUILogCollector.instance.getLogOutput().getContent());
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
        this.timerRefresh.start();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.timerRefresh) {
            this.updateApplicationLog();
        }
    }

    @Override
    public void pack() {
    }

    private void updateApplicationLog() {
        boolean append = this.logByteCount > 0;
        TmmUILogAppender.LogOutput logOutput = TmmUILogCollector.instance.getLogOutput(this.logByteCount);
        this.logByteCount = logOutput.getByteCount();
        String content = logOutput.getContent();
        if (content.length() > 0) {
            if (append) {
                Document doc = this.taLogs.getDocument();
                try {
                    doc.insertString(doc.getLength(), content, null);
                }
                catch (BadLocationException ble) {
                    LOGGER.error("bad location: ", (Throwable)ble);
                }
            } else {
                this.taLogs.setText(content);
            }
            this.taLogs.setCaretPosition(this.taLogs.getText().length());
        }
    }
}

