/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.plaf.basic.BasicProgressBarUI;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.images.TmmSvgIcon;

public class TmmSplashScreen
extends JDialog {
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");
    private static final Color FOREGROUND_COLOR = new Color(134, 134, 134);
    private final JProgressBar progressBar;
    private final JLabel lblText;
    private final JLabel lblVersion;

    public TmmSplashScreen() throws URISyntaxException {
        TmmSvgIcon splashscreen = new TmmSvgIcon(IconManager.class.getResource("images/svg/splashscreen.svg").toURI());
        JLabel lblBackground = new JLabel((Icon)((Object)splashscreen));
        this.getContentPane().add((Component)lblBackground, "Center");
        lblBackground.setLayout(new BorderLayout());
        JPanel panelSouth = new JPanel();
        panelSouth.setOpaque(false);
        lblBackground.add((Component)panelSouth, "South");
        panelSouth.setLayout((LayoutManager)new MigLayout("ins 20", "[grow,fill][]", "[][]"));
        this.progressBar = new JProgressBar();
        this.progressBar.setUI(new TmmSplashProgressBar());
        this.progressBar.setPreferredSize(new Dimension(200, 15));
        panelSouth.add((Component)this.progressBar, "cell 0 0 2 1,growx");
        this.lblText = new JLabel(TmmResourceBundle.getString("splash.loading"));
        this.lblText.setForeground(FOREGROUND_COLOR);
        TmmFontHelper.changeFont((JComponent)this.lblText, 0.83333);
        panelSouth.add((Component)this.lblText, "cell 0 1,growx , wmin 0");
        this.lblVersion = new JLabel("");
        this.lblVersion.setForeground(FOREGROUND_COLOR);
        TmmFontHelper.changeFont((JComponent)this.lblVersion, 0.83333);
        panelSouth.add((Component)this.lblVersion, "cell 1 1,alignx right");
        this.setModal(false);
        this.setUndecorated(true);
        TmmSplashScreen.setDefaultLookAndFeelDecorated(false);
        if (SystemUtils.IS_OS_LINUX) {
            this.getContentPane().setBackground(new Color(39, 39, 39));
        } else {
            this.setBackground(new Color(0, 0, 0, 0));
        }
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setVersion(String version) {
        this.lblVersion.setText(version);
    }

    public void setProgress(int progress, String text) {
        this.setProgress(progress);
        this.setText(text);
    }

    public void setProgress(int progress) {
        this.progressBar.setValue(progress);
    }

    public void setText(String text) {
        try {
            this.lblText.setText(BUNDLE.getString(text));
        }
        catch (Exception e) {
            this.lblText.setText(text);
        }
    }

    static class TmmSplashProgressBar
    extends BasicProgressBarUI {
        private static final int PROGRESS_BAR_HEIGHT = 6;
        private static final int PROGRESS_BAR_ARC = 6;
        private static final Color BACKGROUND_COLOR = new Color(20, 20, 20);

        TmmSplashProgressBar() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g, JComponent c) {
            Graphics2D g2D = (Graphics2D)g.create();
            try {
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Insets b = this.progressBar.getInsets();
                int w = this.progressBar.getWidth() - (b.right + b.left);
                int h = this.progressBar.getHeight() - (b.top + b.bottom);
                int amountFull = this.getAmountFull(b, w, h);
                int y = b.top + (h - 6) / 2;
                g2D.setColor(BACKGROUND_COLOR);
                g2D.fillRoundRect(b.left, y, w, 6, 6, 6);
                g2D.setColor(FOREGROUND_COLOR);
                g2D.fillRoundRect(b.left, y, amountFull, 6, 6, 6);
            }
            finally {
                g2D.dispose();
            }
        }

        @Override
        protected void installDefaults() {
            super.installDefaults();
            this.progressBar.setOpaque(false);
            this.progressBar.setBorderPainted(false);
        }
    }
}

