/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieDeleteAction
extends TmmAction {
    public MovieDeleteAction() {
        this.putValue("SmallIcon", IconManager.DELETE_FOREVER);
        this.putValue("Name", TmmResourceBundle.getString("movie.delete"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.delete.hint"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
        int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), TmmResourceBundle.getString("movie.delete.desc"), TmmResourceBundle.getString("movie.delete"), 0, 3, null, options, null);
        if (answer != 0) {
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(() -> MovieModuleManager.getInstance().getMovieList().deleteMovies(selectedMovies));
    }
}

