/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.combobox.ScraperMetadataConfigCheckComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieDownloadMissingArtworkDialog
extends TmmDialog {
    private final MediaScraperCheckComboBox cbArtworkScraper;
    private final ScraperMetadataConfigCheckComboBox<MovieScraperMetadataConfig> cbScraperConfig;
    private boolean startScrape = false;

    public MovieDownloadMissingArtworkDialog() {
        super(TmmResourceBundle.getString("movie.downloadmissingartwork"), "downloadMissingArtwork");
        ArrayList<MediaScraper> selectedArtworkScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper artworkScraper : MovieModuleManager.getInstance().getMovieList().getAvailableArtworkScrapers()) {
            if (!MovieModuleManager.getInstance().getSettings().getArtworkScrapers().contains(artworkScraper.getId())) continue;
            selectedArtworkScrapers.add(artworkScraper);
        }
        JPanel panelCenter = new JPanel();
        this.getContentPane().add((Component)panelCenter, "Center");
        panelCenter.setLayout((LayoutManager)new MigLayout("", "[][300lp:400lp,grow]", "[][][][][shrink 0][150lp:n, grow]"));
        TmmLabel lblArtworkScraper = new TmmLabel(TmmResourceBundle.getString("scraper.artwork"));
        panelCenter.add((Component)lblArtworkScraper, "cell 0 2,alignx right");
        this.cbArtworkScraper = new MediaScraperCheckComboBox(MovieModuleManager.getInstance().getMovieList().getAvailableArtworkScrapers());
        panelCenter.add((Component)this.cbArtworkScraper, "cell 1 2,growx");
        JSeparator separator = new JSeparator();
        panelCenter.add((Component)separator, "cell 0 4 2 1,growx");
        JPanel panelScraperConfig = new JPanel();
        panelCenter.add((Component)panelScraperConfig, "cell 0 5 2 1,grow");
        panelScraperConfig.setLayout((LayoutManager)new MigLayout("", "[300lp:400lp,grow]", "[][]"));
        TmmLabel lblScrapeFollowingItems = new TmmLabel(TmmResourceBundle.getString("scraper.metadata.select"));
        panelScraperConfig.add((Component)lblScrapeFollowingItems, "cell 0 0");
        this.cbScraperConfig = new ScraperMetadataConfigCheckComboBox<MovieScraperMetadataConfig>(MovieScraperMetadataConfig.valuesForType(ScraperMetadataConfig.Type.ARTWORK));
        this.cbScraperConfig.enableFilter((movieScraperMetadataConfig, s) -> movieScraperMetadataConfig.getDescription().toLowerCase(Locale.ROOT).startsWith(s.toLowerCase(Locale.ROOT)));
        panelScraperConfig.add(this.cbScraperConfig, "cell 0 1 ,wmin 0,grow");
        JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL_INV);
        btnCancel.addActionListener(e -> {
            this.startScrape = false;
            this.setVisible(false);
        });
        this.addButton(btnCancel);
        JButton btnStart = new JButton(TmmResourceBundle.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY_INV);
        btnStart.addActionListener(e -> {
            this.startScrape = true;
            this.setVisible(false);
        });
        this.addDefaultButton(btnStart);
        if (!selectedArtworkScrapers.isEmpty()) {
            this.cbArtworkScraper.setSelectedItems(selectedArtworkScrapers);
        }
        this.cbScraperConfig.setSelectedItems(MovieModuleManager.getInstance().getSettings().getScraperMetadataConfig());
    }

    public MovieSearchAndScrapeOptions getMovieSearchAndScrapeOptions() {
        MovieSearchAndScrapeOptions movieSearchAndScrapeConfig = new MovieSearchAndScrapeOptions();
        movieSearchAndScrapeConfig.setCertificationCountry(MovieModuleManager.getInstance().getSettings().getCertificationCountry());
        movieSearchAndScrapeConfig.setReleaseDateCountry(MovieModuleManager.getInstance().getSettings().getReleaseDateCountry());
        movieSearchAndScrapeConfig.setArtworkScraper(this.cbArtworkScraper.getSelectedItems());
        return movieSearchAndScrapeConfig;
    }

    public List<MovieScraperMetadataConfig> getMovieScraperMetadataConfig() {
        return this.cbScraperConfig.getSelectedItems();
    }

    public boolean shouldStartScrape() {
        return this.startScrape;
    }
}

