/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.floreysoft.jmte.Engine;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TablePopupListener;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmRoundMultilineTextArea;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.SettingsDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.renderer.MultilineTableCellRenderer;

public class MovieJmteExplorerDialog
extends TmmDialog {
    private final Engine engine;
    private final boolean renamerMode;
    private final ButtonGroup buttonGroup;
    private JComboBox<MoviePreviewContainer> cbMovieForPreview;
    private JComboBox<EntityContainer> cbEntity;
    private JTextArea taJmteTokens;
    private JRadioButton btnPureJmte;
    private JRadioButton btnRenamerFoldername;
    private JButton btnGetFolderPattern;
    private JButton btnSetFolderPattern;
    private JRadioButton btnRenamerFilename;
    private JButton btnGetFilePattern;
    private JButton btnSetFilePattern;
    private JTextArea taResult;
    private JTextArea taError;
    private JLabel lblEntityTemplate;
    private TmmTable tableExamples;
    private final EventList<RenamerExample> exampleEventList;
    private final EventList<EntityExample> entityExampleEventList;
    private final EventList<RendererExample> rendererExampleList;

    public MovieJmteExplorerDialog(Window owner) {
        super(owner, TmmResourceBundle.getString("jmteexplorer.title"), "moviejmteexplorer");
        this.setMinimumSize(new Dimension(900, 600));
        this.engine = MovieRenamer.createEngine();
        this.buttonGroup = new ButtonGroup();
        if (owner instanceof SettingsDialog) {
            this.renamerMode = true;
        } else {
            this.renamerMode = false;
            this.setModalityType(Dialog.ModalityType.MODELESS);
        }
        this.exampleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(RenamerExample.class)));
        this.rendererExampleList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(RendererExample.class)));
        this.entityExampleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(EntityExample.class)));
        this.setModal(false);
        this.initComponents();
        this.setListeners();
        this.buildAndInstallMovieArray();
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new CopyShortRenamerTokenAction());
        popupMenu.add(new CopyLongRenamerTokenAction());
        this.tableExamples.addMouseListener(new TablePopupListener(popupMenu, this.tableExamples));
        KeyStroke copy = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false);
        this.tableExamples.registerKeyboardAction(new CopyShortRenamerTokenAction(), "Copy", copy, 0);
        this.tableExamples.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() >= 2 && !e.isConsumed() && e.getButton() == 1 && (row = MovieJmteExplorerDialog.this.tableExamples.getSelectedRow()) > -1) {
                    row = MovieJmteExplorerDialog.this.tableExamples.convertRowIndexToModel(row);
                    RenamerExample example = (RenamerExample)MovieJmteExplorerDialog.this.exampleEventList.get(row);
                    if (StringUtils.isNotBlank((CharSequence)example.token)) {
                        MovieJmteExplorerDialog.this.taJmteTokens.setText(MovieJmteExplorerDialog.this.taJmteTokens.getText() + example.token);
                    } else {
                        MovieJmteExplorerDialog.this.taJmteTokens.setText(MovieJmteExplorerDialog.this.taJmteTokens.getText() + example.longToken);
                    }
                }
            }
        });
    }

    private void initComponents() {
        JPanel panelHeader = new JPanel((LayoutManager)new MigLayout("insets 0", "[grow]", "[][shrink 0][2lp]"));
        JPanel panelTop = new JPanel((LayoutManager)new MigLayout("", "[][][grow]", "[]"));
        panelTop.add((Component)new TmmLabel(TmmResourceBundle.getString("tmm.movie")), "cell 0 0");
        this.cbMovieForPreview = new JComboBox();
        panelTop.add(this.cbMovieForPreview, "cell 1 0, wmin 0");
        JButton btnHelp = new JButton(TmmResourceBundle.getString("tmm.help"));
        btnHelp.addActionListener(e -> {
            String url = StringEscapeUtils.unescapeHtml4((String)"https://www.tinymediamanager.org/docs/movies/renamer");
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception ex) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        panelTop.add((Component)btnHelp, "cell 2 0, trailing");
        panelHeader.add((Component)panelTop, "cell 0 0, growx");
        panelHeader.add((Component)new JSeparator(), "cell 0 1 3 1, grow");
        this.setTopPanel(panelHeader);
        JSplitPane contentPanel = new JSplitPane();
        contentPanel.setContinuousLayout(true);
        contentPanel.setResizeWeight(0.4);
        contentPanel.setOneTouchExpandable(true);
        contentPanel.setName("movieJmteExplorer.splitPane");
        MainTabbedPane tabbedPane = new MainTabbedPane(){

            @Override
            public void updateUI() {
                this.putClientProperty("rightBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                this.putClientProperty("roundEdge", Boolean.FALSE);
                super.updateUI();
            }
        };
        tabbedPane.add(TmmResourceBundle.getString("jmteexplorer.commontokens"), this.createExamplesPanel());
        tabbedPane.add(TmmResourceBundle.getString("jmteexplorer.renderer"), this.createRendererPanel());
        tabbedPane.add(TmmResourceBundle.getString("jmteexplorer.entities"), this.createEntitiesPanel());
        contentPanel.setLeftComponent(tabbedPane);
        tabbedPane = new MainTabbedPane(){

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                this.putClientProperty("roundEdge", Boolean.FALSE);
                super.updateUI();
            }
        };
        tabbedPane.add(TmmResourceBundle.getString("jmteexplorer.tryyourself"), this.createPlaygroundPanel());
        contentPanel.setRightComponent(tabbedPane);
        this.add(contentPanel);
        if (this.renamerMode) {
            JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.cancel"));
            btnCancel.setIcon(IconManager.CANCEL_INV);
            btnCancel.addActionListener(e -> {
                this.taJmteTokens.setText("");
                this.setVisible(false);
            });
            this.addButton(btnCancel);
            JButton btnDone = new JButton(TmmResourceBundle.getString("Button.apply"));
            btnDone.setIcon(IconManager.APPLY_INV);
            btnDone.addActionListener(e -> this.setVisible(false));
            this.addButton(btnDone);
        } else {
            JButton btnDone = new JButton(TmmResourceBundle.getString("Button.close"));
            btnDone.setIcon(IconManager.APPLY_INV);
            btnDone.addActionListener(e -> this.setVisible(false));
            this.addButton(btnDone);
        }
        TmmUILayoutStore.getInstance().install(contentPanel);
    }

    private void buildAndInstallMovieArray() {
        ArrayList<Movie> allMovies = new ArrayList<Movie>(MovieModuleManager.getInstance().getMovieList().getMovies());
        Movie sel = MovieUIModule.getInstance().getSelectionModel().getSelectedMovie();
        allMovies.sort(Comparator.comparing(MediaEntity::getTitle));
        for (Movie movie : allMovies) {
            MoviePreviewContainer container = new MoviePreviewContainer();
            container.movie = movie;
            this.cbMovieForPreview.addItem(container);
            if (!movie.equals(sel)) continue;
            this.cbMovieForPreview.setSelectedItem(container);
        }
    }

    private void updateExamples() {
        Movie movie = null;
        Object object = this.cbMovieForPreview.getSelectedItem();
        if (object instanceof MoviePreviewContainer) {
            MoviePreviewContainer container = (MoviePreviewContainer)object;
            movie = container.movie;
        }
        for (AbstractModelObject example : this.exampleEventList) {
            ((RenamerExample)example).createExample(movie);
        }
        for (AbstractModelObject example : this.rendererExampleList) {
            ((RendererExample)example).createResult(movie);
        }
        this.createEntityExamples(movie);
        this.createRenamerExample();
    }

    private void createRenamerExample() {
        Movie movie = null;
        Object object = this.cbMovieForPreview.getSelectedItem();
        if (object instanceof MoviePreviewContainer) {
            MoviePreviewContainer container = (MoviePreviewContainer)object;
            movie = container.movie;
        }
        if (movie != null) {
            String result = "";
            if (StringUtils.isNotBlank((CharSequence)this.taJmteTokens.getText())) {
                try {
                    if (this.btnPureJmte.isSelected()) {
                        result = this.processPattern(movie, this.taJmteTokens.getText());
                    } else if (this.btnRenamerFoldername.isSelected()) {
                        result = MovieRenamer.createDestinationForFoldername(this.taJmteTokens.getText(), movie);
                    } else if (this.btnRenamerFilename.isSelected()) {
                        result = MovieRenamer.createDestinationForFilename(this.taJmteTokens.getText(), movie);
                    }
                    this.taError.setText(null);
                }
                catch (Exception e) {
                    this.taError.setText(e.getMessage());
                }
            } else {
                result = "";
                this.taError.setText(null);
            }
            this.taResult.setText(result);
        } else {
            this.taResult.setText(TmmResourceBundle.getString("Settings.movie.renamer.nomovie"));
        }
    }

    private String processPattern(Movie movie, String pattern) throws Exception {
        HashMap<String, MediaEntity> root = new HashMap<String, MediaEntity>();
        root.put("movie", movie);
        if (movie.getMovieSet() != null && (movie.getMovieSet().getMovies().size() > 1 || MovieModuleManager.getInstance().getSettings().isRenamerCreateMoviesetForSingleMovie())) {
            root.put("movieSet", movie.getMovieSet());
        }
        return this.engine.transform(JmteUtils.morphTemplate(pattern, MovieRenamer.getTokenMap()), root);
    }

    private JPanel createExamplesPanel() {
        this.exampleEventList.add((Object)new RenamerExample("${title}"));
        this.exampleEventList.add((Object)new RenamerExample("${originalTitle}"));
        this.exampleEventList.add((Object)new RenamerExample("${originalFilename}"));
        this.exampleEventList.add((Object)new RenamerExample("${originalBasename}"));
        this.exampleEventList.add((Object)new RenamerExample("${title[0]}"));
        this.exampleEventList.add((Object)new RenamerExample("${title;first}"));
        this.exampleEventList.add((Object)new RenamerExample("${title[0,2]}"));
        this.exampleEventList.add((Object)new RenamerExample("${titleSortable}"));
        this.exampleEventList.add((Object)new RenamerExample("${releaseDate}"));
        this.exampleEventList.add((Object)new RenamerExample("${year}"));
        this.exampleEventList.add((Object)new RenamerExample("${movieSet.title}"));
        this.exampleEventList.add((Object)new RenamerExample("${movieSet.titleSortable}"));
        this.exampleEventList.add((Object)new RenamerExample("${movieSetIndex}"));
        this.exampleEventList.add((Object)new RenamerExample("${rating}"));
        this.exampleEventList.add((Object)new RenamerExample("${imdb}"));
        this.exampleEventList.add((Object)new RenamerExample("${tmdb}"));
        this.exampleEventList.add((Object)new RenamerExample("${certification}"));
        this.exampleEventList.add((Object)new RenamerExample("${directors[0].name}"));
        this.exampleEventList.add((Object)new RenamerExample("${actors[0].name}"));
        this.exampleEventList.add((Object)new RenamerExample("${genres[0]}"));
        this.exampleEventList.add((Object)new RenamerExample("${genres[0].name}"));
        this.exampleEventList.add((Object)new RenamerExample("${genresAsString}"));
        this.exampleEventList.add((Object)new RenamerExample("${tags[0]}"));
        this.exampleEventList.add((Object)new RenamerExample("${productionCompany}"));
        this.exampleEventList.add((Object)new RenamerExample("${productionCompanyAsArray[0]}"));
        this.exampleEventList.add((Object)new RenamerExample("${language}"));
        this.exampleEventList.add((Object)new RenamerExample("${videoResolution}"));
        this.exampleEventList.add((Object)new RenamerExample("${aspectRatio}"));
        this.exampleEventList.add((Object)new RenamerExample("${aspectRatio2}"));
        this.exampleEventList.add((Object)new RenamerExample("${videoCodec}"));
        this.exampleEventList.add((Object)new RenamerExample("${videoFormat}"));
        this.exampleEventList.add((Object)new RenamerExample("${videoBitDepth}"));
        this.exampleEventList.add((Object)new RenamerExample("${videoBitRate}"));
        this.exampleEventList.add((Object)new RenamerExample("${framerate}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioCodec}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioCodecList}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioCodecsAsString}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioChannels}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioChannelList}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioChannelsAsString}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioChannelsDot}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioChannelDotList}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioChannelsDotAsString}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioLanguage}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioLanguageList}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioLanguagesAsString}"));
        this.exampleEventList.add((Object)new RenamerExample("${subtitleLanguageList}"));
        this.exampleEventList.add((Object)new RenamerExample("${subtitleLanguagesAsString}"));
        this.exampleEventList.add((Object)new RenamerExample("${mediaSource}"));
        this.exampleEventList.add((Object)new RenamerExample("${3Dformat}"));
        this.exampleEventList.add((Object)new RenamerExample("${hdr}"));
        this.exampleEventList.add((Object)new RenamerExample("${hdrformat}"));
        this.exampleEventList.add((Object)new RenamerExample("${filesize}"));
        this.exampleEventList.add((Object)new RenamerExample("${edition}"));
        this.exampleEventList.add((Object)new RenamerExample("${parent}"));
        this.exampleEventList.add((Object)new RenamerExample("${note}"));
        this.exampleEventList.add((Object)new RenamerExample("${decadeShort}"));
        this.exampleEventList.add((Object)new RenamerExample("${decadeLong}"));
        this.exampleEventList.add((Object)new RenamerExample("${crc32}"));
        this.tableExamples = new TmmTable((TableModel)((Object)new TmmTableModel<RenamerExample>((EventList<RenamerExample>)GlazedListsSwing.swingThreadProxyList(this.exampleEventList), new RenamerExampleTableFormat())));
        NoBorderScrollPane scrollPane = new NoBorderScrollPane();
        this.tableExamples.configureScrollPane(scrollPane);
        this.tableExamples.setRowHeight(35);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "[grow]", "[grow]"));
        panel.add((Component)scrollPane, "cell 0 0, grow");
        return panel;
    }

    private JPanel createRendererPanel() {
        this.rendererExampleList.add((Object)new RendererExample("--- string renderers ---"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.title;upper}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.title;lower}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.title;first}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.genresAsString;split(0,2)}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.title;replace(a,XX)}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.title;replace(umlauts.csv)}"));
        this.rendererExampleList.add((Object)new RendererExample("--- arrays ---"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.genres}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.genres;array}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.genres[0]}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.genres[0,2]}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.mediaInfoAudioLanguageList;uniqueArray}"));
        this.rendererExampleList.add((Object)new RendererExample("--- format ---"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.releaseDate;date(yyyy-MM-dd)}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.ratings.imdb.rating;number(%.0f)}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.videofilesize;filesize(G)}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.mediaInfoVideoBitrate;bitrate(Mbps)}"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.mediaInfoFrameRate;framerate(round)}"));
        this.rendererExampleList.add((Object)new RendererExample("--- enhanced ---"));
        this.rendererExampleList.add((Object)new RendererExample("${movie.title;chain(replace(a,XX);lower)}"));
        TmmTable tableRendererExamples = new TmmTable((TableModel)((Object)new TmmTableModel<RendererExample>((EventList<RendererExample>)GlazedListsSwing.swingThreadProxyList(this.rendererExampleList), new RendererExampleTableFormat())));
        JScrollPane scrollPane = new JScrollPane();
        tableRendererExamples.configureScrollPane(scrollPane);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "[grow]", "[grow]"));
        panel.add((Component)scrollPane, "cell 0 0, grow");
        return panel;
    }

    private JPanel createEntitiesPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "[grow]", "[][][grow]"));
        Vector<EntityContainer> entityContainers = new Vector<EntityContainer>();
        entityContainers.add(new EntityContainer());
        entityContainers.add(new EntityContainer(Movie.class, "${movie}", movie -> movie));
        entityContainers.add(new EntityContainer(MediaFile.class, "${movie.mainVideoFile}", Movie::getMainVideoFile));
        entityContainers.add(new EntityContainer(Person.class, "${movie.actors[0]}", movie -> ListUtils.getFirst(movie.getActors())));
        entityContainers.add(new EntityContainer(MediaTrailer.class, "${movie.trailer[0]}", movie -> ListUtils.getFirst(movie.getTrailer())));
        entityContainers.add(new EntityContainer(MediaGenres.class, "${movie.genres[0]}", movie -> ListUtils.getFirst(movie.getGenres())));
        entityContainers.add(new EntityContainer(MediaFileAudioStream.class, "${movie.mainVideoFile.audioStreams[0]}", movie -> ListUtils.getFirst(movie.getMainVideoFile().getAudioStreams())));
        entityContainers.add(new EntityContainer(MediaFileSubtitle.class, "${movie.mainVideoFile.subtitles[0]}", movie -> ListUtils.getFirst(movie.getMainVideoFile().getSubtitles())));
        panel.add((Component)new TmmLabel(TmmResourceBundle.getString("jmteexplorer.entity")), "cell 0 0");
        this.cbEntity = new JComboBox(entityContainers);
        panel.add(this.cbEntity, "cell 0 0");
        panel.add((Component)new TmmLabel(TmmResourceBundle.getString("jmteexplorer.pattern")), "cell 0 1");
        this.lblEntityTemplate = new JLabel("");
        panel.add((Component)this.lblEntityTemplate, "cell 0 1, growx, wmin 0");
        TmmTable tableEntityExamples = new TmmTable((TableModel)((Object)new TmmTableModel<EntityExample>((EventList<EntityExample>)GlazedListsSwing.swingThreadProxyList(this.entityExampleEventList), new EntityExampleTableFormat())));
        JScrollPane scrollPane = new JScrollPane();
        tableEntityExamples.configureScrollPane(scrollPane);
        panel.add((Component)scrollPane, "cell 0 2, grow");
        return panel;
    }

    private JPanel createPlaygroundPanel() {
        JPanel panelContent = new JPanel((LayoutManager)new MigLayout("insets 0", "[grow]", "[]10lp![shrink 0]10lp![]"));
        JPanel panelTop = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[grow][]", "[][50lp:n][][][][]10lp![]"));
        panelTop.add((Component)new TmmLabel(TmmResourceBundle.getString("jmteexplorer.pattern")), "cell 0 0");
        JButton btnHelp = new JButton(TmmResourceBundle.getString("tmm.help.jmte"));
        btnHelp.addActionListener(e -> {
            String url = StringEscapeUtils.unescapeHtml4((String)"https://www.tinymediamanager.org/docs/jmte");
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception ex) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        panelTop.add((Component)btnHelp, "cell 1 0, trailing");
        this.taJmteTokens = new TmmRoundMultilineTextArea();
        panelTop.add((Component)this.taJmteTokens, "cell 0 1 2 1, grow, wmin 0");
        this.btnPureJmte = new JRadioButton(TmmResourceBundle.getString("jmteexplorer.purejmte"));
        this.buttonGroup.add(this.btnPureJmte);
        this.btnRenamerFoldername = new JRadioButton(TmmResourceBundle.getString("jmteexplorer.foldername"));
        this.buttonGroup.add(this.btnRenamerFoldername);
        this.btnRenamerFilename = new JRadioButton(TmmResourceBundle.getString("jmteexplorer.filename"));
        this.buttonGroup.add(this.btnRenamerFilename);
        this.btnGetFolderPattern = new SquareIconButton(IconManager.FILE_IMPORT_INV);
        this.btnGetFolderPattern.setToolTipText(TmmResourceBundle.getString("jmteexplorer.foldername.import"));
        this.btnGetFolderPattern.addActionListener(e -> {
            this.taJmteTokens.setText(MovieModuleManager.getInstance().getSettings().getRenamerPathname());
            this.createRenamerExample();
        });
        this.btnSetFolderPattern = new SquareIconButton(IconManager.FILE_EXPORT_INV);
        this.btnSetFolderPattern.setToolTipText(TmmResourceBundle.getString("jmteexplorer.foldername.export"));
        this.btnSetFolderPattern.addActionListener(e -> MovieModuleManager.getInstance().getSettings().setRenamerPathname(this.taJmteTokens.getText()));
        this.btnGetFilePattern = new SquareIconButton(IconManager.FILE_IMPORT_INV);
        this.btnGetFilePattern.setToolTipText(TmmResourceBundle.getString("jmteexplorer.filename.import"));
        this.btnGetFilePattern.addActionListener(e -> {
            this.taJmteTokens.setText(MovieModuleManager.getInstance().getSettings().getRenamerFilename());
            this.createRenamerExample();
        });
        this.btnSetFilePattern = new SquareIconButton(IconManager.FILE_EXPORT_INV);
        this.btnSetFilePattern.setToolTipText(TmmResourceBundle.getString("jmteexplorer.filename.export"));
        this.btnSetFilePattern.addActionListener(e -> MovieModuleManager.getInstance().getSettings().setRenamerFilename(this.taJmteTokens.getText()));
        if (this.renamerMode) {
            panelTop.add((Component)new TmmLabel(TmmResourceBundle.getString("jmteexplorer.processmode")), "cell 0 2 2 1, gaptop 10lp");
            panelTop.add((Component)this.btnPureJmte, "cell 0 3");
            panelTop.add((Component)this.btnRenamerFoldername, "cell 0 4");
            panelTop.add((Component)this.btnGetFolderPattern, "cell 1 4, trailing");
            this.btnGetFolderPattern.setVisible(false);
            panelTop.add((Component)this.btnSetFolderPattern, "cell 1 4, trailing");
            this.btnSetFolderPattern.setVisible(false);
            panelTop.add((Component)this.btnRenamerFilename, "cell 0 5");
            panelTop.add((Component)this.btnGetFilePattern, "cell 1 5, trailing");
            this.btnGetFilePattern.setVisible(false);
            panelTop.add((Component)this.btnSetFilePattern, "cell 1 5, trailing");
            this.btnSetFilePattern.setVisible(false);
            this.btnPureJmte.addActionListener(e -> this.setImportExportButtons());
            this.btnRenamerFoldername.addActionListener(e -> this.setImportExportButtons());
            this.btnRenamerFilename.addActionListener(e -> this.setImportExportButtons());
        }
        this.btnPureJmte.setSelected(true);
        this.taError = new ReadOnlyTextArea("");
        TmmFontHelper.changeFont((JComponent)this.taError, 1);
        this.taError.setForeground(Color.RED);
        panelTop.add((Component)this.taError, "cell 0 5 2 1, grow, wmin 0");
        panelContent.add((Component)panelTop, "cell 0 0, growx");
        panelContent.add((Component)new JSeparator(), "cell 0 1, growx");
        JPanel panelBottom = new JPanel((LayoutManager)new MigLayout("", "[grow]", "[][grow]"));
        panelBottom.add((Component)new TmmLabel(TmmResourceBundle.getString("jmteexplorer.result")), "cell 0 0, grow, wmin 0");
        this.taResult = new ReadOnlyTextArea();
        panelBottom.add((Component)this.taResult, "cell 0 1, grow, wmin 0");
        panelContent.add((Component)panelBottom, "cell 0 2, grow");
        return panelContent;
    }

    private void setImportExportButtons() {
        if (this.btnPureJmte.isSelected()) {
            this.btnGetFolderPattern.setVisible(false);
            this.btnSetFolderPattern.setVisible(false);
            this.btnGetFilePattern.setVisible(false);
            this.btnSetFilePattern.setVisible(false);
        } else if (this.btnRenamerFoldername.isSelected()) {
            this.btnGetFolderPattern.setVisible(true);
            this.btnSetFolderPattern.setVisible(true);
            this.btnGetFilePattern.setVisible(false);
            this.btnSetFilePattern.setVisible(false);
        } else if (this.btnRenamerFilename.isSelected()) {
            this.btnGetFolderPattern.setVisible(false);
            this.btnSetFolderPattern.setVisible(false);
            this.btnGetFilePattern.setVisible(true);
            this.btnSetFilePattern.setVisible(true);
        }
        this.createRenamerExample();
    }

    private void setListeners() {
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                MovieJmteExplorerDialog.this.createRenamerExample();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                MovieJmteExplorerDialog.this.createRenamerExample();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                MovieJmteExplorerDialog.this.createRenamerExample();
            }
        };
        this.taJmteTokens.getDocument().addDocumentListener(documentListener);
        this.cbMovieForPreview.addActionListener(e -> this.updateExamples());
        this.cbEntity.addActionListener(e -> {
            Movie movie = null;
            Object patt28668$temp = this.cbMovieForPreview.getSelectedItem();
            if (patt28668$temp instanceof MoviePreviewContainer) {
                MoviePreviewContainer container = (MoviePreviewContainer)patt28668$temp;
                movie = container.movie;
            }
            this.createEntityExamples(movie);
        });
    }

    private void createEntityExamples(Movie movie) {
        this.entityExampleEventList.clear();
        Object selectedItem = this.cbEntity.getSelectedItem();
        if (!(selectedItem instanceof EntityContainer)) {
            return;
        }
        EntityContainer entityContainer = (EntityContainer)selectedItem;
        if (entityContainer.clazz == null) {
            return;
        }
        this.lblEntityTemplate.setText(entityContainer.getTemplate());
        try {
            PropertyDescriptor[] pds = Introspector.getBeanInfo(entityContainer.getEntity(movie).getClass()).getPropertyDescriptors();
            this.entityExampleEventList.clear();
            for (PropertyDescriptor descriptor : pds) {
                if ("class".equals(descriptor.getDisplayName()) || "declaringClass".equals(descriptor.getDisplayName()) || descriptor.getReadMethod() == null) continue;
                try {
                    String title = descriptor.getDisplayName();
                    this.entityExampleEventList.add((Object)new EntityExample(title, this.processPattern(movie, entityContainer.getTemplate().replace("}", "." + title + "}"))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class RenamerExample
    extends AbstractModelObject {
        private static final Pattern TOKEN_PATTERN = Pattern.compile("^\\$\\{(.*?)([\\}\\[;\\.]+.*)");
        private final String token;
        private final String completeToken;
        private String longToken = "";
        private String description;
        private String example = "";

        private RenamerExample(String token) {
            this.token = token;
            this.completeToken = this.createCompleteToken();
            try {
                this.description = TmmResourceBundle.getString("Settings.movie.renamer." + token);
            }
            catch (Exception e) {
                this.description = "";
            }
        }

        private String createCompleteToken() {
            Object result = this.token;
            Matcher matcher = TOKEN_PATTERN.matcher(this.token);
            if (matcher.find() && matcher.groupCount() > 1) {
                String alias = matcher.group(1);
                String sourceToken = MovieRenamer.getTokenMap().get(alias);
                if (StringUtils.isNotBlank((CharSequence)sourceToken)) {
                    result = "<html>" + this.token + "<br>${" + sourceToken + matcher.group(2) + "</html>";
                    this.longToken = "${" + sourceToken + matcher.group(2);
                }
            }
            return result;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getExample() {
            return this.example;
        }

        public void setExample(String example) {
            this.example = example;
        }

        private void createExample(Movie movie) {
            String oldValue = this.example;
            if (movie == null) {
                this.example = "";
            } else {
                try {
                    this.example = MovieJmteExplorerDialog.this.processPattern(movie, this.token);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.firePropertyChange("example", oldValue, this.example);
        }
    }

    private class RendererExample
    extends AbstractModelObject {
        private final String token;
        private String result;

        RendererExample(String token) {
            this.token = token;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public void createResult(Movie movie) {
            String oldValue = this.result;
            if (movie == null || this.token.startsWith("---")) {
                this.result = "";
            } else {
                try {
                    this.result = MovieJmteExplorerDialog.this.processPattern(movie, this.token);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.firePropertyChange("result", oldValue, this.result);
        }
    }

    private static class EntityExample
    extends AbstractModelObject {
        private final String title;
        private final String result;

        private EntityExample(String title, String result) {
            this.title = title;
            this.result = result;
        }
    }

    private class CopyShortRenamerTokenAction
    extends AbstractAction {
        CopyShortRenamerTokenAction() {
            this.putValue("SwingLargeIconKey", IconManager.COPY);
            this.putValue("SmallIcon", IconManager.COPY);
            this.putValue("Name", TmmResourceBundle.getString("renamer.copytoken"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("renamer.copytoken"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieJmteExplorerDialog.this.tableExamples.getSelectedRow();
            if (row > -1) {
                row = MovieJmteExplorerDialog.this.tableExamples.convertRowIndexToModel(row);
                RenamerExample example = (RenamerExample)MovieJmteExplorerDialog.this.exampleEventList.get(row);
                StringSelection stringSelection = new StringSelection(example.token);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        }
    }

    private class CopyLongRenamerTokenAction
    extends AbstractAction {
        CopyLongRenamerTokenAction() {
            this.putValue("SwingLargeIconKey", IconManager.COPY);
            this.putValue("SmallIcon", IconManager.COPY);
            this.putValue("Name", TmmResourceBundle.getString("renamer.copytoken.long"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("renamer.copytoken.long"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieJmteExplorerDialog.this.tableExamples.getSelectedRow();
            if (row > -1) {
                row = MovieJmteExplorerDialog.this.tableExamples.convertRowIndexToModel(row);
                RenamerExample example = (RenamerExample)MovieJmteExplorerDialog.this.exampleEventList.get(row);
                StringSelection stringSelection = new StringSelection(example.longToken);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        }
    }

    private static class MoviePreviewContainer {
        Movie movie;

        private MoviePreviewContainer() {
        }

        public String toString() {
            return this.movie.getTitle();
        }
    }

    private static class RenamerExampleTableFormat
    extends TmmTableFormat<RenamerExample> {
        public RenamerExampleTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.token.name"), "name", token -> token.completeToken, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.token"), "description", token -> token.description, String.class);
            col.setCellRenderer(new MultilineTableCellRenderer());
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.value"), "value", token -> token.example, String.class);
            col.setCellRenderer(new MultilineTableCellRenderer());
            this.addColumn(col);
        }
    }

    private static class RendererExampleTableFormat
    extends TmmTableFormat<RendererExample> {
        public RendererExampleTableFormat() {
            TmmTableFormat.Column title = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.token.name"), "token", example -> example.token, String.class);
            this.addColumn(title);
            TmmTableFormat.Column result = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.value"), "result", example -> example.result, String.class);
            this.addColumn(result);
        }
    }

    private static class EntityContainer {
        private final Class<?> clazz;
        private final String template;
        private final Function<Movie, Object> function;

        EntityContainer() {
            this.clazz = null;
            this.template = null;
            this.function = null;
        }

        EntityContainer(Class<?> clazz, String template, Function<Movie, Object> function) {
            this.clazz = clazz;
            this.template = template;
            this.function = function;
        }

        public String toString() {
            if (this.clazz != null) {
                return this.clazz.getSimpleName();
            }
            return null;
        }

        public String getTemplate() {
            return this.template;
        }

        public Object getEntity(Movie movie) {
            if (this.function != null) {
                return this.function.apply(movie);
            }
            return null;
        }
    }

    private static class EntityExampleTableFormat
    extends TmmTableFormat<EntityExample> {
        private EntityExampleTableFormat() {
            TmmTableFormat.Column title = new TmmTableFormat.Column(this, TmmResourceBundle.getString("jmteexplorer.property"), "property", entityExample -> entityExample.title, String.class);
            this.addColumn(title);
            TmmTableFormat.Column result = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.value"), "result", entityExample -> entityExample.result, String.class);
            this.addColumn(result);
        }
    }
}

