/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractNumberMovieFilter;

public class MovieFanartSizeFilter
extends AbstractNumberMovieFilter {
    public MovieFanartSizeFilter() {
        this.spinnerLow.setEditor(this.prepareNumberEditor(this.spinnerLow, "####0 px"));
        this.spinnerHigh.setEditor(this.prepareNumberEditor(this.spinnerHigh, "####0 px"));
    }

    @Override
    public String getId() {
        return "movieFanartSize";
    }

    @Override
    protected SpinnerNumberModel getNumberModel() {
        return new SpinnerNumberModel(0, 0, 99999, 1);
    }

    @Override
    public boolean accept(Movie movie) {
        ITmmUIFilter.FilterOption filterOption = this.getFilterOption();
        int low = (Integer)this.spinnerLow.getValue();
        int high = (Integer)this.spinnerHigh.getValue();
        int fanartWidth = movie.getArtworkDimension((MediaFileType)MediaFileType.FANART).width;
        if (fanartWidth == 0) {
            return false;
        }
        if (filterOption == ITmmUIFilter.FilterOption.EQ && fanartWidth == low) {
            return true;
        }
        if (filterOption == ITmmUIFilter.FilterOption.LT && fanartWidth < low) {
            return true;
        }
        if (filterOption == ITmmUIFilter.FilterOption.LE && fanartWidth <= low) {
            return true;
        }
        if (filterOption == ITmmUIFilter.FilterOption.GE && fanartWidth >= low) {
            return true;
        }
        if (filterOption == ITmmUIFilter.FilterOption.GT && fanartWidth > low) {
            return true;
        }
        return filterOption == ITmmUIFilter.FilterOption.BT && low <= fanartWidth && fanartWidth <= high;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("filter.fanart.width"));
    }
}

