/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JLabel;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieMediaFilesFilter
extends AbstractCheckComboBoxMovieUIFilter<MediaFileTypeContainer> {
    public MovieMediaFilesFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        ArrayList<MediaFileTypeContainer> mediaFileTypeList = new ArrayList<MediaFileTypeContainer>();
        block3: for (MediaFileType type : MediaFileType.values()) {
            switch (type) {
                case VIDEO_EXTRA: 
                case GRAPHIC: 
                case DOUBLE_EXT: {
                    continue block3;
                }
                default: {
                    mediaFileTypeList.add(new MediaFileTypeContainer(type));
                }
            }
        }
        this.setValues(mediaFileTypeList);
    }

    @Override
    protected String parseTypeToString(MediaFileTypeContainer container) throws Exception {
        return container.type.name();
    }

    @Override
    protected MediaFileTypeContainer parseStringToType(String string) throws Exception {
        return new MediaFileTypeContainer(MediaFileType.valueOf(string));
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.mediatype"));
    }

    @Override
    public String getId() {
        return "movieMediaFiles";
    }

    @Override
    public boolean accept(Movie movie) {
        boolean isValid = false;
        ArrayList<MediaFileType> selectedItems = new ArrayList<MediaFileType>();
        for (MediaFileTypeContainer container : this.checkComboBox.getSelectedItems()) {
            selectedItems.add(container.type);
        }
        for (MediaFile mf : movie.getMediaFiles()) {
            if (!selectedItems.contains((Object)mf.getType())) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    public static class MediaFileTypeContainer {
        private final MediaFileType type;

        public MediaFileTypeContainer(MediaFileType type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MediaFileTypeContainer that = (MediaFileTypeContainer)o;
            return this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type});
        }

        public String toString() {
            try {
                return TmmResourceBundle.getString("mediafiletype." + this.type.name().toLowerCase(Locale.ROOT));
            }
            catch (Exception e) {
                return this.type.toString();
            }
        }
    }
}

