/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieMissingMetadataFilter
extends AbstractCheckComboBoxMovieUIFilter<MetadataField> {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieMissingMetadataFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        ArrayList<MetadataField> values = new ArrayList<MetadataField>();
        for (MovieScraperMetadataConfig config : MovieScraperMetadataConfig.values()) {
            if (!config.isMetaData() && !config.isCast()) continue;
            values.add(new MetadataField(config));
        }
        this.setValues(values);
    }

    @Override
    public String getId() {
        return "movieMissingMetadata";
    }

    @Override
    protected String parseTypeToString(MetadataField type) throws Exception {
        return type.config.name();
    }

    @Override
    protected MetadataField parseStringToType(String string) throws Exception {
        try {
            return new MetadataField(MovieScraperMetadataConfig.valueOf(string));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean accept(Movie movie) {
        ArrayList<MovieScraperMetadataConfig> values = new ArrayList<MovieScraperMetadataConfig>();
        for (MetadataField metadataField : this.checkComboBox.getSelectedItems()) {
            values.add(metadataField.config);
        }
        return !this.movieList.detectMissingFields(movie, values).isEmpty();
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.missingmetadata"));
    }

    public static class MetadataField {
        private final MovieScraperMetadataConfig config;

        public MetadataField(MovieScraperMetadataConfig config) {
            this.config = config;
        }

        public String toString() {
            return this.config.getDescription();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetadataField that = (MetadataField)o;
            return this.config == that.config;
        }

        public int hashCode() {
            return Objects.hash(this.config);
        }
    }
}

