/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieSubtitleFormatFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieSubtitleFormatFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.buildSubtitleFormatArray();
        this.movieList.addPropertyChangeListener("subtitleFormats", evt -> SwingUtilities.invokeLater(this::buildSubtitleFormatArray));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.subtitleformat"));
    }

    @Override
    public String getId() {
        return "movieSubtitleFormat";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        List<String> codecs = movie.getMediaInfoSubtitleCodecList();
        for (String sel : selectedItems) {
            if (!codecs.contains(sel)) continue;
            return true;
        }
        return false;
    }

    public void buildSubtitleFormatArray() {
        ArrayList<String> subtitleFormats = new ArrayList<String>(this.movieList.getSubtitleFormatsInMovies());
        Collections.sort(subtitleFormats);
        this.setValues(subtitleFormats);
    }
}

