/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieSubtitleLanguageFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieSubtitleLanguageFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.buildSubtitleLanguageArray();
        this.movieList.addPropertyChangeListener("subtitleLanguages", evt -> SwingUtilities.invokeLater(this::buildSubtitleLanguageArray));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.subtitlelanguage"));
    }

    @Override
    public String getId() {
        return "movieSubtitleLanguage";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        List<String> lang = movie.getMediaInfoSubtitleLanguageList();
        for (String sel : selectedItems) {
            if (!lang.contains(sel)) continue;
            return true;
        }
        return false;
    }

    public void buildSubtitleLanguageArray() {
        ArrayList<String> subtitleLanguages = new ArrayList<String>(this.movieList.getSubtitleLanguagesInMovies());
        Collections.sort(subtitleLanguages);
        this.setValues(subtitleLanguages);
    }
}

