/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractNumberMovieFilter;

public class MovieVideoFilesizeFilter
extends AbstractNumberMovieFilter {
    public MovieVideoFilesizeFilter() {
        this.spinnerLow.setEditor(this.prepareNumberEditor(this.spinnerLow, "#####0 M"));
        this.spinnerHigh.setEditor(this.prepareNumberEditor(this.spinnerHigh, "#####0 M"));
    }

    @Override
    public String getId() {
        return "movieFilesize";
    }

    @Override
    protected SpinnerNumberModel getNumberModel() {
        return new SpinnerNumberModel(0, 0, 999999, 1);
    }

    @Override
    public boolean accept(Movie movie) {
        return this.matchInt((int)((float)movie.getVideoFilesize() / 1000000.0f));
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.filesize"));
    }
}

