/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractMovieUIFilter;

public class MovieWatchedFilter
extends AbstractMovieUIFilter {
    private JComboBox<WatchedFlag> combobox;

    @Override
    public String getId() {
        return "movieWatched";
    }

    @Override
    public String getFilterValueAsString() {
        try {
            return ((WatchedFlag)((Object)this.combobox.getSelectedItem())).name();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setFilterValue(Object value) {
        WatchedFlag watchedFlag;
        if (value == null) {
            return;
        }
        if (value instanceof WatchedFlag) {
            this.combobox.setSelectedItem(value);
        } else if (value instanceof String && (watchedFlag = WatchedFlag.valueOf((String)value)) != null) {
            this.combobox.setSelectedItem((Object)watchedFlag);
        }
    }

    @Override
    public void clearFilter() {
        this.combobox.setSelectedItem((Object)this.combobox.getItemAt(0));
    }

    @Override
    public boolean accept(Movie movie) {
        return !(movie.isWatched() ^ this.combobox.getSelectedItem() == WatchedFlag.WATCHED);
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.watched"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.combobox = new JComboBox<WatchedFlag>(WatchedFlag.values());
        return this.combobox;
    }

    private static enum WatchedFlag {
        WATCHED(TmmResourceBundle.getString("metatag.watched")),
        NOT_WATCHED(TmmResourceBundle.getString("metatag.notwatched"));

        private final String title;

        private WatchedFlag(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

