/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.time.LocalDate;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractNumberMovieFilter;

public class MovieYearFilter
extends AbstractNumberMovieFilter {
    public MovieYearFilter() {
        this.spinnerLow.setEditor(new JSpinner.NumberEditor(this.spinnerLow, "###0"));
        this.spinnerHigh.setEditor(new JSpinner.NumberEditor(this.spinnerHigh, "###0"));
    }

    @Override
    public String getId() {
        return "movieYear";
    }

    @Override
    public void clearFilter() {
        this.spinnerLow.setValue(LocalDate.now().getYear());
        this.spinnerHigh.setValue(LocalDate.now().getYear());
    }

    @Override
    public void setFilterValue(Object value) {
        String[] values = value.toString().split(",");
        if (values.length > 0) {
            this.spinnerLow.setValue(MetadataUtil.parseInt(values[0], LocalDate.now().getYear()));
        }
        if (values.length > 1) {
            this.spinnerHigh.setValue(MetadataUtil.parseInt(values[1], LocalDate.now().getYear()));
        }
    }

    @Override
    protected SpinnerNumberModel getNumberModel() {
        return new SpinnerNumberModel(LocalDate.now().getYear(), 1800, 2100, 1);
    }

    @Override
    public boolean accept(Movie movie) {
        return this.matchInt(movie.getYear());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.year"));
    }
}

