/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.JHintCheckBox;

public class MovieScraperMetadataPanel
extends JPanel {
    private static final int COL_COUNT = 6;
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final Map<MovieScraperMetadataConfig, JCheckBox> checkboxes = new LinkedHashMap<MovieScraperMetadataConfig, JCheckBox>();

    public MovieScraperMetadataPanel() {
        ItemListener checkBoxListener = e -> this.checkChanges();
        this.initComponents();
        for (MovieScraperMetadataConfig value : this.settings.getScraperMetadataConfig()) {
            JCheckBox checkBox = this.checkboxes.get(value);
            if (checkBox == null) continue;
            checkBox.setSelected(true);
        }
        for (JCheckBox checkBox : this.checkboxes.values()) {
            checkBox.addItemListener(checkBoxListener);
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        gbc.ipadx = 10;
        for (MovieScraperMetadataConfig value : MovieScraperMetadataConfig.values()) {
            if (!value.isMetaData() || value == MovieScraperMetadataConfig.ID) continue;
            this.addCheckbox(value, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        for (MovieScraperMetadataConfig value : MovieScraperMetadataConfig.values()) {
            if (!value.isCast()) continue;
            this.addCheckbox(value, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        for (MovieScraperMetadataConfig value : MovieScraperMetadataConfig.values()) {
            if (!value.isArtwork()) continue;
            this.addCheckbox(value, gbc);
        }
        JPanel panel = new JPanel();
        JButton btnSelectAll = new JButton(IconManager.CHECK_ALL);
        panel.add(btnSelectAll);
        btnSelectAll.setToolTipText(TmmResourceBundle.getString("Button.select.all"));
        btnSelectAll.addActionListener(e -> this.setCheckBoxState(true));
        JButton btnDeSelectAll = new JButton(IconManager.CLEAR_ALL);
        panel.add(btnDeSelectAll);
        btnDeSelectAll.setToolTipText(TmmResourceBundle.getString("Button.select.none"));
        btnDeSelectAll.addActionListener(e -> this.setCheckBoxState(false));
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)panel, gbc);
    }

    private void addCheckbox(MovieScraperMetadataConfig config, GridBagConstraints gbc) {
        JCheckBox checkBox;
        if (StringUtils.isNotBlank((CharSequence)config.getToolTip())) {
            checkBox = new JHintCheckBox(config.getDescription());
            checkBox.setToolTipText(config.getToolTip());
            ((JHintCheckBox)checkBox).setHintIcon(IconManager.HINT);
        } else {
            checkBox = new JCheckBox(config.getDescription());
        }
        this.checkboxes.put(config, checkBox);
        if (gbc.gridx >= 6) {
            gbc.gridx = 0;
            ++gbc.gridy;
        }
        this.add((Component)checkBox, gbc);
        ++gbc.gridx;
    }

    private void setCheckBoxState(boolean state) {
        for (JCheckBox checkBox : this.checkboxes.values()) {
            checkBox.setSelected(state);
        }
    }

    private void checkChanges() {
        ArrayList<MovieScraperMetadataConfig> config = new ArrayList<MovieScraperMetadataConfig>();
        for (Map.Entry<MovieScraperMetadataConfig, JCheckBox> entry : this.checkboxes.entrySet()) {
            MovieScraperMetadataConfig key = entry.getKey();
            JCheckBox value = entry.getValue();
            if (!value.isSelected() || config.contains(key)) continue;
            config.add(key);
        }
        this.settings.setScraperMetadataConfig(config);
    }
}

