/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.filenaming.MovieExtraFanartNaming;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.TmmLabel;

class MovieImageExtraPanel
extends JPanel {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final ItemListener checkBoxListener = e -> this.checkChanges();
    private JCheckBox cbActorImages;
    private JCheckBox chckbxEnableExtrathumbs;
    private JCheckBox chckbxEnableExtrafanart;
    private JCheckBox chckbxResizeExtrathumbsTo;
    private JSpinner spExtrathumbWidth;
    private JSpinner spDownloadCountExtrathumbs;
    private JSpinner spDownloadCountExtrafanart;
    private JCheckBox chckbxExtrafanart1;
    private JCheckBox chckbxExtrafanart2;
    private JCheckBox chckbxExtrafanart3;
    private JCheckBox chckbxExtrafanart4;
    private JCheckBox chckbxExtrafanart5;
    private JCheckBox chckbxExtrafanart6;
    private JCheckBox chckbxExtrafanart7;

    MovieImageExtraPanel() {
        this.initComponents();
        this.initDataBindings();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.chckbxExtrafanart1);
        buttonGroup.add(this.chckbxExtrafanart2);
        buttonGroup.add(this.chckbxExtrafanart3);
        buttonGroup.add(this.chckbxExtrafanart4);
        buttonGroup.add(this.chckbxExtrafanart5);
        buttonGroup.add(this.chckbxExtrafanart6);
        buttonGroup.add(this.chckbxExtrafanart7);
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName())) {
                this.buildCheckBoxes();
            }
        });
        this.buildCheckBoxes();
    }

    private void buildCheckBoxes() {
        this.clearSelection(this.chckbxExtrafanart1, this.chckbxExtrafanart2, this.chckbxExtrafanart3, this.chckbxExtrafanart4, this.chckbxExtrafanart5, this.chckbxExtrafanart6, this.chckbxExtrafanart7);
        for (MovieExtraFanartNaming fanart : this.settings.getExtraFanartFilenames()) {
            switch (fanart) {
                case FILENAME_EXTRAFANART: {
                    this.chckbxExtrafanart1.setSelected(true);
                    break;
                }
                case FILENAME_EXTRAFANART2: {
                    this.chckbxExtrafanart2.setSelected(true);
                    break;
                }
                case EXTRAFANART: {
                    this.chckbxExtrafanart3.setSelected(true);
                    break;
                }
                case FOLDER_EXTRAFANART: {
                    this.chckbxExtrafanart4.setSelected(true);
                    break;
                }
                case FILENAME_EXTRABACKDROP: {
                    this.chckbxExtrafanart5.setSelected(true);
                    break;
                }
                case FILENAME_EXTRABACKDROP2: {
                    this.chckbxExtrafanart6.setSelected(true);
                    break;
                }
                case EXTRABACKDROP: {
                    this.chckbxExtrafanart7.setSelected(true);
                }
            }
        }
        this.chckbxExtrafanart1.addItemListener(this.checkBoxListener);
        this.chckbxExtrafanart2.addItemListener(this.checkBoxListener);
        this.chckbxExtrafanart3.addItemListener(this.checkBoxListener);
        this.chckbxExtrafanart4.addItemListener(this.checkBoxListener);
        this.chckbxExtrafanart5.addItemListener(this.checkBoxListener);
        this.chckbxExtrafanart6.addItemListener(this.checkBoxListener);
        this.chckbxExtrafanart7.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.removeItemListener(this.checkBoxListener);
            checkBox.setSelected(false);
        }
    }

    private void checkChanges() {
        this.settings.clearExtraFanartFilenames();
        if (this.chckbxExtrafanart1.isSelected()) {
            this.settings.addExtraFanartFilename(MovieExtraFanartNaming.FILENAME_EXTRAFANART);
        }
        if (this.chckbxExtrafanart2.isSelected()) {
            this.settings.addExtraFanartFilename(MovieExtraFanartNaming.FILENAME_EXTRAFANART2);
        }
        if (this.chckbxExtrafanart3.isSelected()) {
            this.settings.addExtraFanartFilename(MovieExtraFanartNaming.EXTRAFANART);
        }
        if (this.chckbxExtrafanart4.isSelected()) {
            this.settings.addExtraFanartFilename(MovieExtraFanartNaming.FOLDER_EXTRAFANART);
        }
        if (this.chckbxExtrafanart5.isSelected()) {
            this.settings.addExtraFanartFilename(MovieExtraFanartNaming.FILENAME_EXTRABACKDROP);
        }
        if (this.chckbxExtrafanart6.isSelected()) {
            this.settings.addExtraFanartFilename(MovieExtraFanartNaming.FILENAME_EXTRABACKDROP2);
        }
        if (this.chckbxExtrafanart7.isSelected()) {
            this.settings.addExtraFanartFilename(MovieExtraFanartNaming.EXTRABACKDROP);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][]"));
        JPanel panelExtra = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][20lp!][][][10lp!][][20lp!][]"));
        TmmLabel lblExtra = new TmmLabel(TmmResourceBundle.getString("Settings.extraartwork"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelExtra, lblExtra, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#enable-extra-artwork"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.chckbxEnableExtrathumbs = new JCheckBox(TmmResourceBundle.getString("Settings.enable.extrathumbs"));
        panelExtra.add((Component)this.chckbxEnableExtrathumbs, "cell 1 0 2 1");
        this.chckbxResizeExtrathumbsTo = new JCheckBox(TmmResourceBundle.getString("Settings.resize.extrathumbs"));
        panelExtra.add((Component)this.chckbxResizeExtrathumbsTo, "cell 2 1");
        this.spExtrathumbWidth = new JSpinner();
        this.spExtrathumbWidth.setMinimumSize(new Dimension(60, 20));
        panelExtra.add((Component)this.spExtrathumbWidth, "cell 2 1");
        JLabel lblDownload = new JLabel(TmmResourceBundle.getString("Settings.amount.autodownload"));
        panelExtra.add((Component)lblDownload, "cell 2 2");
        this.spDownloadCountExtrathumbs = new JSpinner();
        this.spDownloadCountExtrathumbs.setMinimumSize(new Dimension(60, 20));
        panelExtra.add((Component)this.spDownloadCountExtrathumbs, "cell 2 2");
        this.chckbxEnableExtrafanart = new JCheckBox(TmmResourceBundle.getString("Settings.enable.extrafanart"));
        panelExtra.add((Component)this.chckbxEnableExtrafanart, "cell 1 4 2 1");
        JPanel panelExtraFanart = new JPanel();
        panelExtra.add((Component)panelExtraFanart, "cell 2 5,grow");
        panelExtraFanart.setLayout((LayoutManager)new MigLayout("insets 0", "[][]", "[][][][]"));
        this.chckbxExtrafanart1 = new JCheckBox(TmmResourceBundle.getString("Settings.moviefilename") + "-fanartX." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelExtraFanart.add((Component)this.chckbxExtrafanart1, "flowy,cell 0 0");
        this.chckbxExtrafanart2 = new JCheckBox(TmmResourceBundle.getString("Settings.moviefilename") + ".fanartX." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelExtraFanart.add((Component)this.chckbxExtrafanart2, "cell 0 1");
        this.chckbxExtrafanart3 = new JCheckBox("fanartX." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelExtraFanart.add((Component)this.chckbxExtrafanart3, "cell 0 2");
        this.chckbxExtrafanart4 = new JCheckBox("extrafanart/fanartX." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelExtraFanart.add((Component)this.chckbxExtrafanart4, "cell 0 3");
        this.chckbxExtrafanart5 = new JCheckBox(TmmResourceBundle.getString("Settings.moviefilename") + "-backdropX." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelExtraFanart.add((Component)this.chckbxExtrafanart5, "cell 1 0");
        this.chckbxExtrafanart6 = new JCheckBox(TmmResourceBundle.getString("Settings.moviefilename") + ".backdropX." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelExtraFanart.add((Component)this.chckbxExtrafanart6, "cell 1 1");
        this.chckbxExtrafanart7 = new JCheckBox("backdropX." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelExtraFanart.add((Component)this.chckbxExtrafanart7, "cell 1 2");
        JLabel lblDownloadCount = new JLabel(TmmResourceBundle.getString("Settings.amount.autodownload"));
        panelExtra.add((Component)lblDownloadCount, "cell 2 7");
        this.spDownloadCountExtrafanart = new JSpinner();
        this.spDownloadCountExtrafanart.setMinimumSize(new Dimension(60, 20));
        panelExtra.add((Component)this.spDownloadCountExtrafanart, "cell 2 7");
        this.cbActorImages = new JCheckBox(TmmResourceBundle.getString("Settings.actor.download"));
        panelExtra.add((Component)this.cbActorImages, "cell 1 9 2 1");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"writeActorImages");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.cbActorImages, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"imageExtraFanart");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"imageExtraThumbs");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, (Object)this.chckbxEnableExtrathumbs, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"imageExtraThumbsSize");
        BeanProperty jSpinnerBeanProperty_1 = BeanProperty.create((String)"value");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, (Object)this.spExtrathumbWidth, (Property)jSpinnerBeanProperty_1);
        autoBinding_10.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"imageExtraThumbsResize");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, (Object)this.chckbxResizeExtrathumbsTo, (Property)jCheckBoxBeanProperty);
        autoBinding_11.bind();
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"imageExtraThumbsCount");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, (Object)this.spDownloadCountExtrathumbs, (Property)jSpinnerBeanProperty_1);
        autoBinding_12.bind();
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"imageExtraFanartCount");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, (Object)this.spDownloadCountExtrafanart, (Property)jSpinnerBeanProperty_1);
        autoBinding_13.bind();
        BeanProperty jSpinnerBeanProperty = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.spDownloadCountExtrafanart, (Property)jSpinnerBeanProperty);
        autoBinding_14.bind();
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrathumbs, (Property)jCheckBoxBeanProperty, (Object)this.spDownloadCountExtrathumbs, (Property)jSpinnerBeanProperty);
        autoBinding_15.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrathumbs, (Property)jCheckBoxBeanProperty, (Object)this.chckbxResizeExtrathumbsTo, (Property)jCheckBoxBeanProperty_1);
        autoBinding_8.bind();
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrathumbs, (Property)jCheckBoxBeanProperty, (Object)this.spExtrathumbWidth, (Property)jSpinnerBeanProperty);
        autoBinding_9.bind();
        BeanProperty jCheckBoxBeanProperty_2 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.chckbxExtrafanart1, (Property)jCheckBoxBeanProperty_2);
        autoBinding.bind();
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.chckbxExtrafanart2, (Property)jCheckBoxBeanProperty_2);
        autoBinding_1.bind();
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.chckbxExtrafanart3, (Property)jCheckBoxBeanProperty_2);
        autoBinding_4.bind();
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.chckbxExtrafanart4, (Property)jCheckBoxBeanProperty_2);
        autoBinding_5.bind();
    }
}

