/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.JHintCheckBox;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.panels.MovieScraperMetadataPanel;

class MovieScraperOptionsSettingsPanel
extends JPanel {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private JSlider sliderThreshold;
    private JComboBox<MediaLanguages> cbScraperLanguage;
    private JComboBox<CountryCode> cbCertificationCountry;
    private JComboBox<CountryItem> cbReleaseCountry;
    private JCheckBox chckbxScraperFallback;
    private JCheckBox chckbxCapitalizeWords;
    private JCheckBox chckbxDoNotOverwrite;
    private JHintCheckBox chckbxFetchAllRatings;

    MovieScraperOptionsSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        for (String country : Locale.getISOCountries()) {
            CountryItem item = new CountryItem(new Locale("", country));
            this.cbReleaseCountry.addItem(item);
            if (!item.locale.getCountry().equalsIgnoreCase(this.settings.getReleaseDateCountry())) continue;
            this.cbReleaseCountry.setSelectedItem(item);
        }
        this.cbReleaseCountry.addItemListener(l -> this.settings.setReleaseDateCountry(((CountryItem)this.cbReleaseCountry.getSelectedItem()).locale.getCountry()));
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        ((Dictionary)labelTable).put(100, new JLabel("100"));
        ((Dictionary)labelTable).put(75, new JLabel("75"));
        ((Dictionary)labelTable).put(50, new JLabel("50"));
        ((Dictionary)labelTable).put(25, new JLabel("25"));
        ((Dictionary)labelTable).put(0, new JLabel("0"));
        this.sliderThreshold.setLabelTable(labelTable);
        this.sliderThreshold.setValue((int)(this.settings.getScraperThreshold() * 100.0));
        this.sliderThreshold.addChangeListener(arg0 -> this.settings.setScraperThreshold((double)this.sliderThreshold.getValue() / 100.0));
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[700lp,grow]", "[][]15lp![][15lp!][]"));
        JPanel panelOptions = new JPanel();
        panelOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][10lp!][][][]"));
        TmmLabel lblOptions = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptions, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#advanced-options"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JLabel lblScraperLanguage = new JLabel(TmmResourceBundle.getString("Settings.preferredLanguage"));
        panelOptions.add((Component)lblScraperLanguage, "cell 1 0 2 1");
        this.cbScraperLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        panelOptions.add(this.cbScraperLanguage, "cell 1 0 2 1");
        JLabel lblCountry = new JLabel(TmmResourceBundle.getString("Settings.certificationCountry"));
        panelOptions.add((Component)lblCountry, "cell 1 1 2 1");
        this.cbCertificationCountry = new JComboBox<CountryCode>(CountryCode.values());
        panelOptions.add(this.cbCertificationCountry, "cell 1 1 2 1");
        JLabel label = new JLabel(TmmResourceBundle.getString("Settings.releaseDateCountry"));
        panelOptions.add((Component)label, "flowx,cell 1 2 2 1");
        this.cbReleaseCountry = new JComboBox();
        panelOptions.add(this.cbReleaseCountry, "cell 1 2 2 1");
        this.chckbxFetchAllRatings = new JHintCheckBox(TmmResourceBundle.getString("Settings.fetchallratings"));
        this.chckbxFetchAllRatings.setToolTipText(TmmResourceBundle.getString("Settings.fetchallratings.desc"));
        this.chckbxFetchAllRatings.setHintIcon(IconManager.HINT);
        panelOptions.add((Component)this.chckbxFetchAllRatings, "cell 1 4 2 1");
        this.chckbxScraperFallback = new JCheckBox(TmmResourceBundle.getString("Settings.scraperfallback"));
        panelOptions.add((Component)this.chckbxScraperFallback, "cell 1 5 2 1");
        this.chckbxCapitalizeWords = new JCheckBox(TmmResourceBundle.getString("Settings.scraper.capitalizeWords"));
        panelOptions.add((Component)this.chckbxCapitalizeWords, "cell 1 6 2 1");
        JPanel panelDefaults = new JPanel();
        panelDefaults.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][]"));
        TmmLabel lblDefaultsT = new TmmLabel(TmmResourceBundle.getString("scraper.metadata.defaults"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelDefaults, lblDefaultsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#metadata-scrape-defaults"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx");
        MovieScraperMetadataPanel movieScraperMetadataPanel = new MovieScraperMetadataPanel();
        panelDefaults.add((Component)movieScraperMetadataPanel, "cell 1 0 2 1");
        this.chckbxDoNotOverwrite = new JCheckBox(TmmResourceBundle.getString("message.scrape.donotoverwrite"));
        this.chckbxDoNotOverwrite.setToolTipText(TmmResourceBundle.getString("message.scrape.donotoverwrite.desc"));
        panelDefaults.add((Component)this.chckbxDoNotOverwrite, "cell 1 1 2 1");
        JPanel panelAutomaticScrape = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][][300lp][grow]", ""));
        TmmLabel lblAutomaticScrapeT = new TmmLabel(TmmResourceBundle.getString("Settings.automaticscraper"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelAutomaticScrape, lblAutomaticScrapeT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#automatic-scraper"));
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        JLabel lblScraperThreshold = new JLabel(TmmResourceBundle.getString("Settings.scraperTreshold"));
        panelAutomaticScrape.add((Component)lblScraperThreshold, "cell 1 0,aligny top");
        this.sliderThreshold = new JSlider();
        this.sliderThreshold.setMinorTickSpacing(5);
        this.sliderThreshold.setMajorTickSpacing(10);
        this.sliderThreshold.setSnapToTicks(true);
        this.sliderThreshold.setPaintTicks(true);
        this.sliderThreshold.setPaintLabels(true);
        panelAutomaticScrape.add((Component)this.sliderThreshold, "cell 2 0,growx,aligny top");
        ReadOnlyTextArea tpScraperThresholdHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.scraperTreshold.hint"));
        TmmFontHelper.changeFont((JComponent)tpScraperThresholdHint, 0.83333);
        panelAutomaticScrape.add((Component)tpScraperThresholdHint, "cell 1 1 3 1, growx, wmin 0");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"scraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"certificationCountry");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, this.cbCertificationCountry, (Property)jComboBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"scraperFallback");
        BeanProperty jCheckBoxBeanProperty_2 = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxScraperFallback, (Property)jCheckBoxBeanProperty_2);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"capitalWordsInTitles");
        BeanProperty jCheckBoxBeanProperty_3 = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.chckbxCapitalizeWords, (Property)jCheckBoxBeanProperty_3);
        autoBinding_2.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"doNotOverwriteExistingData");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.chckbxDoNotOverwrite, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"fetchAllRatings");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, (Object)this.chckbxFetchAllRatings, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
    }

    private static class CountryItem {
        private final Locale locale;

        public CountryItem(Locale locale) {
            this.locale = locale;
        }

        public String toString() {
            return this.locale.getCountry() + " - " + this.locale.getDisplayCountry();
        }
    }
}

