/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.addon.YtDlpAddon;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.ScraperInTable;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.JHintCheckBox;
import org.tinymediamanager.ui.components.TmmLabel;

class MovieTrailerOptionsSettingsPanel
extends JPanel {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final List<ScraperInTable> scrapers = new ArrayList<ScraperInTable>();
    private final ItemListener checkBoxListener;
    private final ButtonGroup trailerFilenameButtonGroup = new ButtonGroup();
    private JComboBox<TrailerQuality> cbTrailerQuality;
    private JCheckBox checkBox;
    private JCheckBox chckbxAutomaticTrailerDownload;
    private JCheckBox cbTrailerFilename1;
    private JCheckBox cbTrailerFilename2;
    private JCheckBox cbTrailerFilename3;
    private JCheckBox cbTrailerFilename4;
    private JLabel lblAutomaticTrailerDownloadHint;
    private JCheckBox chckbxTrailerDiscKodiStyle;
    private JHintCheckBox chckbxYtDlp;

    MovieTrailerOptionsSettingsPanel() {
        this.checkBoxListener = e -> this.checkChanges();
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName())) {
                this.buildCheckBoxes();
            }
        });
        this.initComponents();
        this.initDataBindings();
        this.buildCheckBoxes();
        this.chckbxYtDlp.setEnabled(new YtDlpAddon().isAvailable());
    }

    private void buildCheckBoxes() {
        this.cbTrailerFilename1.removeItemListener(this.checkBoxListener);
        this.cbTrailerFilename2.removeItemListener(this.checkBoxListener);
        this.cbTrailerFilename3.removeItemListener(this.checkBoxListener);
        this.cbTrailerFilename4.removeItemListener(this.checkBoxListener);
        this.clearSelection(this.cbTrailerFilename1, this.cbTrailerFilename2, this.cbTrailerFilename3, this.cbTrailerFilename4);
        List<MovieTrailerNaming> movieTrailerFilenames = this.settings.getTrailerFilenames();
        if (movieTrailerFilenames.contains(MovieTrailerNaming.FILENAME_TRAILER)) {
            this.cbTrailerFilename1.setSelected(true);
        } else if (movieTrailerFilenames.contains(MovieTrailerNaming.MOVIE_TRAILER)) {
            this.cbTrailerFilename2.setSelected(true);
        } else if (movieTrailerFilenames.contains(MovieTrailerNaming.TRAILERS_FILENAME_TRAILER)) {
            this.cbTrailerFilename3.setSelected(true);
        } else if (movieTrailerFilenames.contains(MovieTrailerNaming.TRAILER)) {
            this.cbTrailerFilename4.setSelected(true);
        }
        this.cbTrailerFilename1.addItemListener(this.checkBoxListener);
        this.cbTrailerFilename2.addItemListener(this.checkBoxListener);
        this.cbTrailerFilename3.addItemListener(this.checkBoxListener);
        this.cbTrailerFilename4.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.setSelected(false);
        }
    }

    private void checkChanges() {
        this.settings.clearTrailerFilenames();
        if (this.cbTrailerFilename1.isSelected()) {
            this.settings.addTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        }
        if (this.cbTrailerFilename2.isSelected()) {
            this.settings.addTrailerFilename(MovieTrailerNaming.MOVIE_TRAILER);
        }
        if (this.cbTrailerFilename3.isSelected()) {
            this.settings.addTrailerFilename(MovieTrailerNaming.TRAILERS_FILENAME_TRAILER);
        }
        if (this.cbTrailerFilename4.isSelected()) {
            this.settings.addTrailerFilename(MovieTrailerNaming.TRAILER);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 0", "[600lp,grow]", "[]"));
        JPanel panelOptions = new JPanel();
        panelOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][][][]"));
        TmmLabel lblOptionsT = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptionsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#advanced-options-2"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.chckbxYtDlp = new JHintCheckBox(TmmResourceBundle.getString("Settings.trailer.ytdlp"));
        this.chckbxYtDlp.setToolTipText(TmmResourceBundle.getString("Settings.trailer.ytdlp.desc"));
        this.chckbxYtDlp.setHintIcon(IconManager.HINT);
        panelOptions.add((Component)this.chckbxYtDlp, "cell 1 0 2 1");
        this.checkBox = new JCheckBox(TmmResourceBundle.getString("Settings.trailer.preferred"));
        panelOptions.add((Component)this.checkBox, "cell 1 1 2 1");
        JLabel lblTrailerQuality = new JLabel(TmmResourceBundle.getString("Settings.trailer.quality"));
        panelOptions.add((Component)lblTrailerQuality, "cell 2 3");
        this.cbTrailerQuality = new JComboBox();
        this.cbTrailerQuality.setModel(new DefaultComboBoxModel<TrailerQuality>(TrailerQuality.values()));
        panelOptions.add(this.cbTrailerQuality, "cell 2 3");
        this.chckbxAutomaticTrailerDownload = new JCheckBox(TmmResourceBundle.getString("Settings.trailer.automaticdownload"));
        panelOptions.add((Component)this.chckbxAutomaticTrailerDownload, "cell 2 4");
        this.lblAutomaticTrailerDownloadHint = new JLabel(TmmResourceBundle.getString("Settings.trailer.automaticdownload.hint"));
        panelOptions.add((Component)this.lblAutomaticTrailerDownloadHint, "cell 2 5");
        TmmFontHelper.changeFont((JComponent)this.lblAutomaticTrailerDownloadHint, 0.83333);
        JPanel panelTrailerFilenames = new JPanel();
        panelOptions.add((Component)panelTrailerFilenames, "cell 1 6 2 1");
        panelTrailerFilenames.setLayout((LayoutManager)new MigLayout("insets 0", "[][]", "[][][]"));
        JLabel lblTrailerFileNaming = new JLabel(TmmResourceBundle.getString("Settings.trailerFileNaming"));
        panelTrailerFilenames.add((Component)lblTrailerFileNaming, "cell 0 0");
        this.cbTrailerFilename1 = new JCheckBox(TmmResourceBundle.getString("Settings.moviefilename") + "-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.cbTrailerFilename1);
        panelTrailerFilenames.add((Component)this.cbTrailerFilename1, "cell 1 0");
        this.cbTrailerFilename2 = new JCheckBox("movie-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.cbTrailerFilename2);
        panelTrailerFilenames.add((Component)this.cbTrailerFilename2, "cell 1 1");
        this.cbTrailerFilename3 = new JCheckBox("trailers/" + TmmResourceBundle.getString("Settings.moviefilename") + "-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.cbTrailerFilename3);
        panelTrailerFilenames.add((Component)this.cbTrailerFilename3, "cell 1 2");
        this.cbTrailerFilename4 = new JCheckBox("trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.cbTrailerFilename4);
        panelTrailerFilenames.add((Component)this.cbTrailerFilename4, "cell 1 3");
        this.chckbxTrailerDiscKodiStyle = new JCheckBox(TmmResourceBundle.getString("Settings.trailerDiscFolder"));
        panelOptions.add((Component)this.chckbxTrailerDiscKodiStyle, "cell 2 7");
    }

    protected void initDataBindings() {
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"trailerQuality");
        BeanProperty jComboBoxBeanProperty_1 = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, this.cbTrailerQuality, (Property)jComboBoxBeanProperty_1);
        autoBinding_2.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"useTrailerPreference");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.checkBox, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_3 = BeanProperty.create((String)"automaticTrailerDownload");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_3, (Object)this.chckbxAutomaticTrailerDownload, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.checkBox, (Property)jCheckBoxBeanProperty, (Object)this.chckbxAutomaticTrailerDownload, (Property)jCheckBoxBeanProperty_1);
        autoBinding_5.bind();
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.checkBox, (Property)jCheckBoxBeanProperty, (Object)this.lblAutomaticTrailerDownloadHint, (Property)jLabelBeanProperty);
        autoBinding_6.bind();
        BeanProperty movieSettingsBeanProperty_4 = BeanProperty.create((String)"trailerDiscFolderInside");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_4, (Object)this.chckbxTrailerDiscKodiStyle, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"useYtDlp");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.chckbxYtDlp, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
    }
}

