/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.ui.components.MediaIdTable;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.panels.AbstractModalInputPanel;

public class IdEditorPanel
extends AbstractModalInputPanel {
    private final MediaIdTable.MediaId idToEdit;
    private final JComboBox<String> cbProviderId;
    private final JTextField tfId;

    public IdEditorPanel(MediaIdTable.MediaId mediaId, ScraperType type) {
        this.idToEdit = mediaId;
        TreeSet<String> providerIds = new TreeSet<String>();
        if (type == null) {
            providerIds.addAll(this.getProviderIds(ScraperType.MOVIE));
            providerIds.addAll(this.getProviderIds(ScraperType.TV_SHOW));
        } else {
            providerIds.addAll(this.getProviderIds(type));
        }
        this.setLayout((LayoutManager)new MigLayout("", "[][100lp:n,grow]", "[][]"));
        JLabel lblProviderIdT = new JLabel(TmmResourceBundle.getString("metatag.id.source"));
        this.add((Component)lblProviderIdT, "cell 0 0,alignx trailing");
        this.cbProviderId = new AutocompleteComboBox<String>(providerIds);
        this.add(this.cbProviderId, "cell 1 0,growx");
        JLabel lblIdT = new JLabel(TmmResourceBundle.getString("metatag.id"));
        this.add((Component)lblIdT, "cell 0 1,alignx trailing");
        this.tfId = new JTextField();
        this.add((Component)this.tfId, "cell 1 1,growx");
        this.tfId.setColumns(10);
        this.cbProviderId.setSelectedItem(this.idToEdit.key);
        this.tfId.setText(this.idToEdit.value);
        SwingUtilities.invokeLater(this.cbProviderId::requestFocus);
    }

    @Override
    protected void onClose() {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.tfId.getText(), (String)this.cbProviderId.getSelectedItem()})) {
            JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("id.empty"));
            return;
        }
        this.idToEdit.key = (String)this.cbProviderId.getSelectedItem();
        this.idToEdit.value = this.tfId.getText();
        this.setVisible(false);
    }

    @NotNull
    private Set<String> getProviderIds(@NotNull ScraperType type) {
        TreeSet<String> providerIds = new TreeSet<String>();
        for (MediaScraper scraper : MediaScraper.getMediaScrapers(type)) {
            if (scraper.getId().startsWith("metadata") || "tvdbv3".equals(scraper.getId()) || scraper.getId().startsWith("universal_")) continue;
            providerIds.add(scraper.getId());
        }
        return providerIds;
    }
}

