/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.panels.AbstractModalInputPanel;

public class MediaFileAudioStreamEditorPanel
extends AbstractModalInputPanel {
    private final MediaFileAudioStream audioStream;
    private final JTextField tfCodec;
    private final JSpinner spChannels;
    private final JSpinner spBitrate;
    private final JSpinner spBitdepth;
    private final AutocompleteComboBox cbLanguage;
    private final JTextField tfTitle;
    private final TmmTableFormat.StringComparator stringComparator;

    public MediaFileAudioStreamEditorPanel(MediaFileAudioStream audioStream) {
        this.audioStream = audioStream;
        this.stringComparator = new TmmTableFormat.StringComparator();
        ArrayList<LanguageContainer> languages = new ArrayList<LanguageContainer>();
        for (Locale locale : Locale.getAvailableLocales()) {
            LanguageContainer localeContainer = new LanguageContainer(locale);
            if (languages.contains(localeContainer)) continue;
            languages.add(localeContainer);
        }
        languages.sort((o1, o2) -> this.stringComparator.compare(o1.toString(), o2.toString()));
        this.setLayout((LayoutManager)new MigLayout("", "[][][300lp,grow]", "[][][][][][]"));
        TmmLabel lblCodecT = new TmmLabel(TmmResourceBundle.getString("metatag.codec"));
        this.add((Component)lblCodecT, "cell 0 0,alignx trailing");
        this.tfCodec = new JTextField();
        this.tfCodec.setColumns(10);
        this.add((Component)this.tfCodec, "cell 1 0 2 1, growx");
        TmmLabel lblChannelsT = new TmmLabel(TmmResourceBundle.getString("metatag.channels"));
        this.add((Component)lblChannelsT, "cell 0 1,alignx trailing");
        this.spChannels = new JSpinner(new SpinnerNumberModel(2, 1, 20, 1));
        this.add((Component)this.spChannels, "cell 1 1, growx");
        TmmLabel lblBitrate = new TmmLabel(TmmResourceBundle.getString("metatag.bitrate"));
        this.add((Component)lblBitrate, "cell 0 2,alignx trailing");
        this.spBitrate = new JSpinner(new SpinnerNumberModel(0, 0, 9000, 1));
        this.add((Component)this.spBitrate, "cell 1 2, growx");
        TmmLabel lblBitdepthT = new TmmLabel(TmmResourceBundle.getString("metatag.bitdepth"));
        this.add((Component)lblBitdepthT, "cell 0 3,alignx trailing");
        this.spBitdepth = new JSpinner(new SpinnerNumberModel(0, 0, 20, 1));
        this.add((Component)this.spBitdepth, "cell 1 3, growx");
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("metatag.language"));
        this.add((Component)lblLanguageT, "cell 0 4,alignx trailing");
        this.cbLanguage = new AutocompleteComboBox<Object>(languages.toArray());
        this.add((Component)this.cbLanguage, "cell 1 4 2 1, wmin 50%");
        TmmLabel lblTitleT = new TmmLabel(TmmResourceBundle.getString("metatag.title"));
        this.add((Component)lblTitleT, "cell 0 5,alignx trailing");
        this.tfTitle = new JTextField();
        this.tfTitle.setColumns(30);
        this.add((Component)this.tfTitle, "cell 1 5 2 1, growx");
        this.tfCodec.setText(audioStream.getCodec());
        this.spChannels.setValue(audioStream.getAudioChannels());
        this.spBitrate.setValue(audioStream.getBitrate());
        this.spBitdepth.setValue(audioStream.getBitDepth());
        this.tfTitle.setText(audioStream.getTitle());
        Optional<LanguageContainer> foundByValue = languages.stream().filter(v -> v.value.equalsIgnoreCase(audioStream.getLanguage())).findFirst();
        if (foundByValue.isPresent()) {
            this.cbLanguage.setSelectedItem(foundByValue.get());
        } else {
            this.cbLanguage.setSelectedItem(audioStream.getLanguage());
        }
        SwingUtilities.invokeLater(this.tfCodec::requestFocus);
    }

    @Override
    protected void onClose() {
        this.audioStream.setCodec(this.tfCodec.getText());
        this.audioStream.setAudioChannels((Integer)this.spChannels.getValue());
        this.audioStream.setBitrate((Integer)this.spBitrate.getValue());
        this.audioStream.setBitDepth((Integer)this.spBitdepth.getValue());
        Object obj = this.cbLanguage.getSelectedItem();
        if (obj instanceof LanguageContainer) {
            LanguageContainer localeContainer = (LanguageContainer)obj;
            this.audioStream.setLanguage(localeContainer.value.strip());
        } else if (obj instanceof String) {
            String language = (String)obj;
            this.audioStream.setLanguage(language.strip());
        }
        this.audioStream.setTitle(this.tfTitle.getText());
        this.setVisible(false);
    }

    private static class LanguageContainer {
        private final String value;
        private Locale locale;
        private final String description;

        public LanguageContainer(@NotNull Locale locale) {
            this.locale = locale;
            this.value = locale.getISO3Language();
            this.description = StringUtils.isNotBlank((CharSequence)locale.getDisplayLanguage()) ? locale.getDisplayLanguage() + " (" + this.value + ")" : "";
        }

        public LanguageContainer(@NotNull String locale) {
            Locale tmp = LanguageUtils.KEY_TO_LOCALE_MAP.get(locale);
            if (tmp != null) {
                this.locale = tmp;
            }
            this.value = locale;
            this.description = this.locale != null ? this.value + " (" + this.locale.getISO3Language() + ")" : this.value;
        }

        public String toString() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LanguageContainer that = (LanguageContainer)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

