/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.LinkTextArea;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.panels.MediaFilesPanel;

public abstract class MediaInformationPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInformationPanel.class);
    protected EventList<MediaFile> mediaFileEventList = GlazedListsSwing.swingThreadProxyList((EventList)new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(MediaFile.class)));
    protected EventList<AudioStreamContainer> audioStreamEventList = GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()));
    protected EventList<SubtitleContainer> subtitleEventList = GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()));
    protected JLabel lblRuntime;
    protected JCheckBox chckbxWatched;
    protected JLabel lblVideoCodec;
    protected JLabel lblVideoResolution;
    protected JLabel lblVideoBitrate;
    protected JLabel lblVideoBitDepth;
    protected JLabel lblFrameRate;
    protected JLabel lblSource;
    protected LinkTextArea lblPath;
    protected JLabel lblDateAdded;
    protected JLabel lblOriginalFilename;
    protected JLabel lblHdrFormat;
    protected MediaFilesPanel panelMediaFiles;
    protected TmmTable tableAudioStreams;
    protected TmmTable tableSubtitles;

    protected MediaInformationPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[][][100lp][20lp][][grow]", "[][][][][][][][][5lp!][50lp:75lp,grow][5lp!][50lp:75lp,grow][][][200lp,grow 300]"));
        TmmLabel lblMoviePathT = new TmmLabel(TmmResourceBundle.getString("metatag.path"));
        this.add((Component)lblMoviePathT, "cell 0 0");
        this.lblPath = new LinkTextArea("");
        this.lblPath.addActionListener(new LinkLabelListener());
        this.add((Component)this.lblPath, "cell 1 0 5 1,growx,wmin 0");
        TmmLabel lblDateAddedT = new TmmLabel(TmmResourceBundle.getString("metatag.dateadded"));
        this.add((Component)lblDateAddedT, "cell 0 1");
        this.lblDateAdded = new JLabel("");
        this.add((Component)this.lblDateAdded, "cell 1 1");
        TmmLabel lblWatchedT = new TmmLabel(TmmResourceBundle.getString("metatag.watched"));
        this.add((Component)lblWatchedT, "flowx,cell 4 1 2 1");
        this.chckbxWatched = new JCheckBox("");
        this.chckbxWatched.setEnabled(false);
        this.add((Component)this.chckbxWatched, "cell 4 1 2 1");
        TmmLabel lblOriginalFilenameT = new TmmLabel(TmmResourceBundle.getString("metatag.originalfile"));
        this.add((Component)lblOriginalFilenameT, "cell 0 2");
        this.lblOriginalFilename = new JLabel("");
        this.add((Component)this.lblOriginalFilename, "cell 1 2 5 1,growx,wmin 0");
        this.add((Component)new JSeparator(), "cell 0 3 6 1,growx");
        TmmLabel lblVideoT = new TmmLabel(TmmResourceBundle.getString("metatag.video"));
        this.add((Component)lblVideoT, "cell 0 4");
        TmmLabel lblSourceT = new TmmLabel(TmmResourceBundle.getString("metatag.source"));
        this.add((Component)lblSourceT, "cell 1 4");
        this.lblSource = new JLabel("");
        this.add((Component)this.lblSource, "cell 2 4");
        TmmLabel lblHdrFormatT = new TmmLabel(TmmResourceBundle.getString("metatag.hdrformat"));
        this.add((Component)lblHdrFormatT, "cell 4 4");
        this.lblHdrFormat = new JLabel("");
        this.add((Component)this.lblHdrFormat, "cell 5 4");
        TmmLabel lblRuntimeT = new TmmLabel(TmmResourceBundle.getString("metatag.runtime"));
        this.add((Component)lblRuntimeT, "cell 1 5");
        this.lblRuntime = new JLabel("");
        this.add((Component)this.lblRuntime, "cell 2 5");
        TmmLabel lblCodecT = new TmmLabel(TmmResourceBundle.getString("metatag.videocodec"));
        this.add((Component)lblCodecT, "cell 1 6");
        this.lblVideoCodec = new JLabel("");
        this.add((Component)this.lblVideoCodec, "cell 2 6");
        TmmLabel lblFrameRateT = new TmmLabel(TmmResourceBundle.getString("metatag.framerate"));
        this.add((Component)lblFrameRateT, "cell 4 6");
        this.lblFrameRate = new JLabel("");
        this.add((Component)this.lblFrameRate, "cell 5 6");
        TmmLabel lblResolutionT = new TmmLabel(TmmResourceBundle.getString("metatag.resolution"));
        this.add((Component)lblResolutionT, "cell 1 7");
        this.lblVideoResolution = new JLabel("");
        this.add((Component)this.lblVideoResolution, "cell 2 7");
        TmmLabel lblVideoBitrateT = new TmmLabel(TmmResourceBundle.getString("metatag.videobitrate"));
        this.add((Component)lblVideoBitrateT, "cell 4 7");
        this.lblVideoBitrate = new JLabel("");
        this.add((Component)this.lblVideoBitrate, "cell 5 7");
        TmmLabel lblVideoBitDepthT = new TmmLabel(TmmResourceBundle.getString("metatag.videobitdepth"));
        this.add((Component)lblVideoBitDepthT, "cell 4 5");
        this.lblVideoBitDepth = new JLabel("");
        this.add((Component)this.lblVideoBitDepth, "cell 5 5");
        TmmLabel lblAudioT = new TmmLabel(TmmResourceBundle.getString("metatag.audio"));
        this.add((Component)lblAudioT, "cell 0 9,aligny top");
        TmmTableModel<Object> tmmTableModel = new TmmTableModel<AudioStreamContainer>(this.audioStreamEventList, new AudioStreamTableFormat());
        this.tableAudioStreams = new TmmTable((TableModel)((Object)tmmTableModel));
        this.tableAudioStreams.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane();
        this.tableAudioStreams.configureScrollPane(scrollPane);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)scrollPane, "cell 1 9 5 1,growx");
        TmmLabel lblSubtitle = new TmmLabel(TmmResourceBundle.getString("metatag.subtitles"));
        this.add((Component)lblSubtitle, "cell 0 11,aligny top");
        tmmTableModel = new TmmTableModel<SubtitleContainer>(this.subtitleEventList, new SubtitleTableFormat());
        this.tableSubtitles = new TmmTable((TableModel)((Object)tmmTableModel));
        this.tableSubtitles.setAutoResizeMode(0);
        scrollPane = new JScrollPane();
        this.tableSubtitles.configureScrollPane(scrollPane);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)scrollPane, "cell 1 11 5 1,growx");
        this.add((Component)new JSeparator(), "cell 0 12 6 1,growx");
        TmmLabel lblMediaFilesT = new TmmLabel(TmmResourceBundle.getString("metatag.mediafiles"));
        this.add((Component)lblMediaFilesT, "cell 0 13 2 1");
        this.panelMediaFiles = new MediaFilesPanel(this.mediaFileEventList);
        this.add((Component)this.panelMediaFiles, "cell 0 14 6 1,grow");
    }

    protected abstract void fillVideoStreamDetails();

    protected abstract void buildAudioStreamDetails();

    protected abstract void buildSubtitleStreamDetails();

    protected class LinkLabelListener
    implements ActionListener {
        protected LinkLabelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (StringUtils.isNotBlank((CharSequence)MediaInformationPanel.this.lblPath.getText())) {
                Path path = Paths.get(MediaInformationPanel.this.lblPath.getText(), new String[0]);
                TmmUIHelper.openFolder(path);
            }
        }
    }

    protected static class AudioStreamTableFormat
    extends TmmTableFormat<AudioStreamContainer> {
        AudioStreamTableFormat() {
            TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.source"), "source", container -> container.source, String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.codec"), "codec", container -> container.audioStream.getCodec(), String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.channels"), "channels", container -> {
                int channels = container.audioStream.getAudioChannels();
                if (channels > 0) {
                    return channels + "ch";
                }
                return "";
            }, String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.bitrate"), "bitrate", container -> container.audioStream.getBitrateInKbps(), String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.bitdepth"), "bitdepth", container -> container.audioStream.getBitDepthAsString(), String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.language"), "language", container -> container.audioStream.getLanguage(), String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", container -> container.audioStream.getTitle(), String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
        }
    }

    protected static class SubtitleTableFormat
    extends TmmTableFormat<SubtitleContainer> {
        SubtitleTableFormat() {
            TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
            TmmTableFormat.BooleanComparator booleanComparator = new TmmTableFormat.BooleanComparator();
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.source"), "source", container -> container.source, String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.language"), "language", container -> container.subtitle.getLanguage(), String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.forced"), "forced", container -> container.subtitle.isForced(), Boolean.class);
            col.setColumnComparator(booleanComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.sdh"), "sdh", container -> container.subtitle.isSdh(), Boolean.class);
            col.setColumnComparator(booleanComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.format"), "format", container -> container.subtitle.getCodec(), String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", container -> container.subtitle.getTitle(), String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
        }
    }

    protected static class SubtitleContainer {
        public String source;
        public MediaFileSubtitle subtitle;
    }

    protected static class AudioStreamContainer {
        public String source;
        public MediaFileAudioStream audioStream;
    }
}

