/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DateFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;

public class MessagePanel
extends JPanel {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");
    private JLabel lblTitle;
    private JTextPane taMessage;
    private JLabel lblIcon;
    private JLabel lblDate;

    public MessagePanel(Message message) {
        this.setOpaque(false);
        this.initComponents();
        DateFormat dateFormat = TmmDateFormat.MEDIUM_TIME_FORMAT;
        this.lblDate.setText(dateFormat.format(message.getMessageDate()));
        String text = "";
        Object object = message.getMessageSender();
        if (object instanceof MediaEntity) {
            MediaEntity mediaEntity = (MediaEntity)object;
            text = mediaEntity.getTitle();
        } else {
            object = message.getMessageSender();
            if (object instanceof MediaFile) {
                MediaFile mediaFile = (MediaFile)object;
                text = mediaFile.getFilename();
            } else {
                try {
                    text = Utils.replacePlaceholders(BUNDLE.getString(message.getMessageSender().toString()), message.getSenderParams());
                }
                catch (Exception e) {
                    text = String.valueOf(message.getMessageSender());
                }
            }
        }
        this.lblTitle.setText(text);
        text = "";
        try {
            text = Utils.replacePlaceholders(BUNDLE.getString(message.getMessageId()), message.getIdParams());
        }
        catch (Exception e) {
            text = message.getMessageId();
        }
        this.taMessage.setText(text);
        switch (message.getMessageLevel()) {
            case ERROR: {
                this.lblIcon.setIcon(IconManager.ERROR);
                break;
            }
            case WARN: {
                this.lblIcon.setIcon(IconManager.WARN);
                break;
            }
            case INFO: {
                this.lblIcon.setIcon(IconManager.INFO);
                break;
            }
            default: {
                this.lblIcon.setIcon(null);
            }
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[150lp:200lp,grow][]", "[][shrink 0]"));
        this.lblDate = new JLabel("");
        this.add((Component)this.lblDate, "cell 1 0");
        JPanel innerPanel = new JPanel();
        this.add((Component)innerPanel, "cell 0 0,growx");
        innerPanel.setLayout((LayoutManager)new MigLayout("", "[1px][][150lp:200lp,grow]", "[][]"));
        this.lblIcon = new JLabel("");
        this.lblIcon.setHorizontalAlignment(0);
        innerPanel.add((Component)this.lblIcon, "cell 1 0,alignx center,aligny center");
        this.lblTitle = new JLabel();
        TmmFontHelper.changeFont((JComponent)this.lblTitle, 1);
        innerPanel.add((Component)this.lblTitle, "cell 2 0,wmin 0,growx");
        this.taMessage = new ReadOnlyTextPane();
        innerPanel.add((Component)this.taMessage, "cell 2 1,wmin 0,grow");
        this.add((Component)new JSeparator(), "cell 0 1 2 1,growx");
    }
}

