/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.ui.components.MediaRatingTable;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.panels.AbstractModalInputPanel;

public class RatingEditorPanel
extends AbstractModalInputPanel {
    private final MediaRatingTable.Rating ratingToEdit;
    private final JComboBox<String> cbProviderId;
    private final JSpinner spRating;
    private final JSpinner spMaxValue;
    private final JSpinner spVotes;

    public RatingEditorPanel(MediaRatingTable.Rating rating) {
        String defaultProvider;
        this.ratingToEdit = rating;
        this.setLayout((LayoutManager)new MigLayout("", "[][50lp][20lp:n][][50lp]", "[][][]"));
        JLabel lblProviderIdT = new JLabel(TmmResourceBundle.getString("metatag.rating.source"));
        this.add((Component)lblProviderIdT, "cell 0 0,alignx trailing");
        this.cbProviderId = new AutocompleteComboBox<String>(Arrays.stream(RatingProvider.RatingSource.values()).map(RatingProvider::getRatingSourceId).toList());
        this.add(this.cbProviderId, "cell 1 0 4 1,growx");
        JLabel lblRatingT = new JLabel(TmmResourceBundle.getString("metatag.rating"));
        this.add((Component)lblRatingT, "cell 0 1,alignx trailing");
        this.spRating = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 0.1));
        this.add((Component)this.spRating, "cell 1 1,growx");
        JLabel lblMaxValue = new JLabel(TmmResourceBundle.getString("metatag.rating.maxvalue"));
        this.add((Component)lblMaxValue, "cell 3 1");
        this.spMaxValue = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
        this.add((Component)this.spMaxValue, "cell 4 1,growx");
        JLabel lblVotes = new JLabel(TmmResourceBundle.getString("metatag.rating.votes"));
        this.add((Component)lblVotes, "cell 0 2");
        this.spVotes = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this.add((Component)this.spVotes, "cell 1 2,growx");
        this.cbProviderId.setSelectedItem(this.ratingToEdit.key);
        this.spRating.setValue(Float.valueOf(this.ratingToEdit.value));
        this.spMaxValue.setValue(this.ratingToEdit.maxValue);
        this.spVotes.setValue(this.ratingToEdit.votes);
        if (StringUtils.isBlank((CharSequence)this.ratingToEdit.key) && this.ratingToEdit.value == 0.0f && StringUtils.isNotBlank((CharSequence)(defaultProvider = TmmProperties.getInstance().getProperty("ratingid")))) {
            this.cbProviderId.setSelectedItem(defaultProvider);
        }
        SwingUtilities.invokeLater(this.cbProviderId::requestFocus);
    }

    @Override
    protected void onClose() {
        float rating = 0.0f;
        Object obj = this.spRating.getValue();
        if (obj instanceof Double) {
            Double d = (Double)obj;
            rating = d.floatValue();
        } else if (obj instanceof Float) {
            Float f = (Float)obj;
            rating = f.floatValue();
        }
        int maxValue = (Integer)this.spMaxValue.getValue();
        obj = this.cbProviderId.getSelectedItem();
        if (obj == null || StringUtils.isBlank((CharSequence)obj.toString())) {
            JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("id.empty"));
            return;
        }
        String key = obj.toString();
        if (rating > (float)maxValue) {
            JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("rating.rating.higher.maxvalue"));
            return;
        }
        this.ratingToEdit.key = key;
        this.ratingToEdit.value = rating;
        this.ratingToEdit.maxValue = maxValue;
        this.ratingToEdit.votes = (Integer)this.spVotes.getValue();
        TmmProperties.getInstance().putProperty("ratingid", this.ratingToEdit.key);
        this.setVisible(false);
    }
}

