/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Path;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.addon.FFmpegAddon;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;

public class ExternalToolsSettingsPanel
extends JPanel {
    private final Settings settings = Settings.getInstance();
    private final ButtonGroup buttonGroupFfmpeg = new ButtonGroup();
    private JTextField tfMediaPlayer;
    private JTextField tfMediaFramework;
    private JButton btnSearchMediaPlayer;
    private JButton btnSearchFFMpegBinary;
    private JRadioButton rdbtnFfmpegInternal;
    private JRadioButton rdbtnFFmpegExternal;

    ExternalToolsSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnSearchMediaPlayer.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("chooseplayer.path");
            Path file = TmmUIHelper.selectApplication(TmmResourceBundle.getString("Button.chooseplayer"), path);
            if (file != null && (Utils.isRegularFile(file) || SystemUtils.IS_OS_MAC)) {
                this.tfMediaPlayer.setText(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("chooseplayer.path", file.getParent().toString());
            }
        });
        this.btnSearchFFMpegBinary.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("chooseffmpeg.path");
            Path file = TmmUIHelper.selectFile(TmmResourceBundle.getString("Button.chooseffmpeglocation"), path, null);
            if (file != null && (Utils.isRegularFile(file) || SystemUtils.IS_OS_MAC)) {
                this.tfMediaFramework.setText(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("chooseffmpeg.path", file.getParent().toString());
            }
        });
        if (this.settings.isUseInternalMediaFramework()) {
            this.rdbtnFfmpegInternal.setSelected(true);
        } else {
            this.rdbtnFFmpegExternal.setSelected(true);
        }
        FFmpegAddon fFmpegAddon = new FFmpegAddon();
        if (fFmpegAddon.isAvailable()) {
            this.rdbtnFfmpegInternal.setEnabled(true);
        } else {
            this.rdbtnFFmpegExternal.setSelected(true);
            this.rdbtnFfmpegInternal.setEnabled(false);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][15lp!][]"));
        JPanel panelMediaPlayer = new JPanel();
        panelMediaPlayer.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", ""));
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("Settings.mediaplayer"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelMediaPlayer, lblLanguageT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#media-player"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.tfMediaPlayer = new JTextField();
        panelMediaPlayer.add((Component)this.tfMediaPlayer, "cell 1 0 2 1");
        this.tfMediaPlayer.setColumns(35);
        this.btnSearchMediaPlayer = new JButton(TmmResourceBundle.getString("Button.chooseplayer"));
        panelMediaPlayer.add((Component)this.btnSearchMediaPlayer, "cell 1 0");
        ReadOnlyTextArea tpMediaPlayer = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.mediaplayer.hint"));
        panelMediaPlayer.add((Component)tpMediaPlayer, "cell 1 1 2 1,growx, wmin 0");
        TmmFontHelper.changeFont((JComponent)tpMediaPlayer, 0.83333);
        JPanel panelMediaFramework = new JPanel();
        panelMediaFramework.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][400lp,grow][]", "[][][][]"));
        TmmLabel lblMediaFrameworkT = new TmmLabel("FFmpeg", 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMediaFramework, lblMediaFrameworkT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        this.rdbtnFfmpegInternal = new JRadioButton(TmmResourceBundle.getString("Settings.mediaframework.internal"));
        this.buttonGroupFfmpeg.add(this.rdbtnFfmpegInternal);
        panelMediaFramework.add((Component)this.rdbtnFfmpegInternal, "cell 1 0 2 1");
        this.rdbtnFFmpegExternal = new JRadioButton(TmmResourceBundle.getString("Settings.mediaframework.external"));
        this.buttonGroupFfmpeg.add(this.rdbtnFFmpegExternal);
        panelMediaFramework.add((Component)this.rdbtnFFmpegExternal, "cell 1 1 2 1");
        this.tfMediaFramework = new JTextField();
        panelMediaFramework.add((Component)this.tfMediaFramework, "cell 2 2");
        this.tfMediaFramework.setColumns(35);
        this.btnSearchFFMpegBinary = new JButton(TmmResourceBundle.getString("Button.chooseffmpeglocation"));
        panelMediaFramework.add((Component)this.btnSearchFFMpegBinary, "cell 2 2");
        ReadOnlyTextArea tpFFMpegLocation = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.mediaframework.hint"));
        panelMediaFramework.add((Component)tpFFMpegLocation, "cell 2 3,growx");
        TmmFontHelper.changeFont((JComponent)tpFFMpegLocation, 0.83333);
    }

    private void initDataBindings() {
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"mediaPlayer");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.tfMediaPlayer, (Property)jTextFieldBeanProperty_3);
        autoBinding_9.bind();
        BeanProperty settingsBeanProperty_7 = BeanProperty.create((String)"mediaFramework");
        BeanProperty jTextFieldBeanProperty_4 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_7, (Object)this.tfMediaFramework, (Property)jTextFieldBeanProperty_4);
        autoBinding_10.bind();
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"useInternalMediaFramework");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, (Object)this.rdbtnFfmpegInternal, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
    }
}

