/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.DateField;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.LinkTextArea;
import org.tinymediamanager.ui.components.LocaleComboBox;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;

class UiSettingsPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(UiSettingsPanel.class);
    private static final Integer[] DEFAULT_FONT_SIZES = new Integer[]{10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 26, 28};
    private final Settings settings = Settings.getInstance();
    private final List<LocaleComboBox> locales = new ArrayList<LocaleComboBox>();
    private JComboBox cbLanguage;
    private LinkTextArea lblLinkTranslate;
    private JComboBox cbFontSize;
    private JComboBox cbFontFamily;
    private JLabel lblLanguageChangeHint;
    private JCheckBox chckbxStoreWindowPreferences;
    private JComboBox cbTheme;
    private JLabel lblThemeHint;
    private JCheckBox chckbxShowMemory;
    private JComboBox cbDatefield;
    private JCheckBox chckbxFileSizeH;
    private JCheckBox chckbxFileSizeM;
    private JCheckBox chckbxImageChooserLastFolder;
    private JCheckBox chckbxImageChooserEntityFolder;
    private JSpinner spUpdateInterval;
    private JCheckBox chckbxAutomaticUpdates;
    private JLabel lblUpdateHint;
    private CollapsiblePanel collapsiblePanelUpdate;

    UiSettingsPanel() {
        LocaleComboBox actualLocale = null;
        LocaleComboBox fallbackLocale = null;
        Locale settingsLang = Utils.getLocaleFromLanguage(this.settings.getLanguage());
        for (Locale l : Utils.getLanguages()) {
            LocaleComboBox localeComboBox = new LocaleComboBox(l);
            this.locales.add(localeComboBox);
            if (l.equals(settingsLang)) {
                actualLocale = localeComboBox;
            }
            if (!settingsLang.getLanguage().equals(l.getLanguage())) continue;
            fallbackLocale = localeComboBox;
        }
        Collections.sort(this.locales);
        this.initComponents();
        this.initDataBindings();
        if (actualLocale != null) {
            this.cbLanguage.setSelectedItem(actualLocale);
        } else {
            this.cbLanguage.setSelectedItem(fallbackLocale);
        }
        this.cbFontFamily.setSelectedItem(this.settings.getFontFamily());
        int index = this.cbFontFamily.getSelectedIndex();
        if (index < 0) {
            this.cbFontFamily.setSelectedItem("Dialog");
            index = this.cbFontFamily.getSelectedIndex();
        }
        if (index < 0) {
            this.cbFontFamily.setSelectedIndex(0);
        }
        this.cbFontSize.setSelectedItem(this.settings.getFontSize());
        index = this.cbFontSize.getSelectedIndex();
        if (index < 0) {
            this.cbFontSize.setSelectedIndex(0);
        }
        this.cbTheme.setSelectedItem(this.settings.getTheme());
        index = this.cbTheme.getSelectedIndex();
        if (index < 0) {
            this.cbTheme.setSelectedIndex(0);
        }
        this.lblLinkTranslate.addActionListener(arg0 -> {
            try {
                TmmUIHelper.browseUrl(this.lblLinkTranslate.getText());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.lblLinkTranslate.getText(), "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        ActionListener actionListener = e -> SwingUtilities.invokeLater(this::checkChanges);
        this.cbLanguage.addActionListener(actionListener);
        this.cbFontFamily.addActionListener(actionListener);
        this.cbFontSize.addActionListener(actionListener);
        this.cbTheme.addActionListener(actionListener);
        this.chckbxAutomaticUpdates.addActionListener(actionListener);
        this.settings.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "theme": {
                    if (this.settings.getTheme().equals(this.cbTheme.getSelectedItem())) break;
                    this.cbTheme.setSelectedItem(this.settings.getTheme());
                    break;
                }
                case "fontSize": {
                    if (this.cbFontSize.getSelectedItem() == null || this.settings.getFontSize() == ((Integer)this.cbFontSize.getSelectedItem()).intValue()) break;
                    this.cbFontSize.setSelectedItem(this.settings.getFontSize());
                    break;
                }
                case "fontFamily": {
                    if (this.settings.getFontFamily().equals(this.cbFontFamily.getSelectedItem())) break;
                    this.cbFontFamily.setSelectedItem(this.settings.getFontFamily());
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.chckbxImageChooserLastFolder);
        buttonGroup.add(this.chckbxImageChooserEntityFolder);
        if (this.settings.isImageChooserUseEntityFolder()) {
            this.chckbxImageChooserEntityFolder.setSelected(true);
        } else {
            this.chckbxImageChooserLastFolder.setSelected(true);
        }
        this.chckbxImageChooserLastFolder.addActionListener(actionListener);
        this.chckbxImageChooserEntityFolder.addActionListener(actionListener);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.chckbxFileSizeH);
        buttonGroup.add(this.chckbxFileSizeM);
        if (this.settings.isFileSizeDisplayHumanReadable()) {
            this.chckbxFileSizeH.setSelected(true);
        } else {
            this.chckbxFileSizeM.setSelected(true);
        }
        this.chckbxFileSizeH.addActionListener(actionListener);
        this.chckbxFileSizeM.addActionListener(actionListener);
        if (!this.chckbxAutomaticUpdates.isSelected()) {
            this.lblUpdateHint.setText(TmmResourceBundle.getString("Settings.updatecheck.hint"));
        }
        if (!Globals.canCheckForUpdates() || ReleaseInfo.isNightly()) {
            this.collapsiblePanelUpdate.setVisible(false);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 1", "[600lp,grow]", "[][15lp!][][15lp!][]"));
        JPanel panelUiSettings = new JPanel();
        panelUiSettings.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][][grow]", "[][][][][5lp!][][][5lp!][][][]"));
        TmmLabel lblUiSettingsT = new TmmLabel(TmmResourceBundle.getString("Settings.ui"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelUiSettings, lblUiSettingsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#general"));
        this.add((Component)collapsiblePanel, "cell 0 0, growx, wmin 0");
        JLabel lblLanguageT = new JLabel(TmmResourceBundle.getString("Settings.language"));
        panelUiSettings.add((Component)lblLanguageT, "cell 1 0 3 1");
        this.cbLanguage = new JComboBox<Object>(this.locales.toArray());
        panelUiSettings.add((Component)this.cbLanguage, "cell 1 0 3 1");
        JLabel lblLanguageHint = new JLabel(TmmResourceBundle.getString("tmm.helptranslate"));
        panelUiSettings.add((Component)lblLanguageHint, "cell 2 1 2 1");
        this.lblLinkTranslate = new LinkTextArea("https://www.reddit.com/r/tinyMediaManager/comments/kt2iyq/basic_information/");
        panelUiSettings.add((Component)this.lblLinkTranslate, "cell 2 2 2 1, grow, wmin 0");
        this.lblLanguageChangeHint = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblLanguageChangeHint, 1);
        panelUiSettings.add((Component)this.lblLanguageChangeHint, "cell 0 3 4 1");
        JLabel lblThemeT = new JLabel(TmmResourceBundle.getString("Settings.uitheme"));
        panelUiSettings.add((Component)lblThemeT, "cell 1 5 3 1");
        this.cbTheme = new JComboBox<String>(new String[]{"Light", "Dark"});
        panelUiSettings.add((Component)this.cbTheme, "cell 1 5 3 1");
        this.lblThemeHint = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblThemeHint, 1);
        panelUiSettings.add((Component)this.lblThemeHint, "cell 0 6 4 1");
        JLabel lblFontFamilyT = new JLabel(TmmResourceBundle.getString("Settings.fontfamily"));
        panelUiSettings.add((Component)lblFontFamilyT, "cell 1 8 2 1");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.cbFontFamily = new JComboBox<String>(env.getAvailableFontFamilyNames());
        panelUiSettings.add((Component)this.cbFontFamily, "cell 3 8");
        JLabel lblFontSizeT = new JLabel(TmmResourceBundle.getString("Settings.fontsize"));
        panelUiSettings.add((Component)lblFontSizeT, "cell 1 9 2 1");
        this.cbFontSize = new JComboBox<Integer>(DEFAULT_FONT_SIZES);
        panelUiSettings.add((Component)this.cbFontSize, "cell 3 9");
        ReadOnlyTextArea tpFontHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.fonts.hint"));
        panelUiSettings.add((Component)tpFontHint, "cell 2 10 2 1,growx");
        JPanel panelMisc = new JPanel();
        panelMisc.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][10lp!][][][][10lp!][][][][10lp!][][]"));
        TmmLabel lblMiscT = new TmmLabel(TmmResourceBundle.getString("Settings.misc"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMisc, lblMiscT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#misc-settings"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        JLabel lblDatefield = new JLabel(TmmResourceBundle.getString("Settings.datefield"));
        panelMisc.add((Component)lblDatefield, "cell 1 0 2 1");
        this.cbDatefield = new JComboBox<DateField>(DateField.values());
        panelMisc.add((Component)this.cbDatefield, "cell 1 0 2 1");
        JLabel lblDatefieldHint = new JLabel(TmmResourceBundle.getString("Settings.datefield.desc"));
        panelMisc.add((Component)lblDatefieldHint, "cell 2 1");
        JLabel lblFileSizeT = new JLabel(TmmResourceBundle.getString("Settings.filesize"));
        panelMisc.add((Component)lblFileSizeT, "cell 1 3 2 1");
        this.chckbxFileSizeH = new JCheckBox(TmmResourceBundle.getString("Settings.filesize.human"));
        panelMisc.add((Component)this.chckbxFileSizeH, "cell 2 4");
        this.chckbxFileSizeM = new JCheckBox(TmmResourceBundle.getString("Settings.filesize.megabyte"));
        panelMisc.add((Component)this.chckbxFileSizeM, "cell 2 5");
        JLabel lblImageChooserDefaultFolderT = new JLabel(TmmResourceBundle.getString("Settings.imagechooser.folder"));
        panelMisc.add((Component)lblImageChooserDefaultFolderT, "cell 1 7 2 1");
        this.chckbxImageChooserLastFolder = new JCheckBox(TmmResourceBundle.getString("Settings.imagechooser.last"));
        panelMisc.add((Component)this.chckbxImageChooserLastFolder, "cell 2 8");
        this.chckbxImageChooserEntityFolder = new JCheckBox(TmmResourceBundle.getString("Settings.imagechooser.entity"));
        panelMisc.add((Component)this.chckbxImageChooserEntityFolder, "cell 2 9");
        this.chckbxStoreWindowPreferences = new JCheckBox(TmmResourceBundle.getString("Settings.storewindowpreferences"));
        panelMisc.add((Component)this.chckbxStoreWindowPreferences, "cell 1 11 2 1");
        this.chckbxShowMemory = new JCheckBox(TmmResourceBundle.getString("Settings.showmemory"));
        panelMisc.add((Component)this.chckbxShowMemory, "cell 1 12 2 1");
        JPanel panelUpdate = new JPanel();
        panelUpdate.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][]"));
        TmmLabel lblUpdateT = new TmmLabel(TmmResourceBundle.getString("Settings.update"), 1.16667);
        this.collapsiblePanelUpdate = new CollapsiblePanel((JComponent)panelUpdate, lblUpdateT, true);
        this.collapsiblePanelUpdate.addExtraTitleComponent(new DocsButton("/settings#update"));
        this.add((Component)this.collapsiblePanelUpdate, "cell 0 4,growx,wmin 0");
        this.chckbxAutomaticUpdates = new JCheckBox(TmmResourceBundle.getString("Settings.updatecheck"));
        panelUpdate.add((Component)this.chckbxAutomaticUpdates, "cell 1 0 2 1");
        JLabel lblUpdateInterval = new JLabel(TmmResourceBundle.getString("Settings.updatecheck.interval"));
        panelUpdate.add((Component)lblUpdateInterval, "flowx,cell 2 1");
        this.spUpdateInterval = new JSpinner();
        this.spUpdateInterval.setModel(new SpinnerNumberModel(1, 1, 30, 1));
        panelUpdate.add((Component)this.spUpdateInterval, "cell 2 1");
        this.lblUpdateHint = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblUpdateHint, 1);
        panelUpdate.add((Component)this.lblUpdateHint, "cell 1 2 2 1");
    }

    private void checkChanges() {
        Locale actualLocale;
        Locale locale;
        LocaleComboBox loc = (LocaleComboBox)this.cbLanguage.getSelectedItem();
        if (loc != null && !(locale = loc.getLocale()).equals(actualLocale = Utils.getLocaleFromLanguage(this.settings.getLanguage()))) {
            this.settings.setLanguage(locale.toString());
            this.lblLanguageChangeHint.setText(TmmResourceBundle.getString("Settings.languagehint"));
        }
        String theme = (String)this.cbTheme.getSelectedItem();
        if (!this.settings.getTheme().equals(theme)) {
            this.settings.setTheme(theme);
            try {
                TmmUIHelper.setTheme();
                TmmUIHelper.updateUI();
            }
            catch (Exception e) {
                this.lblThemeHint.setText(TmmResourceBundle.getString("Settings.uitheme.hint"));
            }
        }
        String fontFamily = (String)this.cbFontFamily.getSelectedItem();
        Integer fontSize = (Integer)this.cbFontSize.getSelectedItem();
        if (fontFamily != null && !fontFamily.equals(this.settings.getFontFamily()) || fontSize != null && fontSize.intValue() != this.settings.getFontSize()) {
            this.settings.setFontFamily(fontFamily);
            this.settings.setFontSize(fontSize);
            Font font = UIManager.getFont("defaultFont");
            Font newFont = new Font(fontFamily, font.getStyle(), fontSize);
            UIManager.put("defaultFont", newFont);
            TmmUIHelper.updateUI();
        }
        this.settings.setImageChooserUseEntityFolder(this.chckbxImageChooserEntityFolder.isSelected());
        this.settings.setFileSizeDisplayHumanReadable(this.chckbxFileSizeH.isSelected());
        if (this.chckbxAutomaticUpdates.isSelected()) {
            this.lblUpdateHint.setText("");
        } else {
            this.lblUpdateHint.setText(TmmResourceBundle.getString("Settings.updatecheck.hint"));
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"storeWindowPreferences");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxStoreWindowPreferences, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"showMemory");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxShowMemory, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"dateField");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.cbDatefield, (Property)jComboBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty jSpinnerBeanProperty = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxAutomaticUpdates, (Property)jCheckBoxBeanProperty, (Object)this.spUpdateInterval, (Property)jSpinnerBeanProperty);
        autoBinding_3.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"enableAutomaticUpdate");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, (Object)this.chckbxAutomaticUpdates, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"automaticUpdateInterval");
        BeanProperty jSpinnerBeanProperty_1 = BeanProperty.create((String)"value");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, (Object)this.spUpdateInterval, (Property)jSpinnerBeanProperty_1);
        autoBinding_5.bind();
    }
}

