/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowDeleteAction
extends TmmAction {
    public TvShowDeleteAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.delete"));
        this.putValue("SmallIcon", IconManager.DELETE_FOREVER);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.delete.hint"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isEmpty()) {
            return;
        }
        Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
        int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tvshow.delete.desc"), TmmResourceBundle.getString("tvshow.delete"), 0, 3, null, options, null);
        if (answer != 0) {
            return;
        }
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        TmmTaskManager.getInstance().addUnnamedTask(() -> {
            for (TvShow tvShow : selectedObjects.getTvShows()) {
                TvShowModuleManager.getInstance().getTvShowList().deleteTvShow(tvShow);
            }
            for (TvShowSeason season : selectedObjects.getSeasons()) {
                for (TvShowEpisode episode : season.getEpisodes()) {
                    season.getTvShow().deleteEpisode(episode);
                }
            }
            for (TvShowEpisode episode : selectedObjects.getEpisodes()) {
                episode.getTvShow().deleteEpisode(episode);
            }
        });
    }
}

