/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.imdb.ImdbTvShowMetadataProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowFetchImdbTop250
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowFetchImdbTop250.class);

    public TvShowFetchImdbTop250() {
        this.putValue("SwingLargeIconKey", IconManager.RATING_BLUE);
        this.putValue("SmallIcon", IconManager.RATING_BLUE);
        this.putValue("Name", TmmResourceBundle.getString("tvshow.fetchtop250"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects(false, false);
        final Set<TvShow> tvShows = selectedObjects.getTvShows();
        final Set<TvShowEpisode> episodes = selectedObjects.getEpisodesRecursive();
        if (tvShows.isEmpty() && episodes.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("tvshow.fetchtop250"), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                try {
                    ImdbTvShowMetadataProvider mp = new ImdbTvShowMetadataProvider();
                    Map<String, Integer> charts = mp.getTop250();
                    int cnt = 0;
                    for (TvShow show : tvShows) {
                        String id = show.getImdbId();
                        if (id.isEmpty()) continue;
                        Integer top = charts.get(id);
                        if (top != null) {
                            ++cnt;
                            show.setTop250(top);
                            show.saveToDb();
                            show.writeNFO();
                            continue;
                        }
                        int current = show.getTop250();
                        if (current <= 0) continue;
                        show.setTop250(0);
                        show.saveToDb();
                        show.writeNFO();
                    }
                    for (TvShowEpisode ep : episodes) {
                        String id;
                        TvShow show = ep.getTvShow();
                        if (tvShows.contains(show) || (id = show.getImdbId()).isEmpty()) continue;
                        Integer top = charts.get(id);
                        if (top != null) {
                            ++cnt;
                            show.setTop250(top);
                            show.saveToDb();
                            show.writeNFO();
                            continue;
                        }
                        int current = show.getTop250();
                        if (current <= 0) continue;
                        show.setTop250(0);
                        show.saveToDb();
                        show.writeNFO();
                    }
                    LOGGER.info("Matched {} Top 250 values from IMDB", (Object)cnt);
                }
                catch (Exception ignored) {
                    LOGGER.warn("Error fetching Top 250: {}", (Object)ignored.getMessage());
                }
            }
        });
    }
}

