/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRewriteNfoAction
extends TmmAction {
    public TvShowRewriteNfoAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.rewritenfo"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShowsRecursive();
        if (selectedTvShows.isEmpty()) {
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("tvshow.rewritenfo"), selectedTvShows.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (TvShow tvShow : selectedTvShows) {
                    tvShow.writeNFO();
                    tvShow.saveToDb();
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

