/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowScrapeMetadataDialog;

public class TvShowScrapeEpisodesAction
extends TmmAction {
    public TvShowScrapeEpisodesAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshowepisode.scrape"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShowEpisode> episodesToScrape = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
        if (episodesToScrape.isEmpty()) {
            return;
        }
        TvShowScrapeMetadataDialog dialog = TvShowScrapeMetadataDialog.createEpisodeScrapeDialog(TmmResourceBundle.getString("tvshowepisode.scrape"));
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.setVisible(true);
        if (!dialog.shouldStartScrape()) {
            return;
        }
        TvShowEpisodeSearchAndScrapeOptions options = dialog.getTvShowEpisodeSearchAndScrapeOptions();
        List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = dialog.getTvShowEpisodeScraperMetadataConfig();
        boolean overwrite = dialog.getOverwriteExistingItems();
        HashMap<TvShow, List> newEpisodes = new HashMap<TvShow, List>();
        for (TvShowEpisode tvShowEpisode : episodesToScrape) {
            List episodes = newEpisodes.computeIfAbsent(tvShowEpisode.getTvShow(), k -> new ArrayList());
            episodes.add(tvShowEpisode);
        }
        for (Map.Entry entry : newEpisodes.entrySet()) {
            TvShowEpisodeScrapeTask task = new TvShowEpisodeScrapeTask((List)entry.getValue(), options, episodeScraperMetadataConfig, overwrite);
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
    }
}

