/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowChooserDialog;

public class TvShowSingleScrapeAction
extends TmmAction {
    public TvShowSingleScrapeAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.scrape.selected"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.scrape.selected"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShowsRecursive();
        int count = selectedTvShows.size();
        if (count == 0) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        int index = 0;
        do {
            TvShow tvShow = selectedTvShows.get(index);
            TvShowChooserDialog chooser = new TvShowChooserDialog(tvShow, index, count);
            chooser.setVisible(true);
            if (!chooser.isContinueQueue()) break;
            if (chooser.isNavigateBack()) {
                --index;
                continue;
            }
            ++index;
        } while (index < count);
    }
}

