/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowTrailerDownloadAction
extends TmmAction {
    public TvShowTrailerDownloadAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.downloadtrailer"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.downloadtrailer"));
        this.putValue("SmallIcon", IconManager.DOWNLOAD);
        this.putValue("SwingLargeIconKey", IconManager.DOWNLOAD);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 640));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        if (selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        boolean existingTrailer = false;
        for (TvShow tvShow : selectedTvShows) {
            if (tvShow.getMediaFiles(MediaFileType.TRAILER).isEmpty()) continue;
            existingTrailer = true;
            break;
        }
        boolean overwriteTrailer = false;
        if (existingTrailer) {
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            int answer = JOptionPane.showOptionDialog(MainWindow.getFrame(), TmmResourceBundle.getString("movie.overwritetrailer"), TmmResourceBundle.getString("tvshow.downloadtrailer"), 0, 3, null, options, null);
            if (answer == 0) {
                overwriteTrailer = true;
            }
        }
        for (TvShow tvShow : selectedTvShows) {
            if (!tvShow.getMediaFiles(MediaFileType.TRAILER).isEmpty() && !overwriteTrailer || tvShow.getTrailer().isEmpty()) continue;
            TvShowHelpers.downloadBestTrailer(tvShow);
        }
    }
}

