/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeEdition;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiTvShowMetadataProvider;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.MediaIdTable;
import org.tinymediamanager.ui.components.MediaRatingTable;
import org.tinymediamanager.ui.components.PersonTable;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmObligatoryTextArea;
import org.tinymediamanager.ui.components.TmmRoundTextArea;
import org.tinymediamanager.ui.components.TmmTabbedPane;
import org.tinymediamanager.ui.components.combobox.AutoCompleteSupport;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.combobox.MediaScraperComboBox;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.AbstractEditorDialog;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.panels.IdEditorPanel;
import org.tinymediamanager.ui.panels.MediaFileEditorPanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;
import org.tinymediamanager.ui.panels.RatingEditorPanel;
import org.tinymediamanager.ui.tvshows.EpisodeNumberTable;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeNumberEditorPanel;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowEpisodeChooserDialog;

public class TvShowEpisodeEditorDialog
extends AbstractEditorDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeEditorDialog.class);
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private static final String DIALOG_ID = "tvShowEpisodeEditor";
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
    private final JTabbedPane tabbedPane = new TmmTabbedPane();
    private final TvShowEpisode episodeToEdit;
    private final List<String> tags = ObservableCollections.observableList(new ArrayList());
    private final List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    private final EventList<MediaEpisodeNumber> episodeNumbers;
    private final EventList<MediaIdTable.MediaId> ids;
    private final EventList<MediaRatingTable.Rating> ratings;
    private final EventList<Person> guests;
    private final EventList<Person> directors;
    private final EventList<Person> writers;
    private JTextArea tfTitle;
    private JSpinner spRating;
    private DatePicker dpFirstAired;
    private JSpinner spDateAdded;
    private JCheckBox chckbxWatched;
    private ImageLabel lblThumb;
    private JTextArea taPlot;
    private AutocompleteComboBox<String> cbTags;
    private AutoCompleteSupport<String> cbTagsAutoCompleteSupport;
    private JList<String> listTags;
    private AutocompleteComboBox<MediaSource> cbMediaSource;
    private AutocompleteComboBox<TvShowEpisodeEdition> cbEdition;
    private MediaFileEditorPanel mediaFilesPanel;
    private MediaScraperComboBox cbScraper;
    private TmmTable tableIds;
    private TmmTable tableRatings;
    private PersonTable tableGuests;
    private PersonTable tableDirectors;
    private PersonTable tableWriters;
    private JTextArea tfOriginalTitle;
    private JTextField tfThumb;
    private JTextArea taNote;
    private TmmTable tableEpisodeNumbers;
    private ScrapeTask scrapeTask = null;

    public TvShowEpisodeEditorDialog(TvShowEpisode episode, int queueIndex, int queueSize, int selectedTab) {
        super(TmmResourceBundle.getString("tvshowepisode.edit") + "  < " + episode.getMainVideoFile().getFilename() + " >", DIALOG_ID, episode);
        this.setMinimumSize(new Dimension(800, 600));
        this.episodeNumbers = GlazedLists.threadSafeList((EventList)new BasicEventList());
        this.guests = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        this.directors = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        this.writers = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        for (MediaFile mf : episode.getMediaFiles()) {
            this.mediaFiles.add(new MediaFile(mf));
        }
        this.episodeToEdit = episode;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.ids = MediaIdTable.convertIdMapToEventList(episode.getIds());
        this.ratings = GlazedLists.threadSafeList(MediaRatingTable.convertRatingMapToEventList(episode.getRatings(), false));
        MediaRating userMediaRating = this.episodeToEdit.getRating("user");
        this.initComponents();
        this.initDataBindings();
        this.tfTitle.setText(this.episodeToEdit.getTitle());
        this.tfOriginalTitle.setText(this.episodeToEdit.getOriginalTitle());
        this.spDateAdded.setValue(this.episodeToEdit.getDateAdded());
        this.spRating.setModel(new SpinnerNumberModel(userMediaRating.getRating(), 0.0, 10.0, 0.1));
        this.lblThumb.setImagePath(this.episodeToEdit.getArtworkFilename(MediaFileType.THUMB));
        this.tfThumb.setText(this.episodeToEdit.getArtworkUrl(MediaFileType.THUMB));
        this.chckbxWatched.setSelected(this.episodeToEdit.isWatched());
        this.taPlot.setText(this.episodeToEdit.getPlot());
        this.taPlot.setCaretPosition(0);
        this.cbMediaSource.setSelectedItem(this.episodeToEdit.getMediaSource());
        this.cbEdition.setSelectedItem(this.episodeToEdit.getEdition());
        this.taNote.setText(this.episodeToEdit.getNote());
        this.episodeNumbers.addAll(this.episodeToEdit.getEpisodeNumbers());
        for (Person origCast : this.episodeToEdit.getActors()) {
            this.guests.add((Object)new Person(origCast));
        }
        for (Person director : this.episodeToEdit.getDirectors()) {
            this.directors.add((Object)new Person(director));
        }
        for (Person writer : this.episodeToEdit.getWriters()) {
            this.writers.add((Object)new Person(writer));
        }
        this.tags.addAll(this.episodeToEdit.getTags());
        this.tabbedPane.setSelectedIndex(selectedTab);
    }

    public int getSelectedTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    private void initComponents() {
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(this.tabbedPane, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JPanel detailsPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details"), detailsPanel);
        detailsPanel.setLayout((LayoutManager)new MigLayout("", "[][20lp:100lp:175lp][50lp:100lp:175lp][200lp:250lp,grow][][25lp:n][200lp:250lp,grow]", "[][][100lp:15%:20%][][100lp:125lp:30%,grow][][][][][50lp:50lp:100lp,grow 50][50lp:50lp:100lp,grow 50]"));
        TmmLabel lblTitle = new TmmLabel(TmmResourceBundle.getString("metatag.title"));
        detailsPanel.add((Component)lblTitle, "cell 0 0,alignx right");
        this.tfTitle = new TmmObligatoryTextArea();
        detailsPanel.add((Component)this.tfTitle, "flowx,cell 1 0 4 1,growx, wmin 0");
        SquareIconButton btnPlay = new SquareIconButton(IconManager.PLAY_INV);
        btnPlay.setFocusable(false);
        btnPlay.addActionListener(e -> {
            MediaFile mf = this.episodeToEdit.getMainVideoFile();
            try {
                TmmUIHelper.openFile(MediaFileHelper.getMainVideoFile(mf));
            }
            catch (Exception ex) {
                LOGGER.error("open file - {}", (Object)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        detailsPanel.add((Component)btnPlay, "cell 1 0 4 1");
        TmmLabel lblOriginalTitleT = new TmmLabel(TmmResourceBundle.getString("metatag.originaltitle"));
        detailsPanel.add((Component)lblOriginalTitleT, "cell 0 1,alignx trailing");
        this.tfOriginalTitle = new TmmRoundTextArea();
        detailsPanel.add((Component)this.tfOriginalTitle, "cell 1 1 4 1,growx, wmin 0");
        TmmLabel lblEpisode = new TmmLabel(TmmResourceBundle.getString("metatag.episode"));
        detailsPanel.add((Component)lblEpisode, "flowy,cell 0 2,alignx right,aligny top");
        JScrollPane scrollPaneEpisodeNumbers = new JScrollPane();
        this.tableEpisodeNumbers = new EpisodeNumberTable(this.episodeNumbers){

            @Override
            protected void editButtonClicked(int row) {
                MediaEpisodeNumber episodeNumber = (MediaEpisodeNumber)TvShowEpisodeEditorDialog.this.episodeNumbers.get(row);
                if (episodeNumber == null) {
                    return;
                }
                ModalPopupPanel popupPanel = TvShowEpisodeEditorDialog.this.createModalPopupPanel();
                popupPanel.setTitle(TmmResourceBundle.getString("episodenumber.edit"));
                TvShowEpisodeNumberEditorPanel episodeNumberEditorPanel = new TvShowEpisodeNumberEditorPanel(episodeNumber, TvShowEpisodeEditorDialog.this.episodeToEdit.getTvShow().getEpisodeGroups());
                popupPanel.setContent(episodeNumberEditorPanel);
                popupPanel.setOnCloseHandler(() -> {
                    MediaEpisodeNumber episodeNumber1 = episodeNumberEditorPanel.getEpisodeNumber();
                    if (episodeNumber1 != null && episodeNumber1.containsAnyNumber()) {
                        TvShowEpisodeEditorDialog.this.addOrEditEpisodeNumber(episodeNumber1);
                    }
                });
                TvShowEpisodeEditorDialog.this.showModalPopupPanel(popupPanel);
            }
        };
        this.tableEpisodeNumbers.configureScrollPane(scrollPaneEpisodeNumbers);
        this.tableEpisodeNumbers.setFocusable(false);
        detailsPanel.add((Component)scrollPaneEpisodeNumbers, "cell 1 2 3 1,grow");
        SquareIconButton btnAddEpisodeNumber = new SquareIconButton(new AddEpisodeNumberAction());
        btnAddEpisodeNumber.setFocusable(false);
        detailsPanel.add((Component)btnAddEpisodeNumber, "cell 0 2,alignx right");
        SquareIconButton btnRemoveEpisodeNumber = new SquareIconButton(new RemoveEpisodeNumberAction());
        btnRemoveEpisodeNumber.setFocusable(false);
        detailsPanel.add((Component)btnRemoveEpisodeNumber, "cell 0 2,alignx right");
        TmmLabel lblFirstAired = new TmmLabel(TmmResourceBundle.getString("metatag.aired"));
        detailsPanel.add((Component)lblFirstAired, "cell 0 3,alignx right");
        this.dpFirstAired = new DatePicker(this.episodeToEdit.getFirstAired());
        detailsPanel.add((Component)this.dpFirstAired, "cell 1 3 2 1,growx");
        TmmLabel lblPlot = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        detailsPanel.add((Component)lblPlot, "cell 0 4,alignx right,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        detailsPanel.add((Component)scrollPane, "cell 1 4 4 1,grow");
        this.taPlot = new JTextArea();
        this.taPlot.setLineWrap(true);
        this.taPlot.setWrapStyleWord(true);
        scrollPane.setViewportView(this.taPlot);
        detailsPanel.add((Component)new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb")), "cell 6 0");
        LinkLabel lblThumbSize = new LinkLabel();
        detailsPanel.add((Component)lblThumbSize, "cell 6 0");
        FlatButton btnDeleteThumb = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteThumb.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteThumb.addActionListener(e -> {
            this.lblThumb.clearImage();
            this.tfThumb.setText("");
        });
        btnDeleteThumb.setFocusable(false);
        detailsPanel.add((Component)btnDeleteThumb, "cell 6 0");
        this.lblThumb = new ImageLabel();
        this.lblThumb.setDesiredAspectRatio(1.7777778f);
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HashMap<String, Object> newIds = new HashMap<String, Object>(TvShowEpisodeEditorDialog.this.episodeToEdit.getIds());
                newIds.put("episodeNr", new ArrayList<MediaEpisodeNumber>((Collection<MediaEpisodeNumber>)TvShowEpisodeEditorDialog.this.episodeNumbers));
                newIds.put("mediaFile", TvShowEpisodeEditorDialog.this.episodeToEdit.getMainFile());
                newIds.put("tvShowIds", TvShowEpisodeEditorDialog.this.episodeToEdit.getTvShow().getIds());
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEpisodeEditorDialog.this, newIds, MediaArtwork.MediaArtworkType.THUMB, TvShowEpisodeEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEpisodeEditorDialog.this.lblThumb, MediaType.TV_EPISODE);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEpisodeEditorDialog.this.episodeToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEpisodeEditorDialog.this.updateArtworkUrl(TvShowEpisodeEditorDialog.this.lblThumb, TvShowEpisodeEditorDialog.this.tfThumb);
            }
        });
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        detailsPanel.add((Component)this.lblThumb, "cell 6 1 1 4,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblThumbSize, this.lblThumb, btnDeleteThumb, MediaFileType.THUMB));
        TmmLabel lblRating = new TmmLabel(TmmResourceBundle.getString("metatag.userrating"));
        detailsPanel.add((Component)lblRating, "cell 0 7,alignx right");
        this.spRating = new JSpinner();
        detailsPanel.add((Component)this.spRating, "cell 1 7 2 1,flowx");
        JLabel lblUserRatingHint = new JLabel(IconManager.HINT);
        lblUserRatingHint.setToolTipText(TmmResourceBundle.getString("edit.userrating.hint"));
        detailsPanel.add((Component)lblUserRatingHint, "cell 1 7 2 1");
        TmmLabel lblRatingsT = new TmmLabel(TmmResourceBundle.getString("metatag.ratings"));
        detailsPanel.add((Component)lblRatingsT, "flowy,cell 0 8,alignx right,aligny top");
        JScrollPane scrollPaneRatings = new JScrollPane();
        detailsPanel.add((Component)scrollPaneRatings, "cell 1 8 3 2,grow");
        this.tableRatings = new MediaRatingTable(this.ratings);
        this.tableRatings.configureScrollPane(scrollPaneRatings);
        this.tableRatings.setFocusable(false);
        SquareIconButton btnAddRating = new SquareIconButton(new AddRatingAction());
        btnAddRating.setFocusable(false);
        detailsPanel.add((Component)btnAddRating, "cell 0 8,alignx right,aligny top");
        SquareIconButton btnRemoveRating = new SquareIconButton(new RemoveRatingAction());
        btnRemoveRating.setFocusable(false);
        detailsPanel.add((Component)btnRemoveRating, "cell 0 8,alignx right,aligny top");
        TmmLabel lblNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        detailsPanel.add((Component)lblNoteT, "cell 0 10,alignx right,aligny top");
        scrollPane = new JScrollPane();
        detailsPanel.add((Component)scrollPane, "cell 1 10 4 1,wmin 0,grow");
        this.taNote = new JTextArea();
        this.taNote.setLineWrap(true);
        this.taNote.setWrapStyleWord(true);
        this.taNote.setForeground(UIManager.getColor("TextField.foreground"));
        scrollPane.setViewportView(this.taNote);
        JPanel details2Panel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details2"), details2Panel);
        details2Panel.setLayout((LayoutManager)new MigLayout("", "[][][20lp:50lp][][20lp:n][][300lp:300lp]", "[][][][20lp:n][100lp:150lp,grow][][][][grow 200]"));
        TmmLabel lblDateAdded = new TmmLabel(TmmResourceBundle.getString("metatag.dateadded"));
        details2Panel.add((Component)lblDateAdded, "cell 0 0,alignx right");
        this.spDateAdded = new JSpinner(new SpinnerDateModel());
        details2Panel.add((Component)this.spDateAdded, "cell 1 0,growx");
        TmmLabel lblWatched = new TmmLabel(TmmResourceBundle.getString("metatag.watched"));
        details2Panel.add((Component)lblWatched, "flowx,cell 3 0,alignx right");
        this.chckbxWatched = new JCheckBox("");
        details2Panel.add((Component)this.chckbxWatched, "cell 3 0");
        TmmLabel lblMediasource = new TmmLabel(TmmResourceBundle.getString("metatag.source"));
        details2Panel.add((Component)lblMediasource, "cell 0 1,alignx right");
        this.cbMediaSource = new AutocompleteComboBox<MediaSource>(MediaSource.values());
        details2Panel.add(this.cbMediaSource, "cell 1 1,growx");
        TmmLabel lblEdition = new TmmLabel(TmmResourceBundle.getString("metatag.edition"));
        details2Panel.add((Component)lblEdition, "cell 0 2,alignx right");
        this.cbEdition = new AutocompleteComboBox<TvShowEpisodeEdition>(TvShowEpisodeEdition.values());
        this.cbEdition.getAutoCompleteSupport().setCorrectsCase(false);
        details2Panel.add(this.cbEdition, "cell 1 2,growx");
        TmmLabel lblTags = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        details2Panel.add((Component)lblTags, "flowy,cell 0 4,alignx right,aligny top");
        JScrollPane scrollPaneTags = new JScrollPane();
        details2Panel.add((Component)scrollPaneTags, "cell 1 4 3 1,grow");
        this.listTags = new JList();
        scrollPaneTags.setViewportView(this.listTags);
        SquareIconButton btnAddTag = new SquareIconButton(new AddTagAction());
        btnAddTag.setFocusable(false);
        details2Panel.add((Component)btnAddTag, "cell 0 4,alignx right,aligny top");
        SquareIconButton btnRemoveTag = new SquareIconButton(new RemoveTagAction());
        btnRemoveTag.setFocusable(false);
        details2Panel.add((Component)btnRemoveTag, "cell 0 4,alignx right,aligny top");
        SquareIconButton btnMoveTagUp = new SquareIconButton(new MoveTagUpAction());
        btnMoveTagUp.setFocusable(false);
        details2Panel.add((Component)btnMoveTagUp, "cell 0 4,alignx right,aligny top");
        SquareIconButton btnMoveTagDown = new SquareIconButton(new MoveTagDownAction());
        btnMoveTagDown.setFocusable(false);
        details2Panel.add((Component)btnMoveTagDown, "cell 0 4,alignx right,aligny top");
        this.cbTags = new AutocompleteComboBox<String>(this.tvShowList.getTagsInEpisodes());
        this.cbTags.setEditable(true);
        this.cbTagsAutoCompleteSupport = this.cbTags.getAutoCompleteSupport();
        details2Panel.add(this.cbTags, "cell 1 5 3 1,growx");
        InputMap im = this.cbTags.getInputMap(1);
        Object enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbTags.getActionMap().put(enterAction, new AddTagAction());
        TmmLabel label = new TmmLabel(TmmResourceBundle.getString("metatag.ids"));
        details2Panel.add((Component)label, "flowy,cell 5 4,alignx right,aligny top");
        JScrollPane scrollPaneIds = new JScrollPane();
        details2Panel.add((Component)scrollPaneIds, "cell 6 4,grow");
        this.tableIds = new MediaIdTable(this.ids, ScraperType.TV_SHOW);
        this.tableIds.configureScrollPane(scrollPaneIds);
        this.tableIds.setFocusable(false);
        SquareIconButton btnAddId = new SquareIconButton(new AddIdAction());
        btnAddId.setFocusable(false);
        details2Panel.add((Component)btnAddId, "cell 5 4,alignx right,aligny top");
        SquareIconButton btnRemoveId = new SquareIconButton(new RemoveIdAction());
        btnRemoveId.setFocusable(false);
        details2Panel.add((Component)btnRemoveId, "cell 5 4,alignx right,aligny top");
        TmmLabel lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        details2Panel.add((Component)lblThumbT, "cell 0 7,alignx right");
        this.tfThumb = new JTextField();
        details2Panel.add((Component)this.tfThumb, "cell 1 7 6 1,growx");
        this.tfThumb.setColumns(10);
        JPanel crewPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("movie.edit.castandcrew"), null, crewPanel, null);
        crewPanel.setLayout((LayoutManager)new MigLayout("", "[][150lp:300lp,grow][20lp:n][][150lp:300lp,grow]", "[100lp:250lp][20lp:n][100lp:200lp]"));
        TmmLabel lblGuests = new TmmLabel(TmmResourceBundle.getString("metatag.guests"));
        crewPanel.add((Component)lblGuests, "flowy,cell 0 0,alignx right,aligny top");
        this.tableGuests = new PersonTable(this.guests);
        this.tableGuests.setAddTitle(TmmResourceBundle.getString("cast.guest.add"));
        this.tableGuests.setEditTitle(TmmResourceBundle.getString("cast.guest.edit"));
        scrollPane = new JScrollPane();
        this.tableGuests.configureScrollPane(scrollPane);
        crewPanel.add((Component)scrollPane, "cell 1 0,grow");
        TmmLabel lblDirectorsT = new TmmLabel(TmmResourceBundle.getString("metatag.directors"));
        crewPanel.add((Component)lblDirectorsT, "flowy,cell 0 2,alignx right,aligny top");
        this.tableDirectors = new PersonTable(this.directors);
        this.tableDirectors.setAddTitle(TmmResourceBundle.getString("cast.director.add"));
        this.tableDirectors.setEditTitle(TmmResourceBundle.getString("cast.director.edit"));
        scrollPane = new JScrollPane();
        this.tableDirectors.configureScrollPane(scrollPane);
        crewPanel.add((Component)scrollPane, "cell 1 2,grow");
        TmmLabel lblWritersT = new TmmLabel(TmmResourceBundle.getString("metatag.writers"));
        crewPanel.add((Component)lblWritersT, "flowy,cell 3 2,alignx right,aligny top");
        this.tableWriters = new PersonTable(this.writers);
        this.tableWriters.setAddTitle(TmmResourceBundle.getString("cast.writer.add"));
        this.tableWriters.setEditTitle(TmmResourceBundle.getString("cast.writer.edit"));
        scrollPane = new JScrollPane();
        this.tableWriters.configureScrollPane(scrollPane);
        crewPanel.add((Component)scrollPane, "cell 4 2,grow");
        SquareIconButton btnAddGuest = new SquareIconButton(new AddGuestAction());
        crewPanel.add((Component)btnAddGuest, "cell 0 0,alignx right");
        SquareIconButton btnRemoveGuest = new SquareIconButton(new RemoveGuestAction());
        crewPanel.add((Component)btnRemoveGuest, "cell 0 0,alignx right");
        SquareIconButton btnMoveGuestUp = new SquareIconButton(new MoveGuestUpAction());
        crewPanel.add((Component)btnMoveGuestUp, "cell 0 0,alignx right");
        SquareIconButton btnMoveGuestDown = new SquareIconButton(new MoveGuestDownAction());
        crewPanel.add((Component)btnMoveGuestDown, "cell 0 0,alignx right,aligny top");
        SquareIconButton btnAddDirector = new SquareIconButton(new AddDirectorAction());
        crewPanel.add((Component)btnAddDirector, "cell 0 2,alignx right");
        SquareIconButton btnRemoveDirector = new SquareIconButton(new RemoveDirectorAction());
        crewPanel.add((Component)btnRemoveDirector, "cell 0 2,alignx right");
        SquareIconButton btnMoveDirectorUp = new SquareIconButton(new MoveDirectorUpAction());
        crewPanel.add((Component)btnMoveDirectorUp, "cell 0 2,alignx right");
        SquareIconButton btnMoveDirectorDown = new SquareIconButton(new MoveDirectorDownAction());
        crewPanel.add((Component)btnMoveDirectorDown, "cell 0 2,alignx right,aligny top");
        SquareIconButton btnAddWriter = new SquareIconButton(new AddWriterAction());
        crewPanel.add((Component)btnAddWriter, "cell 3 2,alignx right");
        SquareIconButton btnRemoveWriter = new SquareIconButton(new RemoveWriterAction());
        crewPanel.add((Component)btnRemoveWriter, "cell 3 2,alignx right");
        SquareIconButton btnMoveWriterUp = new SquareIconButton(new MoveWriterUpAction());
        crewPanel.add((Component)btnMoveWriterUp, "cell 3 2,alignx right");
        SquareIconButton btnMoveWriterDown = new SquareIconButton(new MoveWriterDownAction());
        crewPanel.add((Component)btnMoveWriterDown, "cell 3 2,alignx right,aligny top");
        this.mediaFilesPanel = new MediaFileEditorPanel(this.mediaFiles);
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.mediafiles"), null, this.mediaFilesPanel, null);
        JPanel scrapePanel = new JPanel();
        scrapePanel.setOpaque(false);
        this.cbScraper = new MediaScraperComboBox(this.tvShowList.getAvailableMediaScrapers().stream().filter(scraper -> !(scraper.getMediaProvider() instanceof KodiTvShowMetadataProvider)).collect(Collectors.toList()));
        MediaScraper defaultScraper = this.tvShowList.getDefaultMediaScraper();
        scrapePanel.setLayout((LayoutManager)new MigLayout("", "[100lp:200lp][][][grow]", "[]"));
        this.cbScraper.setSelectedItem(defaultScraper);
        scrapePanel.add((Component)this.cbScraper, "cell 0 0, growx, wmin 0");
        JButton btnScrape = new JButton(new ScrapeAction());
        scrapePanel.add((Component)btnScrape, "cell 1 0");
        JButton btnSearch = new JButton(new SearchAction());
        scrapePanel.add((Component)btnSearch, "cell 2 0");
        this.setBottomInformationPanel(scrapePanel);
        if (this.queueSize > 1) {
            JButton abortButton = new JButton(new AbortQueueAction());
            this.addButton(abortButton);
            if (this.queueIndex > 0) {
                JButton backButton = new JButton(new AbstractEditorDialog.NavigateBackAction(this));
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(new DiscardAction());
        cancelButton.addActionListener(e -> this.mediaFilesPanel.cancelTask());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new ChangeEpisodeAction());
        okButton.addActionListener(e -> this.mediaFilesPanel.cancelTask());
        this.getRootPane().registerKeyboardAction(new ChangeEpisodeAction(), KeyStroke.getKeyStroke(83, 128), 2);
        this.getRootPane().registerKeyboardAction(new ChangeEpisodeAction(), KeyStroke.getKeyStroke(10, 128), 2);
        this.addButton(okButton);
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    private void cancelScrapeTask() {
        if (this.scrapeTask != null && !this.scrapeTask.isDone()) {
            this.scrapeTask.cancel(true);
        }
    }

    private void processArtwork(MediaFileType type, ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{imageLabel.getImagePath(), imageLabel.getImageUrl()}) && StringUtils.isNotBlank((CharSequence)this.episodeToEdit.getArtworkFilename(type))) {
            this.episodeToEdit.deleteMediaFiles(type);
        }
        if (StringUtils.isNotEmpty((CharSequence)textField.getText()) && !textField.getText().equals(this.episodeToEdit.getArtworkUrl(type))) {
            this.episodeToEdit.setArtworkUrl(textField.getText(), type);
            this.episodeToEdit.downloadArtwork(type);
        } else if (StringUtils.isEmpty((CharSequence)textField.getText())) {
            this.episodeToEdit.removeArtworkUrl(type);
        } else if (StringUtils.isBlank((CharSequence)this.episodeToEdit.getArtworkFilename(type))) {
            this.episodeToEdit.downloadArtwork(type);
        }
    }

    protected void initDataBindings() {
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.tags, this.listTags);
        jListBinding.bind();
        this.bindingGroup = new BindingGroup();
        this.bindingGroup.addBinding((Binding)jListBinding);
    }

    @Override
    public void dispose() {
        if (this.mediaFilesPanel != null) {
            this.mediaFilesPanel.unbindBindings();
        }
        if (this.dpFirstAired != null) {
            this.dpFirstAired.cleanup();
        }
        super.dispose();
    }

    private void addOrEditEpisodeNumber(MediaEpisodeNumber episodeNumber) {
        MediaEpisodeNumber existing = this.episodeNumbers.stream().filter(ep -> ep.episodeGroup().equals(episodeNumber.episodeGroup())).findFirst().orElse(null);
        if (existing != null) {
            int index = this.episodeNumbers.indexOf((Object)existing);
            this.episodeNumbers.remove((Object)existing);
            this.episodeNumbers.add(index, (Object)episodeNumber);
            this.ids.clear();
        } else {
            this.episodeNumbers.add((Object)episodeNumber);
        }
    }

    private class ScrapeTask
    extends SwingWorker<Void, Void> {
        private final MediaScraper mediaScraper;
        private MediaMetadata metadata = null;
        private String message = null;

        ScrapeTask(MediaScraper mediaScraper) {
            this.mediaScraper = mediaScraper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() {
            TvShowEpisodeEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            TvShowEpisodeSearchAndScrapeOptions options = new TvShowEpisodeSearchAndScrapeOptions(TvShowEpisodeEditorDialog.this.episodeToEdit.getTvShow().getIds());
            options.setLanguage(TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
            for (MediaIdTable.MediaId mediaId : TvShowEpisodeEditorDialog.this.ids) {
                options.setId(mediaId.key, mediaId.value);
            }
            options.setId("episodeNr", new ArrayList<MediaEpisodeNumber>((Collection<MediaEpisodeNumber>)TvShowEpisodeEditorDialog.this.episodeNumbers));
            options.setEpisodeGroup(TvShowEpisodeEditorDialog.this.episodeToEdit.getTvShow().getEpisodeGroup());
            try {
                LOGGER.info("=====================================================");
                LOGGER.info("Scrape episode metadata with scraper: {}", (Object)this.mediaScraper.getMediaProvider().getProviderInfo().getId());
                LOGGER.info(options.toString());
                LOGGER.info("=====================================================");
                this.metadata = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getMetadata(options);
                this.metadata.setId("tvShowIds", options.getTvShowIds());
                MediaIdUtil.injectMissingIds(this.metadata.getIds(), MediaType.TV_EPISODE);
                if (TvShowModuleManager.getInstance().getSettings().isFetchAllRatings()) {
                    for (MediaRating rating : ListUtils.nullSafe(RatingProvider.getRatings(this.metadata.getIds(), MediaType.TV_EPISODE))) {
                        if (this.metadata.getRatings().contains(rating)) continue;
                        this.metadata.addRating(rating);
                    }
                }
            }
            catch (MissingIdException e) {
                LOGGER.warn("missing id for scrape");
                this.message = TmmResourceBundle.getString("scraper.error.missingid");
            }
            catch (NothingFoundException ignored) {
                LOGGER.debug("nothing found");
                this.message = TmmResourceBundle.getString("message.scrape.tvshowepisodefailed");
            }
            catch (Exception e) {
                LOGGER.error("getMetadata", (Throwable)e);
                this.message = TmmResourceBundle.getString("message.scrape.tvshowepisodefailed");
            }
            finally {
                this.metadata.removeId("tvShowIds");
                TvShowEpisodeEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            if (this.isCancelled()) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)this.message)) {
                JOptionPane.showMessageDialog(TvShowEpisodeEditorDialog.this, this.message);
            }
            if (this.metadata != null && StringUtils.isNotBlank((CharSequence)this.metadata.getTitle())) {
                TvShowEpisodeEditorDialog.this.tfTitle.setText(this.metadata.getTitle());
                TvShowEpisodeEditorDialog.this.tfOriginalTitle.setText(this.metadata.getOriginalTitle());
                TvShowEpisodeEditorDialog.this.taPlot.setText(this.metadata.getPlot());
                TvShowEpisodeEditorDialog.this.dpFirstAired.setDate(this.metadata.getReleaseDate());
                TvShowEpisodeEditorDialog.this.episodeNumbers.clear();
                for (MediaEpisodeGroup.EpisodeGroupType group : MediaEpisodeGroup.EpisodeGroupType.values()) {
                    MediaEpisodeNumber episodeNumber = this.metadata.getEpisodeNumber(group);
                    if (episodeNumber == null || !episodeNumber.isValid()) continue;
                    TvShowEpisodeEditorDialog.this.episodeNumbers.add((Object)episodeNumber);
                }
                TvShowEpisodeEditorDialog.this.ratings.clear();
                TvShowEpisodeEditorDialog.this.ratings.addAll(MediaRatingTable.convertRatingMapToEventList(this.metadata.getRatings()));
                TvShowEpisodeEditorDialog.this.tags.clear();
                TvShowEpisodeEditorDialog.this.tags.addAll(this.metadata.getTags());
                TvShowEpisodeEditorDialog.this.guests.clear();
                TvShowEpisodeEditorDialog.this.directors.clear();
                TvShowEpisodeEditorDialog.this.writers.clear();
                for (Person member : this.metadata.getCastMembers()) {
                    switch (member.getType()) {
                        case ACTOR: {
                            TvShowEpisodeEditorDialog.this.guests.add((Object)new Person(member));
                            break;
                        }
                        case GUEST: {
                            TvShowEpisodeEditorDialog.this.guests.add((Object)new Person(member));
                            break;
                        }
                        case DIRECTOR: {
                            TvShowEpisodeEditorDialog.this.directors.add((Object)new Person(member));
                            break;
                        }
                        case WRITER: {
                            TvShowEpisodeEditorDialog.this.writers.add((Object)new Person(member));
                        }
                    }
                }
                MediaArtwork ma = this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).stream().findFirst().orElse(null);
                if (ma != null) {
                    TvShowEpisodeEditorDialog.this.lblThumb.setImageUrl(ma.getOriginalUrl());
                    TvShowEpisodeEditorDialog.this.tfThumb.setText(ma.getOriginalUrl());
                }
            }
        }
    }

    private class AddEpisodeNumberAction
    extends AbstractAction {
        AddEpisodeNumberAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("episodenumber.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModalPopupPanel popupPanel = TvShowEpisodeEditorDialog.this.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("episodenumber.add"));
            TvShowEpisodeNumberEditorPanel episodeNumberEditorPanel = new TvShowEpisodeNumberEditorPanel(new MediaEpisodeNumber(TvShowEpisodeEditorDialog.this.episodeToEdit.getTvShow().getEpisodeGroup(), -1, -1), TvShowEpisodeEditorDialog.this.episodeToEdit.getTvShow().getEpisodeGroups());
            popupPanel.setContent(episodeNumberEditorPanel);
            popupPanel.setOnCloseHandler(() -> {
                MediaEpisodeNumber episodeNumber = episodeNumberEditorPanel.getEpisodeNumber();
                if (episodeNumber != null && episodeNumber.containsAnyNumber()) {
                    TvShowEpisodeEditorDialog.this.addOrEditEpisodeNumber(episodeNumber);
                }
            });
            TvShowEpisodeEditorDialog.this.showModalPopupPanel(popupPanel);
        }
    }

    private class RemoveEpisodeNumberAction
    extends AbstractAction {
        RemoveEpisodeNumberAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("episodenumber.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableEpisodeNumbers.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableEpisodeNumbers.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.episodeNumbers.remove(row);
            }
        }
    }

    private class AddRatingAction
    extends AbstractAction {
        AddRatingAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("rating.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaRatingTable.Rating rating = new MediaRatingTable.Rating("");
            rating.maxValue = 10;
            rating.votes = 1;
            ModalPopupPanel popupPanel = TvShowEpisodeEditorDialog.this.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("rating.add"));
            popupPanel.setOnCloseHandler(() -> {
                if (StringUtils.isNotBlank((CharSequence)rating.key) && rating.value > 0.0f && rating.maxValue > 0 && rating.votes > 0) {
                    TvShowEpisodeEditorDialog.this.ratings.add((Object)rating);
                }
            });
            RatingEditorPanel ratingEditorPanel = new RatingEditorPanel(rating);
            popupPanel.setContent(ratingEditorPanel);
            TvShowEpisodeEditorDialog.this.showModalPopupPanel(popupPanel);
        }
    }

    private class RemoveRatingAction
    extends AbstractAction {
        RemoveRatingAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("rating.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableRatings.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableRatings.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.ratings.remove(row);
            }
        }
    }

    private class AddTagAction
    extends AbstractAction {
        AddTagAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tag.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField textField;
            String selectedText;
            Object selectedItem = TvShowEpisodeEditorDialog.this.cbTags.getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            String newTag = (String)selectedItem;
            if (StringUtils.isBlank((CharSequence)newTag)) {
                return;
            }
            Component editorComponent = TvShowEpisodeEditorDialog.this.cbTags.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (textField = (JTextField)editorComponent).getSelectedText()) != null) {
                textField.setSelectionStart(0);
                textField.setSelectionEnd(0);
                textField.setCaretPosition(textField.getText().length());
                return;
            }
            boolean tagFound = false;
            for (String tag : TvShowEpisodeEditorDialog.this.tags) {
                if (!tag.equals(newTag)) continue;
                tagFound = true;
                break;
            }
            if (!tagFound) {
                TvShowEpisodeEditorDialog.this.tags.add(newTag);
                if (editorComponent instanceof JTextField) {
                    TvShowEpisodeEditorDialog.this.cbTagsAutoCompleteSupport.setFirstItem("");
                    TvShowEpisodeEditorDialog.this.cbTags.setSelectedIndex(0);
                    TvShowEpisodeEditorDialog.this.cbTagsAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveTagAction
    extends AbstractAction {
        RemoveTagAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tag.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<String> selectedTags = TvShowEpisodeEditorDialog.this.listTags.getSelectedValuesList();
            for (String tag : selectedTags) {
                TvShowEpisodeEditorDialog.this.tags.remove(tag);
            }
        }
    }

    private class MoveTagUpAction
    extends AbstractAction {
        MoveTagUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movetagup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.listTags.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.tags.subList(row - 1, row + 1), 1);
                TvShowEpisodeEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveTagDownAction
    extends AbstractAction {
        MoveTagDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movetagdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.listTags.getSelectedIndex();
            if (row < TvShowEpisodeEditorDialog.this.tags.size() - 1) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.tags.subList(row, row + 2), -1);
                TvShowEpisodeEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class AddIdAction
    extends AbstractAction {
        public AddIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaIdTable.MediaId mediaId = new MediaIdTable.MediaId();
            ModalPopupPanel popupPanel = TvShowEpisodeEditorDialog.this.createModalPopupPanel();
            popupPanel.setTitle(TmmResourceBundle.getString("id.add"));
            popupPanel.setOnCloseHandler(() -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mediaId.key, mediaId.value})) {
                    TvShowEpisodeEditorDialog.this.ids.add((Object)mediaId);
                }
            });
            IdEditorPanel idEditorPanel = new IdEditorPanel(mediaId, ScraperType.TV_SHOW);
            popupPanel.setContent(idEditorPanel);
            TvShowEpisodeEditorDialog.this.showModalPopupPanel(popupPanel);
        }
    }

    private class RemoveIdAction
    extends AbstractAction {
        public RemoveIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableIds.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableIds.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.ids.remove(row);
            }
        }
    }

    private class AddGuestAction
    extends AbstractAction {
        AddGuestAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.guest.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.tableGuests.addPerson(Person.Type.GUEST);
        }
    }

    private class RemoveGuestAction
    extends AbstractAction {
        RemoveGuestAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.guest.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.guests.removeAll(TvShowEpisodeEditorDialog.this.tableGuests.getSelectedPersons());
        }
    }

    private class MoveGuestUpAction
    extends AbstractAction {
        MoveGuestUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.guest.moveup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableGuests.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.guests.subList(row - 1, row + 1), 1);
                TvShowEpisodeEditorDialog.this.tableGuests.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveGuestDownAction
    extends AbstractAction {
        MoveGuestDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.guest.movedown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableGuests.getSelectedRow();
            if (row < TvShowEpisodeEditorDialog.this.guests.size() - 1) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.guests.subList(row, row + 2), -1);
                TvShowEpisodeEditorDialog.this.tableGuests.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class AddDirectorAction
    extends AbstractAction {
        AddDirectorAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.director.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.tableDirectors.addPerson(Person.Type.DIRECTOR);
        }
    }

    private class RemoveDirectorAction
    extends AbstractAction {
        RemoveDirectorAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.director.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.directors.removeAll(TvShowEpisodeEditorDialog.this.tableDirectors.getSelectedPersons());
        }
    }

    private class MoveDirectorUpAction
    extends AbstractAction {
        MoveDirectorUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movedirectorup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableDirectors.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.directors.subList(row - 1, row + 1), 1);
                TvShowEpisodeEditorDialog.this.tableDirectors.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveDirectorDownAction
    extends AbstractAction {
        MoveDirectorDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movedirectordown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableDirectors.getSelectedRow();
            if (row < TvShowEpisodeEditorDialog.this.directors.size() - 1) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.directors.subList(row, row + 2), -1);
                TvShowEpisodeEditorDialog.this.tableDirectors.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class AddWriterAction
    extends AbstractAction {
        AddWriterAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.writer.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.tableWriters.addPerson(Person.Type.WRITER);
        }
    }

    private class RemoveWriterAction
    extends AbstractAction {
        RemoveWriterAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.writer.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.writers.removeAll(TvShowEpisodeEditorDialog.this.tableWriters.getSelectedPersons());
        }
    }

    private class MoveWriterUpAction
    extends AbstractAction {
        MoveWriterUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movewriterup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableWriters.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.writers.subList(row - 1, row + 1), 1);
                TvShowEpisodeEditorDialog.this.tableWriters.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveWriterDownAction
    extends AbstractAction {
        MoveWriterDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movewriterdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableWriters.getSelectedRow();
            if (row < TvShowEpisodeEditorDialog.this.writers.size() - 1) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.writers.subList(row, row + 2), -1);
                TvShowEpisodeEditorDialog.this.tableWriters.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class ScrapeAction
    extends AbstractAction {
        ScrapeAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.scrape"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaScraper scraper = (MediaScraper)TvShowEpisodeEditorDialog.this.cbScraper.getSelectedItem();
            TvShowEpisodeEditorDialog.this.cancelScrapeTask();
            TvShowEpisodeEditorDialog.this.scrapeTask = new ScrapeTask(scraper);
            TvShowEpisodeEditorDialog.this.scrapeTask.execute();
        }
    }

    private class SearchAction
    extends AbstractAction {
        SearchAction() {
            this.putValue("Name", TmmResourceBundle.getString("tvshowepisodechooser.search"));
            this.putValue("SmallIcon", IconManager.SEARCH_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaScraper scraper = (MediaScraper)TvShowEpisodeEditorDialog.this.cbScraper.getSelectedItem();
            TvShowEpisodeChooserDialog dialog = new TvShowEpisodeChooserDialog((JDialog)TvShowEpisodeEditorDialog.this, TvShowEpisodeEditorDialog.this.episodeToEdit, scraper);
            dialog.setLocationRelativeTo(TvShowEpisodeEditorDialog.this);
            dialog.setVisible(true);
            MediaMetadata metadata = dialog.getMetadata();
            if (metadata != null && !metadata.getEpisodeNumbers().isEmpty()) {
                TvShowEpisodeEditorDialog.this.tfTitle.setText(metadata.getTitle());
                TvShowEpisodeEditorDialog.this.tfOriginalTitle.setText(metadata.getOriginalTitle());
                TvShowEpisodeEditorDialog.this.taPlot.setText(metadata.getPlot());
                TvShowEpisodeEditorDialog.this.episodeNumbers.clear();
                for (MediaEpisodeGroup.EpisodeGroupType group : MediaEpisodeGroup.EpisodeGroupType.values()) {
                    MediaEpisodeNumber episodeNumber = metadata.getEpisodeNumber(group);
                    if (episodeNumber == null || !episodeNumber.isValid()) continue;
                    TvShowEpisodeEditorDialog.this.episodeNumbers.add((Object)episodeNumber);
                }
                TvShowEpisodeEditorDialog.this.ids.clear();
                TvShowEpisodeEditorDialog.this.ids.addAll(MediaIdTable.convertIdMapToEventList(metadata.getIds()));
                TvShowEpisodeEditorDialog.this.guests.clear();
                TvShowEpisodeEditorDialog.this.writers.clear();
                TvShowEpisodeEditorDialog.this.directors.clear();
                for (Person member : metadata.getCastMembers()) {
                    switch (member.getType()) {
                        case GUEST: {
                            TvShowEpisodeEditorDialog.this.guests.add((Object)new Person(member));
                            break;
                        }
                        case ACTOR: {
                            TvShowEpisodeEditorDialog.this.guests.add((Object)new Person(member));
                            break;
                        }
                        case DIRECTOR: {
                            TvShowEpisodeEditorDialog.this.directors.add((Object)new Person(member));
                            break;
                        }
                        case WRITER: {
                            TvShowEpisodeEditorDialog.this.writers.add((Object)new Person(member));
                        }
                    }
                }
                MediaArtwork ma = metadata.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).stream().findFirst().orElse(null);
                if (ma != null) {
                    TvShowEpisodeEditorDialog.this.tfThumb.setText(ma.getOriginalUrl());
                    TvShowEpisodeEditorDialog.this.lblThumb.setImageUrl(ma.getOriginalUrl());
                }
            }
        }
    }

    private class AbortQueueAction
    extends AbstractAction {
        AbortQueueAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.abortqueue"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.edit.abortqueue.desc"));
            this.putValue("SmallIcon", IconManager.STOP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.continueQueue = false;
            TvShowEpisodeEditorDialog.this.setVisible(false);
        }
    }

    private class DiscardAction
    extends AbstractAction {
        DiscardAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.cancelScrapeTask();
            TvShowEpisodeEditorDialog.this.setVisible(false);
        }
    }

    private class ChangeEpisodeAction
    extends AbstractAction {
        ChangeEpisodeAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.ok"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.change"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringUtils.isBlank((CharSequence)TvShowEpisodeEditorDialog.this.tfTitle.getText())) {
                TvShowEpisodeEditorDialog.this.tfTitle.requestFocusInWindow();
                return;
            }
            TvShowEpisodeEditorDialog.this.cancelScrapeTask();
            TvShowEpisodeEditorDialog.this.commitChanges();
            TvShowEpisodeEditorDialog.this.episodeToEdit.setTitle(TvShowEpisodeEditorDialog.this.tfTitle.getText());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setOriginalTitle(TvShowEpisodeEditorDialog.this.tfOriginalTitle.getText());
            HashMap<MediaEpisodeGroup, MediaEpisodeNumber> epNumbers = new HashMap<MediaEpisodeGroup, MediaEpisodeNumber>();
            for (MediaEpisodeNumber episodeNumber : TvShowEpisodeEditorDialog.this.episodeNumbers) {
                if (!episodeNumber.containsAnyNumber()) continue;
                epNumbers.put(episodeNumber.episodeGroup(), episodeNumber);
            }
            TvShowEpisodeEditorDialog.this.episodeToEdit.setEpisodeNumbers(epNumbers);
            TvShowEpisodeEditorDialog.this.episodeToEdit.setPlot(TvShowEpisodeEditorDialog.this.taPlot.getText());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setNote(TvShowEpisodeEditorDialog.this.taNote.getText());
            Object obj = TvShowEpisodeEditorDialog.this.cbMediaSource.getSelectedItem();
            if (obj instanceof MediaSource) {
                MediaSource mediaSource = (MediaSource)obj;
                TvShowEpisodeEditorDialog.this.episodeToEdit.setMediaSource(mediaSource);
            } else if (obj instanceof String) {
                String mediaSource = (String)obj;
                TvShowEpisodeEditorDialog.this.episodeToEdit.setMediaSource(MediaSource.getMediaSource(mediaSource));
            } else {
                TvShowEpisodeEditorDialog.this.episodeToEdit.setMediaSource(MediaSource.UNKNOWN);
            }
            Object episodeEdition = TvShowEpisodeEditorDialog.this.cbEdition.getSelectedItem();
            if (episodeEdition instanceof TvShowEpisodeEdition) {
                TvShowEpisodeEdition edition = (TvShowEpisodeEdition)episodeEdition;
                TvShowEpisodeEditorDialog.this.episodeToEdit.setEdition(edition);
            } else if (episodeEdition instanceof String) {
                String str = (String)episodeEdition;
                TvShowEpisodeEditorDialog.this.episodeToEdit.setEdition(TvShowEpisodeEdition.getTvShowEpisodeEditionStrict(str));
            } else {
                TvShowEpisodeEditorDialog.this.episodeToEdit.setEdition(TvShowEpisodeEdition.NONE);
            }
            for (Iterator id : TvShowEpisodeEditorDialog.this.ids) {
                try {
                    Integer value = Integer.parseInt(((MediaIdTable.MediaId)((Object)id)).value);
                    TvShowEpisodeEditorDialog.this.episodeToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, value);
                }
                catch (NumberFormatException ex) {
                    TvShowEpisodeEditorDialog.this.episodeToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, ((MediaIdTable.MediaId)((Object)id)).value);
                }
            }
            ArrayList<String> removeIds = new ArrayList<String>();
            for (Map.Entry entry : TvShowEpisodeEditorDialog.this.episodeToEdit.getIds().entrySet()) {
                MediaIdTable.MediaId id = new MediaIdTable.MediaId((String)entry.getKey());
                if (TvShowEpisodeEditorDialog.this.ids.contains((Object)id)) continue;
                removeIds.add((String)entry.getKey());
            }
            for (String id : removeIds) {
                TvShowEpisodeEditorDialog.this.episodeToEdit.setId(id, null);
            }
            MediaFileEditorPanel.syncMediaFiles(TvShowEpisodeEditorDialog.this.mediaFiles, TvShowEpisodeEditorDialog.this.episodeToEdit.getMediaFiles());
            TvShowEpisodeEditorDialog.this.episodeToEdit.fireEventForChangedMediaInformation();
            HashMap<String, MediaRating> ratings = new HashMap<String, MediaRating>();
            double userRating = (Double)TvShowEpisodeEditorDialog.this.spRating.getValue();
            if (userRating > 0.0) {
                ratings.put("user", new MediaRating("user", userRating, 1, 10));
            }
            for (MediaRatingTable.Rating mediaRating : TvShowEpisodeEditorDialog.this.ratings) {
                if (!StringUtils.isNotBlank((CharSequence)mediaRating.key) || !(mediaRating.value > 0.0f) || mediaRating.votes <= 0) continue;
                MediaRating rating = new MediaRating(mediaRating.key, mediaRating.value, mediaRating.votes, mediaRating.maxValue);
                ratings.put(mediaRating.key, rating);
            }
            TvShowEpisodeEditorDialog.this.episodeToEdit.setRatings(ratings);
            if (userRating == 0.0) {
                TvShowEpisodeEditorDialog.this.episodeToEdit.removeRating("user");
            }
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDateAdded((Date)TvShowEpisodeEditorDialog.this.spDateAdded.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setFirstAired(TvShowEpisodeEditorDialog.this.dpFirstAired.getDate());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setWatched(TvShowEpisodeEditorDialog.this.chckbxWatched.isSelected());
            TvShowEpisodeEditorDialog.this.episodeToEdit.removeActors();
            TvShowEpisodeEditorDialog.this.episodeToEdit.setActors((List<Person>)TvShowEpisodeEditorDialog.this.guests);
            TvShowEpisodeEditorDialog.this.episodeToEdit.removeDirectors();
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDirectors((List<Person>)TvShowEpisodeEditorDialog.this.directors);
            TvShowEpisodeEditorDialog.this.episodeToEdit.removeWriters();
            TvShowEpisodeEditorDialog.this.episodeToEdit.setWriters((List<Person>)TvShowEpisodeEditorDialog.this.writers);
            TvShowEpisodeEditorDialog.this.processArtwork(MediaFileType.THUMB, TvShowEpisodeEditorDialog.this.lblThumb, TvShowEpisodeEditorDialog.this.tfThumb);
            TvShowEpisodeEditorDialog.this.episodeToEdit.removeAllTags();
            TvShowEpisodeEditorDialog.this.episodeToEdit.setTags(TvShowEpisodeEditorDialog.this.tags);
            TvShowEpisodeEditorDialog.this.episodeToEdit.writeNFO();
            TvShowEpisodeEditorDialog.this.episodeToEdit.saveToDb();
            TvShowEpisodeEditorDialog.this.setVisible(false);
        }
    }
}

