/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.floreysoft.jmte.Engine;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TablePopupListener;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmRoundMultilineTextArea;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.SettingsDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.renderer.MultilineTableCellRenderer;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowJmteExplorerDialog
extends TmmDialog {
    private final Engine engine;
    private final boolean renamerMode;
    private final ButtonGroup buttonGroup;
    private JComboBox<TvShowPreviewContainer> cbTvShowForPreview;
    private JComboBox<EpisodePreviewContainer> cbEpisodeForPreview;
    private JComboBox<EntityContainer> cbEntity;
    private JTextArea taJmteTokens;
    private JRadioButton btnPureJmte;
    private JRadioButton btnRenamerFoldername;
    private JButton btnGetFolderPattern;
    private JButton btnSetFolderPattern;
    private JRadioButton btnRenamerFilename;
    private JButton btnGetFilePattern;
    private JButton btnSetFilePattern;
    private JTextArea taResult;
    private JTextArea taError;
    private JLabel lblEntityTemplate;
    private TmmTable tableExamples;
    private final EventList<RenamerExample> exampleEventList;
    private final EventList<EntityExample> entityExampleEventList;
    private final EventList<RendererExample> rendererExampleList;

    public TvShowJmteExplorerDialog(Window owner) {
        super(owner, TmmResourceBundle.getString("jmteexplorer.title"), "tvshowjmteexplorer");
        this.setMinimumSize(new Dimension(900, 600));
        this.engine = TvShowRenamer.createEngine();
        this.buttonGroup = new ButtonGroup();
        if (owner instanceof SettingsDialog) {
            this.renamerMode = true;
        } else {
            this.renamerMode = false;
            this.setModalityType(Dialog.ModalityType.MODELESS);
        }
        this.exampleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(RenamerExample.class)));
        this.rendererExampleList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(RendererExample.class)));
        this.entityExampleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(EntityExample.class)));
        this.setModal(false);
        this.initComponents();
        this.buildAndInstallTvShowArray();
        this.buildAndInstallEpisodeArray();
        this.setListeners();
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new CopyShortRenamerTokenAction());
        popupMenu.add(new CopyLongRenamerTokenAction());
        this.tableExamples.addMouseListener(new TablePopupListener(popupMenu, this.tableExamples));
        KeyStroke copy = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false);
        this.tableExamples.registerKeyboardAction(new CopyShortRenamerTokenAction(), "Copy", copy, 0);
        this.tableExamples.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() >= 2 && !e.isConsumed() && e.getButton() == 1 && (row = TvShowJmteExplorerDialog.this.tableExamples.getSelectedRow()) > -1) {
                    row = TvShowJmteExplorerDialog.this.tableExamples.convertRowIndexToModel(row);
                    RenamerExample example = (RenamerExample)TvShowJmteExplorerDialog.this.exampleEventList.get(row);
                    if (StringUtils.isNotBlank((CharSequence)example.token)) {
                        TvShowJmteExplorerDialog.this.taJmteTokens.setText(TvShowJmteExplorerDialog.this.taJmteTokens.getText() + example.token);
                    } else {
                        TvShowJmteExplorerDialog.this.taJmteTokens.setText(TvShowJmteExplorerDialog.this.taJmteTokens.getText() + example.longToken);
                    }
                }
            }
        });
    }

    private void initComponents() {
        JPanel panelHeader = new JPanel((LayoutManager)new MigLayout("insets 0", "[grow]", "[][shrink 0][2lp]"));
        JPanel panelTop = new JPanel((LayoutManager)new MigLayout("", "[][][grow]", "[][]"));
        panelTop.add((Component)new TmmLabel(TmmResourceBundle.getString("tmm.tvshow")), "cell 0 0");
        this.cbTvShowForPreview = new JComboBox();
        panelTop.add(this.cbTvShowForPreview, "cell 1 0, wmin 0");
        JButton btnHelp = new JButton(TmmResourceBundle.getString("tmm.help"));
        btnHelp.addActionListener(e -> {
            String url = StringEscapeUtils.unescapeHtml4((String)"https://www.tinymediamanager.org/docs/tvshows/renamer");
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception ex) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        panelTop.add((Component)btnHelp, "cell 2 0, trailing");
        panelTop.add((Component)new TmmLabel(TmmResourceBundle.getString("metatag.episode")), "cell 0 1");
        this.cbEpisodeForPreview = new JComboBox();
        panelTop.add(this.cbEpisodeForPreview, "cell 1 1, wmin 0");
        panelHeader.add((Component)panelTop, "cell 0 0, growx");
        panelHeader.add((Component)new JSeparator(), "cell 0 1 3 1, grow");
        this.setTopPanel(panelHeader);
        JSplitPane contentPanel = new JSplitPane();
        contentPanel.setContinuousLayout(true);
        contentPanel.setResizeWeight(0.4);
        contentPanel.setOneTouchExpandable(true);
        contentPanel.setName("tvShowJmteExplorer.splitPane");
        MainTabbedPane tabbedPane = new MainTabbedPane(){

            @Override
            public void updateUI() {
                this.putClientProperty("rightBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                this.putClientProperty("roundEdge", Boolean.FALSE);
                super.updateUI();
            }
        };
        tabbedPane.add(TmmResourceBundle.getString("jmteexplorer.commontokens"), this.createExamplesPanel());
        tabbedPane.add(TmmResourceBundle.getString("jmteexplorer.renderer"), this.createRendererPanel());
        tabbedPane.add(TmmResourceBundle.getString("jmteexplorer.entities"), this.createEntitiesPanel());
        contentPanel.setLeftComponent(tabbedPane);
        tabbedPane = new MainTabbedPane(){

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                this.putClientProperty("roundEdge", Boolean.FALSE);
                super.updateUI();
            }
        };
        tabbedPane.add(TmmResourceBundle.getString("jmteexplorer.tryyourself"), this.createPlaygroundPanel());
        contentPanel.setRightComponent(tabbedPane);
        this.add(contentPanel);
        if (this.renamerMode) {
            JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.cancel"));
            btnCancel.setIcon(IconManager.CANCEL_INV);
            btnCancel.addActionListener(e -> {
                this.taJmteTokens.setText("");
                this.setVisible(false);
            });
            this.addButton(btnCancel);
            JButton btnDone = new JButton(TmmResourceBundle.getString("Button.apply"));
            btnDone.setIcon(IconManager.APPLY_INV);
            btnDone.addActionListener(e -> this.setVisible(false));
            this.addButton(btnDone);
        } else {
            JButton btnDone = new JButton(TmmResourceBundle.getString("Button.close"));
            btnDone.setIcon(IconManager.APPLY_INV);
            btnDone.addActionListener(e -> this.setVisible(false));
            this.addButton(btnDone);
        }
        TmmUILayoutStore.getInstance().install(contentPanel);
    }

    private void buildAndInstallTvShowArray() {
        ArrayList<TvShow> allTvShows = new ArrayList<TvShow>(TvShowModuleManager.getInstance().getTvShowList().getTvShows());
        TvShow sel = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShow();
        allTvShows.sort(Comparator.comparing(MediaEntity::getTitle));
        for (TvShow tvShow : allTvShows) {
            TvShowPreviewContainer container = new TvShowPreviewContainer();
            container.tvShow = tvShow;
            this.cbTvShowForPreview.addItem(container);
            if (!tvShow.equals(sel)) continue;
            this.cbTvShowForPreview.setSelectedItem(container);
        }
    }

    private void buildAndInstallEpisodeArray() {
        this.cbEpisodeForPreview.removeAllItems();
        Object obj = this.cbTvShowForPreview.getSelectedItem();
        if (obj instanceof TvShowPreviewContainer) {
            TvShowPreviewContainer c = (TvShowPreviewContainer)this.cbTvShowForPreview.getSelectedItem();
            List<TvShowEpisode> sel = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
            for (TvShowEpisode episode : c.tvShow.getEpisodes()) {
                EpisodePreviewContainer container = new EpisodePreviewContainer();
                container.episode = episode;
                this.cbEpisodeForPreview.addItem(container);
                if (sel == null || sel.isEmpty() || !episode.equals(sel.get(0))) continue;
                this.cbEpisodeForPreview.setSelectedItem(container);
            }
        }
    }

    private void createRenamerExample() {
        Object container;
        TvShow tvShow = null;
        TvShowEpisode episode = null;
        Object object = this.cbTvShowForPreview.getSelectedItem();
        if (object instanceof TvShowPreviewContainer) {
            container = (TvShowPreviewContainer)object;
            tvShow = ((TvShowPreviewContainer)container).tvShow;
        }
        if ((object = this.cbEpisodeForPreview.getSelectedItem()) instanceof EpisodePreviewContainer) {
            container = (EpisodePreviewContainer)object;
            episode = ((EpisodePreviewContainer)container).episode;
        }
        if (tvShow != null && episode != null) {
            String result = "";
            if (StringUtils.isNotBlank((CharSequence)this.taJmteTokens.getText())) {
                try {
                    if (this.btnPureJmte.isSelected()) {
                        result = this.processPattern(tvShow, episode, this.taJmteTokens.getText());
                    } else if (this.btnRenamerFoldername.isSelected()) {
                        result = TvShowRenamer.getTvShowFoldername(this.taJmteTokens.getText(), tvShow);
                    } else if (this.btnRenamerFilename.isSelected()) {
                        MediaFile episodeMf = TvShowRenamer.generateEpisodeFilenames(this.taJmteTokens.getText(), tvShow, episode.getMainVideoFile(), FilenameUtils.getBaseName((String)episode.getMainVideoFile().getFilename())).get(0);
                        result = episodeMf.getFile().toString().replace(episode.getTvShow().getPath() + File.separator, "");
                    }
                    this.taError.setText(null);
                }
                catch (Exception e) {
                    this.taError.setText(e.getMessage());
                }
            } else {
                result = "";
                this.taError.setText(null);
            }
            this.taResult.setText(result);
        } else {
            this.taResult.setText("");
        }
    }

    private String processPattern(TvShow tvShow, TvShowEpisode episode, String pattern) throws Exception {
        HashMap<String, MediaEntity> root = new HashMap<String, MediaEntity>();
        root.put("tvShow", tvShow);
        root.put("episode", episode);
        root.put("season", episode.getTvShowSeason());
        return this.engine.transform(JmteUtils.morphTemplate(pattern, TvShowRenamer.getTokenMap()), root);
    }

    private JPanel createExamplesPanel() {
        this.exampleEventList.add((Object)new RenamerExample("${title}"));
        this.exampleEventList.add((Object)new RenamerExample("${originalTitle}"));
        this.exampleEventList.add((Object)new RenamerExample("${originalFilename}"));
        this.exampleEventList.add((Object)new RenamerExample("${originalBasename}"));
        this.exampleEventList.add((Object)new RenamerExample("${titleSortable}"));
        this.exampleEventList.add((Object)new RenamerExample("${seasonNr}"));
        this.exampleEventList.add((Object)new RenamerExample("${seasonNr2}"));
        this.exampleEventList.add((Object)new RenamerExample("${episodeNr}"));
        this.exampleEventList.add((Object)new RenamerExample("${episodeNr2}"));
        this.exampleEventList.add((Object)new RenamerExample("${seasonNrAired}"));
        this.exampleEventList.add((Object)new RenamerExample("${seasonNrAired2}"));
        this.exampleEventList.add((Object)new RenamerExample("${episodeNrAired}"));
        this.exampleEventList.add((Object)new RenamerExample("${episodeNrAired2}"));
        this.exampleEventList.add((Object)new RenamerExample("${seasonNrDvd}"));
        this.exampleEventList.add((Object)new RenamerExample("${seasonNrDvd2}"));
        this.exampleEventList.add((Object)new RenamerExample("${episodeNrDvd}"));
        this.exampleEventList.add((Object)new RenamerExample("${episodeNrDvd2}"));
        this.exampleEventList.add((Object)new RenamerExample("${absoluteNr}"));
        this.exampleEventList.add((Object)new RenamerExample("${absoluteNr2}"));
        this.exampleEventList.add((Object)new RenamerExample("${airedDate}"));
        this.exampleEventList.add((Object)new RenamerExample("${episodeRating}"));
        this.exampleEventList.add((Object)new RenamerExample("${episodeImdb}"));
        this.exampleEventList.add((Object)new RenamerExample("${episodeTmdb}"));
        this.exampleEventList.add((Object)new RenamerExample("${episodeTvdb}"));
        this.exampleEventList.add((Object)new RenamerExample("${episodeTags[0]}"));
        this.exampleEventList.add((Object)new RenamerExample("${year}"));
        this.exampleEventList.add((Object)new RenamerExample("${showYear}"));
        this.exampleEventList.add((Object)new RenamerExample("${showTitle}"));
        this.exampleEventList.add((Object)new RenamerExample("${showOriginalTitle}"));
        this.exampleEventList.add((Object)new RenamerExample("${showTitleSortable}"));
        this.exampleEventList.add((Object)new RenamerExample("${showRating}"));
        this.exampleEventList.add((Object)new RenamerExample("${showImdb}"));
        this.exampleEventList.add((Object)new RenamerExample("${showTmdb}"));
        this.exampleEventList.add((Object)new RenamerExample("${showTvdb}"));
        this.exampleEventList.add((Object)new RenamerExample("${showCertification}"));
        this.exampleEventList.add((Object)new RenamerExample("${showStatus}"));
        this.exampleEventList.add((Object)new RenamerExample("${showProductionCompany}"));
        this.exampleEventList.add((Object)new RenamerExample("${showProductionCompanyAsArray[0]}"));
        this.exampleEventList.add((Object)new RenamerExample("${showTags[0]}"));
        this.exampleEventList.add((Object)new RenamerExample("${showGenres[0]}"));
        this.exampleEventList.add((Object)new RenamerExample("${showGenres[0].name}"));
        this.exampleEventList.add((Object)new RenamerExample("${showGenresAsString}"));
        this.exampleEventList.add((Object)new RenamerExample("${videoResolution}"));
        this.exampleEventList.add((Object)new RenamerExample("${aspectRatio}"));
        this.exampleEventList.add((Object)new RenamerExample("${aspectRatio2}"));
        this.exampleEventList.add((Object)new RenamerExample("${videoCodec}"));
        this.exampleEventList.add((Object)new RenamerExample("${videoFormat}"));
        this.exampleEventList.add((Object)new RenamerExample("${videoBitDepth}"));
        this.exampleEventList.add((Object)new RenamerExample("${videoBitRate}"));
        this.exampleEventList.add((Object)new RenamerExample("${framerate}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioCodec}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioCodecList}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioCodecsAsString}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioChannels}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioChannelList}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioChannelsAsString}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioChannelsDot}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioChannelDotList}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioChannelsDotAsString}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioLanguage}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioLanguageList}"));
        this.exampleEventList.add((Object)new RenamerExample("${audioLanguagesAsString}"));
        this.exampleEventList.add((Object)new RenamerExample("${subtitleLanguageList}"));
        this.exampleEventList.add((Object)new RenamerExample("${subtitleLanguagesAsString}"));
        this.exampleEventList.add((Object)new RenamerExample("${mediaSource}"));
        this.exampleEventList.add((Object)new RenamerExample("${hdr}"));
        this.exampleEventList.add((Object)new RenamerExample("${hdrformat}"));
        this.exampleEventList.add((Object)new RenamerExample("${filesize}"));
        this.exampleEventList.add((Object)new RenamerExample("${parent}"));
        this.exampleEventList.add((Object)new RenamerExample("${showNote}"));
        this.exampleEventList.add((Object)new RenamerExample("${note}"));
        this.exampleEventList.add((Object)new RenamerExample("${crc32}"));
        this.tableExamples = new TmmTable((TableModel)((Object)new TmmTableModel<RenamerExample>((EventList<RenamerExample>)GlazedListsSwing.swingThreadProxyList(this.exampleEventList), new RenamerExampleTableFormat())));
        NoBorderScrollPane scrollPane = new NoBorderScrollPane();
        this.tableExamples.configureScrollPane(scrollPane);
        this.tableExamples.setRowHeight(35);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "[grow]", "[grow]"));
        panel.add((Component)scrollPane, "cell 0 0, grow");
        return panel;
    }

    private JPanel createRendererPanel() {
        this.rendererExampleList.add((Object)new RendererExample("--- string renderers ---"));
        this.rendererExampleList.add((Object)new RendererExample("${tvShow.title;upper}"));
        this.rendererExampleList.add((Object)new RendererExample("${tvShow.title;lower}"));
        this.rendererExampleList.add((Object)new RendererExample("${tvShow.title;first}"));
        this.rendererExampleList.add((Object)new RendererExample("${episode.title;upper}"));
        this.rendererExampleList.add((Object)new RendererExample("${episode.title;lower}"));
        this.rendererExampleList.add((Object)new RendererExample("${episode.title;first}"));
        this.rendererExampleList.add((Object)new RendererExample("${tvShow.genresAsString;split(0,2)}"));
        this.rendererExampleList.add((Object)new RendererExample("${tvShow.title;replace(a,XX)}"));
        this.rendererExampleList.add((Object)new RendererExample("${tvShow.title;replace(umlauts.csv)}"));
        this.rendererExampleList.add((Object)new RendererExample("--- arrays ---"));
        this.rendererExampleList.add((Object)new RendererExample("${tvShow.genres}"));
        this.rendererExampleList.add((Object)new RendererExample("${tvShow.genres;array}"));
        this.rendererExampleList.add((Object)new RendererExample("${tvShow.genres[0]}"));
        this.rendererExampleList.add((Object)new RendererExample("${tvShow.genres[0,2]}"));
        this.rendererExampleList.add((Object)new RendererExample("${episode.mediaInfoAudioLanguageList;uniqueArray}"));
        this.rendererExampleList.add((Object)new RendererExample("--- format ---"));
        this.rendererExampleList.add((Object)new RendererExample("${episode.releaseDate;date(yyyy-MM-dd)}"));
        this.rendererExampleList.add((Object)new RendererExample("${episode.ratings.imdb.rating;number(%.0f)}"));
        this.rendererExampleList.add((Object)new RendererExample("${episode.videofilesize;filesize(G)}"));
        this.rendererExampleList.add((Object)new RendererExample("${episode.mediaInfoVideoBitrate;bitrate(Mbps)}"));
        this.rendererExampleList.add((Object)new RendererExample("${episode.mediaInfoFrameRate;framerate(round)}"));
        this.rendererExampleList.add((Object)new RendererExample("--- enhanced ---"));
        this.rendererExampleList.add((Object)new RendererExample("${tvShow.title;chain(replace(a,XX);lower)}"));
        TmmTable tableRendererExamples = new TmmTable((TableModel)((Object)new TmmTableModel<RendererExample>((EventList<RendererExample>)GlazedListsSwing.swingThreadProxyList(this.rendererExampleList), new RendererExampleTableFormat())));
        JScrollPane scrollPane = new JScrollPane();
        tableRendererExamples.configureScrollPane(scrollPane);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "[grow]", "[grow]"));
        panel.add((Component)scrollPane, "cell 0 0, grow");
        return panel;
    }

    private JPanel createEntitiesPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "[grow]", "[][][grow]"));
        Vector<EntityContainer> entityContainers = new Vector<EntityContainer>();
        entityContainers.add(new EntityContainer());
        entityContainers.add(new EntityContainer(TvShow.class, "${tvShow}", tvShow -> tvShow));
        entityContainers.add(new EntityContainer(TvShowEpisode.class, "${episode}", episode -> episode));
        entityContainers.add(new EntityContainer(TvShowSeason.class, "${episode.tvShowSeason}", season -> season));
        entityContainers.add(new EntityContainer(MediaFile.class, "${episode.mainVideoFile}", episode -> ((TvShowEpisode)episode).getMainVideoFile()));
        entityContainers.add(new EntityContainer(Person.class, "${tvShow.actors[0]}", tvShow -> ListUtils.getFirst(((TvShow)tvShow).getActors())));
        entityContainers.add(new EntityContainer(MediaGenres.class, "${tvShow.genres[0]}", tvShow -> ListUtils.getFirst(((TvShow)tvShow).getActors())));
        entityContainers.add(new EntityContainer(MediaFileAudioStream.class, "${episode.mainVideoFile.audioStreams[0]}", episode -> ListUtils.getFirst(((TvShowEpisode)episode).getMainVideoFile().getAudioStreams())));
        entityContainers.add(new EntityContainer(MediaFileSubtitle.class, "${episode.mainVideoFile.subtitles[0]}", episode -> ListUtils.getFirst(((TvShowEpisode)episode).getMainVideoFile().getSubtitles())));
        entityContainers.add(new EntityContainer(MediaTrailer.class, "${tvShow.trailer[0]}", tvShow -> ListUtils.getFirst(((TvShow)tvShow).getTrailer())));
        panel.add((Component)new TmmLabel(TmmResourceBundle.getString("jmteexplorer.entity")), "cell 0 0");
        this.cbEntity = new JComboBox(entityContainers);
        panel.add(this.cbEntity, "cell 0 0");
        panel.add((Component)new TmmLabel(TmmResourceBundle.getString("jmteexplorer.pattern")), "cell 0 1");
        this.lblEntityTemplate = new JLabel("");
        panel.add((Component)this.lblEntityTemplate, "cell 0 1, growx, wmin 0");
        TmmTable tableEntityExamples = new TmmTable((TableModel)((Object)new TmmTableModel<EntityExample>((EventList<EntityExample>)GlazedListsSwing.swingThreadProxyList(this.entityExampleEventList), new EntityExampleTableFormat())));
        JScrollPane scrollPane = new JScrollPane();
        tableEntityExamples.configureScrollPane(scrollPane);
        panel.add((Component)scrollPane, "cell 0 2, grow");
        return panel;
    }

    private JPanel createPlaygroundPanel() {
        JPanel panelContent = new JPanel((LayoutManager)new MigLayout("insets 0", "[grow]", "[]10lp![shrink 0]10lp![]"));
        JPanel panelTop = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[grow][]", "[][50lp:n][][][][]10lp![]"));
        panelTop.add((Component)new TmmLabel(TmmResourceBundle.getString("jmteexplorer.pattern")), "cell 0 0");
        JButton btnHelp = new JButton(TmmResourceBundle.getString("tmm.help.jmte"));
        btnHelp.addActionListener(e -> {
            String url = StringEscapeUtils.unescapeHtml4((String)"https://www.tinymediamanager.org/docs/jmte");
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception ex) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        panelTop.add((Component)btnHelp, "cell 1 0, trailing");
        this.taJmteTokens = new TmmRoundMultilineTextArea();
        panelTop.add((Component)this.taJmteTokens, "cell 0 1 2 1, grow, wmin 0");
        this.btnPureJmte = new JRadioButton(TmmResourceBundle.getString("jmteexplorer.purejmte"));
        this.buttonGroup.add(this.btnPureJmte);
        this.btnRenamerFoldername = new JRadioButton(TmmResourceBundle.getString("jmteexplorer.foldername"));
        this.buttonGroup.add(this.btnRenamerFoldername);
        this.btnRenamerFilename = new JRadioButton(TmmResourceBundle.getString("jmteexplorer.filename"));
        this.buttonGroup.add(this.btnRenamerFilename);
        this.btnGetFolderPattern = new SquareIconButton(IconManager.FILE_IMPORT_INV);
        this.btnGetFolderPattern.setToolTipText(TmmResourceBundle.getString("jmteexplorer.foldername.import"));
        this.btnGetFolderPattern.addActionListener(e -> {
            this.taJmteTokens.setText(TvShowModuleManager.getInstance().getSettings().getRenamerTvShowFoldername());
            this.createRenamerExample();
        });
        this.btnSetFolderPattern = new SquareIconButton(IconManager.FILE_EXPORT_INV);
        this.btnSetFolderPattern.setToolTipText(TmmResourceBundle.getString("jmteexplorer.foldername.export"));
        this.btnSetFolderPattern.addActionListener(e -> TvShowModuleManager.getInstance().getSettings().setRenamerTvShowFoldername(this.taJmteTokens.getText()));
        this.btnGetFilePattern = new SquareIconButton(IconManager.FILE_IMPORT_INV);
        this.btnGetFilePattern.setToolTipText(TmmResourceBundle.getString("jmteexplorer.filename.import"));
        this.btnGetFilePattern.addActionListener(e -> {
            this.taJmteTokens.setText(TvShowModuleManager.getInstance().getSettings().getRenamerFilename());
            this.createRenamerExample();
        });
        this.btnSetFilePattern = new SquareIconButton(IconManager.FILE_EXPORT_INV);
        this.btnSetFilePattern.setToolTipText(TmmResourceBundle.getString("jmteexplorer.filename.export"));
        this.btnSetFilePattern.addActionListener(e -> TvShowModuleManager.getInstance().getSettings().setRenamerFilename(this.taJmteTokens.getText()));
        if (this.renamerMode) {
            panelTop.add((Component)new TmmLabel(TmmResourceBundle.getString("jmteexplorer.processmode")), "cell 0 2 2 1, gaptop 10lp");
            panelTop.add((Component)this.btnPureJmte, "cell 0 3");
            panelTop.add((Component)this.btnRenamerFoldername, "cell 0 4");
            panelTop.add((Component)this.btnGetFolderPattern, "cell 1 4, trailing");
            this.btnGetFolderPattern.setVisible(false);
            panelTop.add((Component)this.btnSetFolderPattern, "cell 1 4, trailing");
            this.btnSetFolderPattern.setVisible(false);
            panelTop.add((Component)this.btnRenamerFilename, "cell 0 5");
            panelTop.add((Component)this.btnGetFilePattern, "cell 1 5, trailing");
            this.btnGetFilePattern.setVisible(false);
            panelTop.add((Component)this.btnSetFilePattern, "cell 1 5, trailing");
            this.btnSetFilePattern.setVisible(false);
            this.btnPureJmte.addActionListener(e -> this.setImportExportButtons());
            this.btnRenamerFoldername.addActionListener(e -> this.setImportExportButtons());
            this.btnRenamerFilename.addActionListener(e -> this.setImportExportButtons());
        }
        this.btnPureJmte.setSelected(true);
        this.taError = new ReadOnlyTextArea("");
        TmmFontHelper.changeFont((JComponent)this.taError, 1);
        this.taError.setForeground(Color.RED);
        panelTop.add((Component)this.taError, "cell 0 5 2 1, grow, wmin 0");
        panelContent.add((Component)panelTop, "cell 0 0, growx");
        panelContent.add((Component)new JSeparator(), "cell 0 1, growx");
        JPanel panelBottom = new JPanel((LayoutManager)new MigLayout("", "[grow]", "[][grow]"));
        panelBottom.add((Component)new TmmLabel(TmmResourceBundle.getString("jmteexplorer.result")), "cell 0 0, grow, wmin 0");
        this.taResult = new ReadOnlyTextArea();
        panelBottom.add((Component)this.taResult, "cell 0 1, grow, wmin 0");
        panelContent.add((Component)panelBottom, "cell 0 2, grow");
        return panelContent;
    }

    private void setImportExportButtons() {
        if (this.btnPureJmte.isSelected()) {
            this.btnGetFolderPattern.setVisible(false);
            this.btnSetFolderPattern.setVisible(false);
            this.btnGetFilePattern.setVisible(false);
            this.btnSetFilePattern.setVisible(false);
        } else if (this.btnRenamerFoldername.isSelected()) {
            this.btnGetFolderPattern.setVisible(true);
            this.btnSetFolderPattern.setVisible(true);
            this.btnGetFilePattern.setVisible(false);
            this.btnSetFilePattern.setVisible(false);
        } else if (this.btnRenamerFilename.isSelected()) {
            this.btnGetFolderPattern.setVisible(false);
            this.btnSetFolderPattern.setVisible(false);
            this.btnGetFilePattern.setVisible(true);
            this.btnSetFilePattern.setVisible(true);
        }
        this.createRenamerExample();
    }

    private void setListeners() {
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                TvShowJmteExplorerDialog.this.createRenamerExample();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                TvShowJmteExplorerDialog.this.createRenamerExample();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                TvShowJmteExplorerDialog.this.createRenamerExample();
            }
        };
        this.taJmteTokens.getDocument().addDocumentListener(documentListener);
        this.cbTvShowForPreview.addActionListener(e -> {
            this.buildAndInstallEpisodeArray();
            this.updateExamples();
        });
        this.cbEpisodeForPreview.addActionListener(e -> this.updateExamples());
        this.cbEntity.addActionListener(e -> {
            Object patt31509$temp;
            Object container;
            TvShow tvShow = null;
            TvShowEpisode episode = null;
            Object patt31371$temp = this.cbTvShowForPreview.getSelectedItem();
            if (patt31371$temp instanceof TvShowPreviewContainer) {
                container = (TvShowPreviewContainer)patt31371$temp;
                tvShow = ((TvShowPreviewContainer)container).tvShow;
            }
            if ((patt31509$temp = this.cbEpisodeForPreview.getSelectedItem()) instanceof EpisodePreviewContainer) {
                container = (EpisodePreviewContainer)patt31509$temp;
                episode = ((EpisodePreviewContainer)container).episode;
            }
            this.createEntityExamples(tvShow, episode);
        });
    }

    private void updateExamples() {
        Object container;
        TvShow tvShow = null;
        TvShowEpisode episode = null;
        Object object = this.cbTvShowForPreview.getSelectedItem();
        if (object instanceof TvShowPreviewContainer) {
            container = (TvShowPreviewContainer)object;
            tvShow = ((TvShowPreviewContainer)container).tvShow;
        }
        if ((object = this.cbEpisodeForPreview.getSelectedItem()) instanceof EpisodePreviewContainer) {
            container = (EpisodePreviewContainer)object;
            episode = ((EpisodePreviewContainer)container).episode;
        }
        for (AbstractModelObject example : this.exampleEventList) {
            ((RenamerExample)example).createExample(tvShow, episode);
        }
        for (AbstractModelObject example : this.rendererExampleList) {
            ((RendererExample)example).createResult(tvShow, episode);
        }
        this.createEntityExamples(tvShow, episode);
        this.createRenamerExample();
    }

    private void createEntityExamples(TvShow tvShow, TvShowEpisode episode) {
        this.entityExampleEventList.clear();
        Object selectedItem = this.cbEntity.getSelectedItem();
        if (!(selectedItem instanceof EntityContainer)) {
            return;
        }
        EntityContainer entityContainer = (EntityContainer)selectedItem;
        if (entityContainer.clazz == null) {
            return;
        }
        this.lblEntityTemplate.setText(entityContainer.getTemplate());
        try {
            PropertyDescriptor[] pds = Introspector.getBeanInfo(entityContainer.getEntity(tvShow, episode).getClass()).getPropertyDescriptors();
            this.entityExampleEventList.clear();
            for (PropertyDescriptor descriptor : pds) {
                if ("class".equals(descriptor.getDisplayName()) || "declaringClass".equals(descriptor.getDisplayName()) || descriptor.getReadMethod() == null) continue;
                try {
                    String title;
                    switch (title = descriptor.getDisplayName()) {
                        case "episodes": 
                        case "episodesForDisplay": 
                        case "episodesToScrape": {
                            this.entityExampleEventList.add((Object)new EntityExample(title, "[TvShowEpisode, ...]"));
                            break;
                        }
                        case "seasons": {
                            this.entityExampleEventList.add((Object)new EntityExample(title, "[TvShowSeason, ...]"));
                            break;
                        }
                        case "episodesMediaFiles, seasonMediaFiles": {
                            this.entityExampleEventList.add((Object)new EntityExample(title, "[MediaFile, ...]"));
                            break;
                        }
                        case "tvShowSeason": {
                            this.entityExampleEventList.add((Object)new EntityExample(title, "TvShowSeason[...]"));
                            break;
                        }
                        case "tvShow": {
                            this.entityExampleEventList.add((Object)new EntityExample(title, "TvShow[...]"));
                            break;
                        }
                        default: {
                            this.entityExampleEventList.add((Object)new EntityExample(title, this.processPattern(tvShow, episode, entityContainer.getTemplate().replace("}", "." + title + "}"))));
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class RenamerExample
    extends AbstractModelObject {
        private static final Pattern TOKEN_PATTERN = Pattern.compile("^\\$\\{(.*?)([\\}\\[;\\.]+.*)");
        private final String token;
        private final String completeToken;
        private String longToken = "";
        private String description;
        private String example = "";

        private RenamerExample(String token) {
            this.token = token;
            this.completeToken = this.createCompleteToken();
            try {
                this.description = TmmResourceBundle.getString("Settings.tvshow.renamer." + token);
            }
            catch (Exception e) {
                this.description = "";
            }
        }

        private String createCompleteToken() {
            Object result = this.token;
            Matcher matcher = TOKEN_PATTERN.matcher(this.token);
            if (matcher.find() && matcher.groupCount() > 1) {
                String alias = matcher.group(1);
                String sourceToken = TvShowRenamer.getTokenMap().get(alias);
                if (StringUtils.isNotBlank((CharSequence)sourceToken)) {
                    result = "<html>" + this.token + "<br>${" + sourceToken + matcher.group(2) + "</html>";
                    this.longToken = "${" + sourceToken + matcher.group(2);
                }
            }
            return result;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getExample() {
            return this.example;
        }

        public void setExample(String example) {
            this.example = example;
        }

        private void createExample(TvShow tvShow, TvShowEpisode episode) {
            String oldValue = this.example;
            if (tvShow == null || episode == null) {
                this.example = "";
            } else {
                try {
                    this.example = TvShowJmteExplorerDialog.this.processPattern(tvShow, episode, this.token);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.firePropertyChange("example", oldValue, this.example);
        }
    }

    private class RendererExample
    extends AbstractModelObject {
        private final String token;
        private String result;

        RendererExample(String token) {
            this.token = token;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public void createResult(TvShow tvShow, TvShowEpisode episode) {
            String oldValue = this.result;
            if (tvShow == null || episode == null || this.token.startsWith("---")) {
                this.result = "";
            } else {
                try {
                    this.result = TvShowJmteExplorerDialog.this.processPattern(tvShow, episode, this.token);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.firePropertyChange("result", oldValue, this.result);
        }
    }

    private static class EntityExample
    extends AbstractModelObject {
        private final String title;
        private final String result;

        private EntityExample(String title, String result) {
            this.title = title;
            this.result = result;
        }
    }

    private class CopyShortRenamerTokenAction
    extends AbstractAction {
        CopyShortRenamerTokenAction() {
            this.putValue("SwingLargeIconKey", IconManager.COPY);
            this.putValue("SmallIcon", IconManager.COPY);
            this.putValue("Name", TmmResourceBundle.getString("renamer.copytoken"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("renamer.copytoken"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowJmteExplorerDialog.this.tableExamples.getSelectedRow();
            if (row > -1) {
                row = TvShowJmteExplorerDialog.this.tableExamples.convertRowIndexToModel(row);
                RenamerExample example = (RenamerExample)TvShowJmteExplorerDialog.this.exampleEventList.get(row);
                StringSelection stringSelection = new StringSelection(example.token);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        }
    }

    private class CopyLongRenamerTokenAction
    extends AbstractAction {
        CopyLongRenamerTokenAction() {
            this.putValue("SwingLargeIconKey", IconManager.COPY);
            this.putValue("SmallIcon", IconManager.COPY);
            this.putValue("Name", TmmResourceBundle.getString("renamer.copytoken.long"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("renamer.copytoken.long"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowJmteExplorerDialog.this.tableExamples.getSelectedRow();
            if (row > -1) {
                row = TvShowJmteExplorerDialog.this.tableExamples.convertRowIndexToModel(row);
                RenamerExample example = (RenamerExample)TvShowJmteExplorerDialog.this.exampleEventList.get(row);
                StringSelection stringSelection = new StringSelection(example.longToken);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        }
    }

    private static class TvShowPreviewContainer {
        TvShow tvShow;

        private TvShowPreviewContainer() {
        }

        public String toString() {
            return this.tvShow.getTitle();
        }
    }

    private static class EpisodePreviewContainer {
        TvShowEpisode episode;

        private EpisodePreviewContainer() {
        }

        public String toString() {
            return this.episode.getTitle();
        }
    }

    private static class RenamerExampleTableFormat
    extends TmmTableFormat<RenamerExample> {
        public RenamerExampleTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.token.name"), "name", token -> token.completeToken, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.token"), "description", token -> token.description, String.class);
            col.setCellRenderer(new MultilineTableCellRenderer());
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.value"), "value", token -> token.example, String.class);
            col.setCellRenderer(new MultilineTableCellRenderer());
            this.addColumn(col);
        }
    }

    private static class RendererExampleTableFormat
    extends TmmTableFormat<RendererExample> {
        public RendererExampleTableFormat() {
            TmmTableFormat.Column title = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.token.name"), "token", example -> example.token, String.class);
            this.addColumn(title);
            TmmTableFormat.Column result = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.value"), "result", example -> example.result, String.class);
            this.addColumn(result);
        }
    }

    private static class EntityContainer {
        private final Class<?> clazz;
        private final String template;
        private final Function<MediaEntity, Object> function;

        EntityContainer() {
            this.clazz = null;
            this.template = null;
            this.function = null;
        }

        EntityContainer(Class<?> clazz, String template, Function<MediaEntity, Object> function) {
            this.clazz = clazz;
            this.template = template;
            this.function = function;
        }

        public String toString() {
            if (this.clazz != null) {
                return this.clazz.getSimpleName();
            }
            return null;
        }

        public String getTemplate() {
            return this.template;
        }

        public Object getEntity(TvShow tvShow, TvShowEpisode episode) {
            if (this.function == null) {
                return null;
            }
            if (this.template.contains("{tvShow")) {
                return this.function.apply(tvShow);
            }
            if (this.template.contains("{episode")) {
                return this.function.apply(episode);
            }
            return null;
        }
    }

    private static class EntityExampleTableFormat
    extends TmmTableFormat<EntityExample> {
        private EntityExampleTableFormat() {
            TmmTableFormat.Column title = new TmmTableFormat.Column(this, TmmResourceBundle.getString("jmteexplorer.property"), "property", entityExample -> entityExample.title, String.class);
            this.addColumn(title);
            TmmTableFormat.Column result = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.value"), "result", entityExample -> entityExample.result, String.class);
            this.addColumn(result);
        }
    }
}

