/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.ui.dialogs.PostProcessDialog;
import org.tinymediamanager.ui.dialogs.SettingsDialog;

public class TvShowPostProcessDialog
extends PostProcessDialog {
    private final Type type;

    private TvShowPostProcessDialog(Type type) {
        this.type = type;
    }

    public static void showTvShowPostProcessDialog() {
        TvShowPostProcessDialog.showTvShowPostProcessDialog(null);
    }

    public static void showTvShowPostProcessDialog(PostProcess process) {
        TvShowPostProcessDialog dialog = new TvShowPostProcessDialog(Type.TV_SHOW);
        dialog.setProcess(process);
        dialog.pack();
        dialog.setLocationRelativeTo(SettingsDialog.getInstance());
        dialog.setVisible(true);
    }

    public static void showEpisodePostProcessDialog() {
        TvShowPostProcessDialog.showEpisodePostProcessDialog(null);
    }

    public static void showEpisodePostProcessDialog(PostProcess process) {
        TvShowPostProcessDialog dialog = new TvShowPostProcessDialog(Type.EPISODE);
        dialog.setProcess(process);
        dialog.pack();
        dialog.setLocationRelativeTo(SettingsDialog.getInstance());
        dialog.setVisible(true);
    }

    @Override
    protected void save() {
        if (StringUtils.isBlank((CharSequence)this.tfProcessName.getText()) || StringUtils.isBlank((CharSequence)this.tfCommand.getText()) && StringUtils.isBlank((CharSequence)this.tfPath.getText())) {
            JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("message.missingitems"));
            return;
        }
        if (this.process == null) {
            this.process = new PostProcess();
            switch (this.type) {
                case TV_SHOW: {
                    TvShowModuleManager.getInstance().getSettings().addPostProcessTvShow(this.process);
                    break;
                }
                case EPISODE: {
                    TvShowModuleManager.getInstance().getSettings().addPostProcessEpisode(this.process);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.process.setName(this.tfProcessName.getText());
        this.process.setCommand(this.tfCommand.getText());
        this.process.setPath(this.tfPath.getText());
        TvShowModuleManager.getInstance().getSettings().forceSaveSettings();
        this.firePropertyChange("postProcessTvShow", null, this.process);
        this.setVisible(false);
    }

    static enum Type {
        TV_SHOW,
        EPISODE;

    }
}

