/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowComparator;
import org.tinymediamanager.core.tvshow.TvShowRenamerPreview;
import org.tinymediamanager.core.tvshow.TvShowRenamerPreviewContainer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowRenameTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowRenamerPreviewDialog
extends TmmDialog {
    private final EventList<TvShowRenamerPreviewContainer> results;
    private final ResultSelectionModel resultSelectionModel;
    private final EventList<MediaFileContainer> oldMediaFileEventList = GlazedLists.eventList(new ArrayList());
    private final EventList<MediaFileContainer> newMediaFileEventList = GlazedLists.eventList(new ArrayList());
    private final TmmTable tableMovies;
    private final JLabel lblTitle;
    private final JLabel lblDatasource;
    private final JLabel lblFolderOld;
    private final JLabel lblFolderNew;
    private final JCheckBox cbFilter;
    private final TvShowPreviewWorker worker;

    public TvShowRenamerPreviewDialog(List<TvShow> selectedTvShows) {
        super(TmmResourceBundle.getString("movie.renamerpreview"), "tvShowRenamerPreview");
        this.results = GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()));
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[950lp,grow]", "[600lp,grow]"));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setName(this.getName() + ".splitPane");
        TmmUILayoutStore.getInstance().install(splitPane);
        splitPane.setResizeWeight(0.3);
        panelContent.add((Component)splitPane, "cell 0 0,grow");
        TmmTableModel<TvShowRenamerPreviewContainer> movieTableModel = new TmmTableModel<TvShowRenamerPreviewContainer>((EventList<TvShowRenamerPreviewContainer>)GlazedListsSwing.swingThreadProxyList(this.results), new ResultTableFormat());
        this.tableMovies = new TmmTable((TableModel)((Object)movieTableModel));
        DefaultEventSelectionModel tableSelectionModel = new DefaultEventSelectionModel(this.results);
        this.resultSelectionModel = new ResultSelectionModel();
        tableSelectionModel.addListSelectionListener((ListSelectionListener)this.resultSelectionModel);
        this.resultSelectionModel.selectedResults = tableSelectionModel.getSelected();
        this.tableMovies.setSelectionModel((ListSelectionModel)tableSelectionModel);
        movieTableModel.addTableModelListener(arg0 -> {
            ListSelectionModel selectionModel = this.tableMovies.getSelectionModel();
            if (selectionModel.isSelectionEmpty() && movieTableModel.getRowCount() > 0) {
                selectionModel.setSelectionInterval(0, 0);
            }
            if (selectionModel.isSelectionEmpty() && movieTableModel.getRowCount() == 0) {
                this.resultSelectionModel.setSelectedResult(null);
            }
        });
        JScrollPane scrollPaneMovies = new JScrollPane();
        this.tableMovies.configureScrollPane(scrollPaneMovies);
        splitPane.setLeftComponent(scrollPaneMovies);
        JPanel panelDetails = new JPanel();
        splitPane.setRightComponent(panelDetails);
        panelDetails.setLayout((LayoutManager)new MigLayout("", "[][][300lp,grow]", "[][][][][][][][grow]"));
        this.lblTitle = new JLabel("");
        TmmFontHelper.changeFont(this.lblTitle, 1.33, 1);
        panelDetails.add((Component)this.lblTitle, "cell 0 0 3 1,growx");
        TmmLabel lblDatasourceT = new TmmLabel(TmmResourceBundle.getString("metatag.datasource"));
        panelDetails.add((Component)lblDatasourceT, "cell 0 2");
        this.lblDatasource = new JLabel("");
        panelDetails.add((Component)this.lblDatasource, "cell 2 2,growx,aligny center");
        TmmLabel lblFolderOldT = new TmmLabel(TmmResourceBundle.getString("renamer.oldfolder"));
        panelDetails.add((Component)lblFolderOldT, "cell 0 4");
        this.lblFolderOld = new JLabel("");
        panelDetails.add((Component)this.lblFolderOld, "cell 2 4,growx,aligny center");
        TmmLabel lblFolderNewT = new TmmLabel(TmmResourceBundle.getString("renamer.newfolder"));
        panelDetails.add((Component)lblFolderNewT, "cell 0 5");
        this.lblFolderNew = new JLabel("");
        panelDetails.add((Component)this.lblFolderNew, "cell 2 5,growx,aligny center");
        JPanel panelMediaFiles = new JPanel();
        panelDetails.add((Component)panelMediaFiles, "cell 0 7 3 1,grow");
        panelMediaFiles.setLayout((LayoutManager)new MigLayout("", "[grow][grow]", "[15px][grow]"));
        TmmLabel lblOldfilesT = new TmmLabel(TmmResourceBundle.getString("renamer.oldfiles"));
        panelMediaFiles.add((Component)lblOldfilesT, "cell 0 0,alignx center");
        TmmLabel lblNewfilesT = new TmmLabel(TmmResourceBundle.getString("renamer.newfiles"));
        panelMediaFiles.add((Component)lblNewfilesT, "cell 1 0,alignx center");
        TmmTable tableMediaFilesOld = new TmmTable((TableModel)((Object)new TmmTableModel<MediaFileContainer>((EventList<MediaFileContainer>)GlazedListsSwing.swingThreadProxyList(this.oldMediaFileEventList), new MediaFileTableFormat())));
        JScrollPane scrollPaneMediaFilesOld = new JScrollPane();
        tableMediaFilesOld.configureScrollPane(scrollPaneMediaFilesOld);
        panelMediaFiles.add((Component)scrollPaneMediaFilesOld, "cell 0 1,grow");
        tableMediaFilesOld.getColumnModel().getColumn(0).setMaxWidth(40);
        TmmTable tableMediaFilesNew = new TmmTable((TableModel)((Object)new TmmTableModel<MediaFileContainer>((EventList<MediaFileContainer>)GlazedListsSwing.swingThreadProxyList(this.newMediaFileEventList), new MediaFileTableFormat())));
        JScrollPane scrollPaneMediaFilesNew = new JScrollPane(tableMediaFilesNew);
        tableMediaFilesNew.configureScrollPane(scrollPaneMediaFilesNew);
        panelMediaFiles.add((Component)scrollPaneMediaFilesNew, "cell 1 1,grow");
        tableMediaFilesNew.getColumnModel().getColumn(0).setMaxWidth(40);
        this.cbFilter = new JCheckBox(TmmResourceBundle.getString("renamer.hideunchanged"));
        this.cbFilter.addActionListener(l -> this.resultSelectionModel.updateSelectedResult());
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("", "[]", "[]"));
        bottomPanel.add((Component)this.cbFilter, "cell 0 0");
        this.setBottomInformationPanel(bottomPanel);
        JButton btnRename = new JButton(TmmResourceBundle.getString("Button.rename"));
        btnRename.setToolTipText(TmmResourceBundle.getString("movie.rename"));
        btnRename.addActionListener(arg0 -> {
            ArrayList<TvShow> selectedTvShows1 = new ArrayList<TvShow>();
            ArrayList<TvShowEpisode> selectedEpisodes = new ArrayList<TvShowEpisode>();
            ArrayList<TvShowRenamerPreviewContainer> selectedResults = new ArrayList<TvShowRenamerPreviewContainer>(this.resultSelectionModel.selectedResults);
            for (TvShowRenamerPreviewContainer result : selectedResults) {
                selectedTvShows1.add(result.getTvShow());
                selectedEpisodes.addAll(result.getTvShow().getEpisodes());
            }
            TvShowRenameTask renameTask = new TvShowRenameTask(selectedTvShows1, selectedEpisodes);
            TmmTaskManager.getInstance().addMainTask(renameTask);
            this.results.removeAll(selectedResults);
        });
        this.addButton(btnRename);
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
        this.worker = new TvShowPreviewWorker(selectedTvShows);
        this.worker.execute();
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        super.setVisible(visible);
    }

    private static class ResultTableFormat
    extends TmmTableFormat<TvShowRenamerPreviewContainer> {
        public ResultTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.tvshow"), "title", container -> container.getTvShow().getTitleSortable(), String.class);
            col.setCellTooltip(container -> container.getTvShow().getTitleSortable());
            this.addColumn(col);
        }
    }

    private class ResultSelectionModel
    extends AbstractModelObject
    implements ListSelectionListener {
        private final TvShowRenamerPreviewContainer emptyResult = new TvShowRenamerPreviewContainer(new TvShow());
        private TvShowRenamerPreviewContainer selectedResult;
        private List<TvShowRenamerPreviewContainer> selectedResults;

        ResultSelectionModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSelectedResult() {
            MediaFileContainer container;
            boolean found;
            TvShowRenamerPreviewDialog.this.lblTitle.setText(this.selectedResult.getTvShow().getTitleSortable());
            TvShowRenamerPreviewDialog.this.lblDatasource.setText(this.selectedResult.getTvShow().getDataSource());
            if (this.selectedResult != this.emptyResult) {
                TvShowRenamerPreviewDialog.this.lblFolderOld.setText(this.selectedResult.getOldPathRelative().toString());
                TvShowRenamerPreviewDialog.this.lblFolderNew.setText(this.selectedResult.getNewPathRelative().toString());
            } else {
                TvShowRenamerPreviewDialog.this.lblFolderOld.setText("");
                TvShowRenamerPreviewDialog.this.lblFolderNew.setText("");
            }
            try {
                TvShowRenamerPreviewDialog.this.oldMediaFileEventList.getReadWriteLock().writeLock().lock();
                TvShowRenamerPreviewDialog.this.oldMediaFileEventList.clear();
                for (MediaFile mf : this.selectedResult.getOldMediaFiles()) {
                    found = false;
                    container = new MediaFileContainer();
                    container.filename = this.selectedResult.getNewPath().relativize(mf.getFileAsPath()).toString();
                    if (this.selectedResult.getNewMediaFiles().contains(mf)) {
                        found = true;
                    }
                    if (!found) {
                        container.icon = IconManager.REMOVE;
                    }
                    if (found && TvShowRenamerPreviewDialog.this.cbFilter.isSelected()) continue;
                    TvShowRenamerPreviewDialog.this.oldMediaFileEventList.add((Object)container);
                }
            }
            catch (Exception exception) {
            }
            finally {
                TvShowRenamerPreviewDialog.this.oldMediaFileEventList.getReadWriteLock().writeLock().unlock();
            }
            try {
                TvShowRenamerPreviewDialog.this.newMediaFileEventList.getReadWriteLock().writeLock().lock();
                TvShowRenamerPreviewDialog.this.newMediaFileEventList.clear();
                for (MediaFile mf : this.selectedResult.getNewMediaFiles()) {
                    found = false;
                    container = new MediaFileContainer();
                    container.filename = this.selectedResult.getNewPath().relativize(mf.getFileAsPath()).toString();
                    if (this.selectedResult.getOldMediaFiles().contains(mf)) {
                        found = true;
                    }
                    if (!found) {
                        container.icon = IconManager.ADD;
                    }
                    if (found && TvShowRenamerPreviewDialog.this.cbFilter.isSelected()) continue;
                    TvShowRenamerPreviewDialog.this.newMediaFileEventList.add((Object)container);
                }
            }
            catch (Exception exception) {
            }
            finally {
                TvShowRenamerPreviewDialog.this.newMediaFileEventList.getReadWriteLock().writeLock().unlock();
            }
        }

        synchronized void setSelectedResult(TvShowRenamerPreviewContainer newValue) {
            this.selectedResult = newValue == null ? this.emptyResult : newValue;
            this.updateSelectedResult();
        }

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            if (arg0.getValueIsAdjusting()) {
                return;
            }
            if (!this.selectedResults.isEmpty() && this.selectedResult != this.selectedResults.get(0)) {
                this.setSelectedResult(this.selectedResults.get(0));
            }
            if (this.selectedResults.isEmpty()) {
                this.setSelectedResult(this.emptyResult);
            }
        }
    }

    private static class MediaFileTableFormat
    extends TmmTableFormat<MediaFileContainer> {
        public MediaFileTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, "", "indicator", container -> container.icon, ImageIcon.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filename"), "filename", container -> container.filename, String.class);
            col.setCellTooltip(container -> container.filename);
            this.addColumn(col);
        }
    }

    private class TvShowPreviewWorker
    extends SwingWorker<Void, Void> {
        private final List<TvShow> tvShowsToProcess;

        private TvShowPreviewWorker(List<TvShow> tvShows) {
            this.tvShowsToProcess = new ArrayList<TvShow>(tvShows);
        }

        @Override
        protected Void doInBackground() {
            this.tvShowsToProcess.sort(new TvShowComparator());
            for (TvShow tvShow : this.tvShowsToProcess) {
                if (this.isCancelled()) {
                    return null;
                }
                TvShowRenamerPreviewContainer container = new TvShowRenamerPreview(tvShow).generatePreview();
                if (!container.isNeedsRename()) continue;
                TvShowRenamerPreviewDialog.this.results.add((Object)container);
            }
            SwingUtilities.invokeLater(() -> {
                if (TvShowRenamerPreviewDialog.this.results.isEmpty()) {
                    JOptionPane.showMessageDialog(TvShowRenamerPreviewDialog.this, TmmResourceBundle.getString("movie.renamerpreview.nothingtorename"));
                    TvShowRenamerPreviewDialog.this.setVisible(false);
                }
            });
            return null;
        }
    }

    private static class MediaFileContainer {
        ImageIcon icon = null;
        String filename;

        private MediaFileContainer() {
        }
    }
}

