/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmTabbedPane;
import org.tinymediamanager.ui.dialogs.AbstractEditorDialog;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;

public class TvShowSeasonEditorDialog
extends AbstractEditorDialog {
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private static final String SPACER = "        ";
    private final TvShowSeason tvShowSeasonToEdit;
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
    private final JTabbedPane tabbedPane = new TmmTabbedPane();
    private JTextField tfTitle;
    private JTextArea taPlot;
    private JTextArea taNote;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private ImageLabel lblBanner;
    private ImageLabel lblThumb;
    private JTextField tfPoster;
    private JTextField tfFanart;
    private JTextField tfBanner;
    private JTextField tfThumb;

    public TvShowSeasonEditorDialog(TvShowSeason tvShowSeason, int queueIndex, int queueSize, int selectedTab) {
        super(TmmResourceBundle.getString("tvshowseason.edit") + (String)(queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : ""), "tvShowSeasonEditor", tvShowSeason);
        this.setMinimumSize(new Dimension(800, 600));
        this.tvShowSeasonToEdit = tvShowSeason;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.initComponents();
        this.tfTitle.setText(tvShowSeason.getTitle());
        this.taPlot.setText(tvShowSeason.getPlot());
        this.taNote.setText(tvShowSeason.getNote());
        this.lblPoster.setImagePath(tvShowSeason.getArtworkFilename(MediaFileType.SEASON_POSTER));
        this.lblFanart.setImagePath(tvShowSeason.getArtworkFilename(MediaFileType.SEASON_FANART));
        this.lblThumb.setImagePath(tvShowSeason.getArtworkFilename(MediaFileType.SEASON_THUMB));
        this.lblBanner.setImagePath(tvShowSeason.getArtworkFilename(MediaFileType.SEASON_BANNER));
        this.tfPoster.setText(tvShowSeason.getArtworkUrl(MediaFileType.SEASON_POSTER));
        this.tfFanart.setText(tvShowSeason.getArtworkUrl(MediaFileType.SEASON_FANART));
        this.tfThumb.setText(tvShowSeason.getArtworkUrl(MediaFileType.SEASON_THUMB));
        this.tfBanner.setText(tvShowSeason.getArtworkUrl(MediaFileType.SEASON_BANNER));
        this.tabbedPane.setSelectedIndex(selectedTab);
    }

    public int getSelectedTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    private void initComponents() {
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(this.tabbedPane, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JPanel detailsPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details"), null, detailsPanel, null);
        detailsPanel.setLayout((LayoutManager)new MigLayout("", "[][grow][20lp:n][200lp:250lp,grow]", "[][250lp:75%:75%,grow][75lp:20%:20%,grow]"));
        TmmLabel lblTitleT = new TmmLabel(TmmResourceBundle.getString("metatag.title"));
        detailsPanel.add((Component)lblTitleT, "flowx,cell 0 0,alignx right");
        this.tfTitle = new JTextField();
        detailsPanel.add((Component)this.tfTitle, "cell 1 0,growx");
        TmmLabel lblPlot = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        detailsPanel.add((Component)lblPlot, "cell 0 1,alignx right,aligny top");
        JScrollPane scrollPanePlot = new JScrollPane();
        detailsPanel.add((Component)scrollPanePlot, "cell 1 1,grow");
        this.taPlot = new JTextArea();
        this.taPlot.setLineWrap(true);
        this.taPlot.setWrapStyleWord(true);
        this.taPlot.setForeground(UIManager.getColor("TextField.foreground"));
        scrollPanePlot.setViewportView(this.taPlot);
        TmmLabel lblNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        detailsPanel.add((Component)lblNoteT, "cell 0 2,alignx right,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        detailsPanel.add((Component)scrollPane, "cell 1 2,grow,wmin 0");
        this.taNote = new JTextArea();
        this.taNote.setLineWrap(true);
        this.taNote.setWrapStyleWord(true);
        this.taNote.setForeground(UIManager.getColor("TextField.foreground"));
        scrollPane.setViewportView(this.taNote);
        TmmLabel lblPosterT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster"));
        detailsPanel.add((Component)lblPosterT, "flowx,cell 3 0");
        detailsPanel.add((Component)new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster")), "cell 3 0");
        LinkLabel lblPosterSize = new LinkLabel();
        detailsPanel.add((Component)lblPosterSize, "cell 3 0");
        FlatButton btnDeletePoster = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeletePoster.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeletePoster.addActionListener(e -> {
            this.lblPoster.clearImage();
            this.tfPoster.setText("");
        });
        btnDeletePoster.setFocusable(false);
        detailsPanel.add((Component)btnDeletePoster, "cell 3 0");
        this.lblPoster = new ImageLabel();
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowSeasonEditorDialog.this.openImageChooser(TvShowSeasonEditorDialog.this.lblPoster, TvShowSeasonEditorDialog.this.tfPoster, MediaFileType.getMediaArtworkType(MediaFileType.SEASON_POSTER));
            }
        });
        detailsPanel.add((Component)this.lblPoster, "cell 3 1 1 2,grow");
        this.lblPoster.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblPosterSize, this.lblPoster, btnDeletePoster, MediaFileType.SEASON_POSTER));
        JPanel artworkPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[20lp:n][300lp:400lp,grow][20lp:n][300lp:400lp,grow]", "[][100lp:125lp,grow][20lp:n][][100lp:125lp,grow][]"));
        TmmLabel lblFanartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart"));
        artworkPanel.add((Component)lblFanartT, "cell 1 0");
        LinkLabel lblFanartSize = new LinkLabel();
        artworkPanel.add((Component)lblFanartSize, "cell 1 0");
        FlatButton btnDeleteFanart = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteFanart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteFanart.addActionListener(e -> {
            this.lblFanart.clearImage();
            this.tfFanart.setText("");
        });
        artworkPanel.add((Component)btnDeleteFanart, "cell 1 0");
        this.lblFanart = new ImageLabel();
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowSeasonEditorDialog.this.openImageChooser(TvShowSeasonEditorDialog.this.lblFanart, TvShowSeasonEditorDialog.this.tfFanart, MediaFileType.getMediaArtworkType(MediaFileType.SEASON_FANART));
            }
        });
        artworkPanel.add((Component)this.lblFanart, "cell 1 1,grow");
        this.lblFanart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblFanartSize, this.lblFanart, btnDeleteFanart, MediaFileType.SEASON_FANART));
        TmmLabel lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 3 0");
        LinkLabel lblThumbSize = new LinkLabel();
        artworkPanel.add((Component)lblThumbSize, "cell 3 0");
        FlatButton btnDeleteThumb = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteThumb.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteThumb.addActionListener(e -> {
            this.lblThumb.clearImage();
            this.tfThumb.setText("");
        });
        artworkPanel.add((Component)btnDeleteThumb, "cell 3 0");
        this.lblThumb = new ImageLabel();
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowSeasonEditorDialog.this.openImageChooser(TvShowSeasonEditorDialog.this.lblThumb, TvShowSeasonEditorDialog.this.tfThumb, MediaFileType.getMediaArtworkType(MediaFileType.SEASON_THUMB));
            }
        });
        artworkPanel.add((Component)this.lblThumb, "cell 3 1,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblThumbSize, this.lblThumb, btnDeleteThumb, MediaFileType.SEASON_THUMB));
        this.lblBanner = new ImageLabel();
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowSeasonEditorDialog.this.openImageChooser(TvShowSeasonEditorDialog.this.lblBanner, TvShowSeasonEditorDialog.this.tfBanner, MediaFileType.getMediaArtworkType(MediaFileType.SEASON_BANNER));
            }
        });
        artworkPanel.add((Component)this.lblBanner, "cell 1 4 3 1,grow");
        TmmLabel lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "flowx,cell 1 3");
        LinkLabel lblBannerSize = new LinkLabel();
        artworkPanel.add((Component)lblBannerSize, "cell 1 3");
        FlatButton btnDeleteBanner = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteBanner.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteBanner.addActionListener(e -> {
            this.lblBanner.clearImage();
            this.tfBanner.setText("");
        });
        artworkPanel.add((Component)btnDeleteBanner, "cell 1 3");
        this.lblBanner.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblBannerSize, this.lblBanner, btnDeleteBanner, MediaFileType.SEASON_BANNER));
        artworkPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("edit.artwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][]"));
        lblPosterT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster"));
        artworkPanel.add((Component)lblPosterT, "cell 0 0,alignx right");
        this.tfPoster = new JTextField();
        artworkPanel.add((Component)this.tfPoster, "cell 1 0,growx");
        lblFanartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart"));
        artworkPanel.add((Component)lblFanartT, "cell 0 1,alignx right");
        this.tfFanart = new JTextField();
        artworkPanel.add((Component)this.tfFanart, "cell 1 1,growx");
        lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 2,alignx right");
        this.tfBanner = new JTextField();
        artworkPanel.add((Component)this.tfBanner, "cell 1 2,growx");
        lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 0 3,alignx right");
        this.tfThumb = new JTextField();
        artworkPanel.add((Component)this.tfThumb, "cell 1 3,growx");
        if (this.queueSize > 1) {
            JButton btnAbort = new JButton(new AbstractEditorDialog.AbortQueueAction(this, TmmResourceBundle.getString("tvshow.edit.abortqueue.desc")));
            this.addButton(btnAbort);
            if (this.queueIndex > 0) {
                JButton backButton = new JButton(new AbstractEditorDialog.NavigateBackAction(this));
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(new CancelAction());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new OKAction());
        this.getRootPane().registerKeyboardAction(new OKAction(), KeyStroke.getKeyStroke(83, 128), 2);
        this.getRootPane().registerKeyboardAction(new OKAction(), KeyStroke.getKeyStroke(10, 128), 2);
        this.addDefaultButton(okButton);
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    private void openImageChooser(ImageLabel label, JTextField textField, MediaArtwork.MediaArtworkType artworkType) {
        HashMap<String, Object> ids = new HashMap<String, Object>(this.tvShowSeasonToEdit.getTvShow().getIds());
        ids.put("tvShowSeason", this.tvShowSeasonToEdit.getSeason());
        ImageChooserDialog dialog = new ImageChooserDialog(this, ids, artworkType, this.tvShowList.getDefaultArtworkScrapers(), label, MediaType.TV_SHOW);
        if (Settings.getInstance().isImageChooserUseEntityFolder()) {
            TvShow tvShow = this.tvShowSeasonToEdit.getTvShow();
            Path seasonPath = tvShow.getPathNIO().resolve(TvShowHelpers.detectSeasonFolder(tvShow, this.tvShowSeasonToEdit.getSeason())).toAbsolutePath();
            if (!Files.exists(seasonPath, new LinkOption[0])) {
                seasonPath = tvShow.getPathNIO().toAbsolutePath();
            }
            dialog.setOpenFolderPath(seasonPath.toString());
        }
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.setVisible(true);
        this.updateArtworkUrl(label, textField);
    }

    private void processArtwork(MediaFileType type, ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{imageLabel.getImagePath(), imageLabel.getImageUrl()}) && StringUtils.isNotBlank((CharSequence)this.tvShowSeasonToEdit.getArtworkFilename(type))) {
            this.tvShowSeasonToEdit.deleteMediaFiles(type);
        }
        if (StringUtils.isNotEmpty((CharSequence)textField.getText()) && !textField.getText().equals(this.tvShowSeasonToEdit.getArtworkUrl(type))) {
            this.tvShowSeasonToEdit.setArtworkUrl(textField.getText(), type);
            TvShowArtworkHelper.downloadSeasonArtwork(this.tvShowSeasonToEdit, type);
        } else if (StringUtils.isEmpty((CharSequence)textField.getText())) {
            this.tvShowSeasonToEdit.removeArtworkUrl(type);
        } else if (StringUtils.isBlank((CharSequence)this.tvShowSeasonToEdit.getArtworkFilename(type))) {
            TvShowArtworkHelper.downloadSeasonArtwork(this.tvShowSeasonToEdit, type);
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.ok"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.change"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.commitChanges();
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.setTitle(TvShowSeasonEditorDialog.this.tfTitle.getText());
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.setPlot(TvShowSeasonEditorDialog.this.taPlot.getText());
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.setNote(TvShowSeasonEditorDialog.this.taNote.getText());
            TvShowSeasonEditorDialog.this.processArtwork(MediaFileType.SEASON_POSTER, TvShowSeasonEditorDialog.this.lblPoster, TvShowSeasonEditorDialog.this.tfPoster);
            TvShowSeasonEditorDialog.this.processArtwork(MediaFileType.SEASON_FANART, TvShowSeasonEditorDialog.this.lblFanart, TvShowSeasonEditorDialog.this.tfFanart);
            TvShowSeasonEditorDialog.this.processArtwork(MediaFileType.SEASON_BANNER, TvShowSeasonEditorDialog.this.lblBanner, TvShowSeasonEditorDialog.this.tfBanner);
            TvShowSeasonEditorDialog.this.processArtwork(MediaFileType.SEASON_THUMB, TvShowSeasonEditorDialog.this.lblThumb, TvShowSeasonEditorDialog.this.tfThumb);
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.writeNfo();
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().writeNFO();
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().saveToDb();
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }
}

