/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import java.util.regex.Matcher;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractTextTvShowUIFilter;

public class TvShowCountryFilter
extends AbstractTextTvShowUIFilter {
    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.country"));
    }

    @Override
    public String getId() {
        return "tvShowCountry";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        if (StringUtils.isBlank((CharSequence)this.normalizedFilterText)) {
            return true;
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)tvShow.getCountry())) {
                Matcher matcher = this.filterPattern.matcher(StrgUtils.normalizeString(tvShow.getCountry()));
                if (invert) {
                    return !matcher.find();
                }
                return matcher.find();
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }
}

