/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractNumberTvShowUIFilter;

public class TvShowEpisodeCountFilter
extends AbstractNumberTvShowUIFilter {
    public TvShowEpisodeCountFilter() {
        this.spinnerLow.setEditor(this.prepareNumberEditor(this.spinnerLow, "#####0"));
        this.spinnerHigh.setEditor(this.prepareNumberEditor(this.spinnerHigh, "#####0"));
    }

    @Override
    protected SpinnerNumberModel getNumberModel() {
        return new SpinnerNumberModel(0, 0, 999999, 1);
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        try {
            int count = tvShow.getEpisodes().size();
            boolean match = this.matchInt(count);
            if (invert && !match) {
                return true;
            }
            if (!invert && match) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.episode.count"));
    }

    @Override
    public String getId() {
        return "tvShowEpisodeCount";
    }
}

