/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractNumberTvShowUIFilter;

public class TvShowFanartSizeFilter
extends AbstractNumberTvShowUIFilter {
    public TvShowFanartSizeFilter() {
        this.spinnerLow.setEditor(this.prepareNumberEditor(this.spinnerLow, "####0 px"));
        this.spinnerHigh.setEditor(this.prepareNumberEditor(this.spinnerHigh, "####0 px"));
    }

    @Override
    protected SpinnerNumberModel getNumberModel() {
        return new SpinnerNumberModel(0, 0, 99999, 1);
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        try {
            boolean foundShow = this.matchInt(tvShow.getArtworkDimension((MediaFileType)MediaFileType.FANART).width);
            if (!invert && foundShow) {
                return true;
            }
            if (invert && foundShow) {
                return false;
            }
            for (TvShowEpisode episode : episodes) {
                boolean foundEpisode = this.matchInt(episode.getArtworkDimension((MediaFileType)MediaFileType.FANART).width);
                if (invert && !foundEpisode) {
                    return true;
                }
                if (!invert && foundEpisode) {
                    return true;
                }
                boolean foundSeason = this.matchInt(episode.getTvShowSeason().getArtworkDimension((MediaFileType)MediaFileType.SEASON_FANART).width);
                if (invert && !foundSeason) {
                    return true;
                }
                if (invert || !foundSeason) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("filter.fanart.width"));
    }

    @Override
    public String getId() {
        return "tvShowFanartSize";
    }
}

