/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowMissingMetadataFilter
extends AbstractCheckComboBoxTvShowUIFilter<MetadataField> {
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();

    public TvShowMissingMetadataFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        ArrayList<MetadataField> values = new ArrayList<MetadataField>();
        for (TvShowScraperMetadataConfig config : TvShowScraperMetadataConfig.values()) {
            if (!config.isMetaData() && !config.isCast()) continue;
            values.add(new MetadataField(config));
        }
        this.setValues(values);
    }

    @Override
    public String getId() {
        return "tvShowMissingMetadata";
    }

    @Override
    protected String parseTypeToString(MetadataField type) throws Exception {
        return type.config.name();
    }

    @Override
    protected MetadataField parseStringToType(String string) throws Exception {
        try {
            return new MetadataField(TvShowScraperMetadataConfig.valueOf(string));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        ArrayList<TvShowScraperMetadataConfig> tvShowValues = new ArrayList<TvShowScraperMetadataConfig>();
        ArrayList<TvShowEpisodeScraperMetadataConfig> episodeValues = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        for (MetadataField metadataField : this.checkComboBox.getSelectedItems()) {
            tvShowValues.add(metadataField.config);
            switch (metadataField.config) {
                case TITLE: {
                    episodeValues.add(TvShowEpisodeScraperMetadataConfig.TITLE);
                    break;
                }
                case ORIGINAL_TITLE: {
                    episodeValues.add(TvShowEpisodeScraperMetadataConfig.ORIGINAL_TITLE);
                    break;
                }
                case PLOT: {
                    episodeValues.add(TvShowEpisodeScraperMetadataConfig.PLOT);
                    break;
                }
                case AIRED: {
                    episodeValues.add(TvShowEpisodeScraperMetadataConfig.AIRED);
                    break;
                }
                case RATING: {
                    episodeValues.add(TvShowEpisodeScraperMetadataConfig.RATING);
                    break;
                }
                case TAGS: {
                    episodeValues.add(TvShowEpisodeScraperMetadataConfig.TAGS);
                    break;
                }
                case ACTORS: {
                    episodeValues.add(TvShowEpisodeScraperMetadataConfig.ACTORS);
                }
            }
        }
        if (invert ^ !this.tvShowList.detectMissingFields(tvShow, tvShowValues).isEmpty()) {
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            if (episode.isDummy() || !(invert ^ !this.tvShowList.detectMissingFields(episode, episodeValues).isEmpty())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.missingmetadata"));
    }

    public static class MetadataField {
        private final TvShowScraperMetadataConfig config;

        public MetadataField(TvShowScraperMetadataConfig config) {
            this.config = config;
        }

        public String toString() {
            return this.config.getDescription();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetadataField that = (MetadataField)o;
            return this.config == that.config;
        }

        public int hashCode() {
            return Objects.hash(this.config);
        }
    }
}

