/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import java.util.regex.Matcher;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractTextTvShowUIFilter;

public class TvShowNoteFilter
extends AbstractTextTvShowUIFilter {
    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.note"));
    }

    @Override
    public String getId() {
        return "TvShowNote";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        if (StringUtils.isBlank((CharSequence)this.normalizedFilterText)) {
            return true;
        }
        try {
            for (TvShowEpisode episode : episodes) {
                boolean foundEpisode = false;
                Matcher matcher = this.filterPattern.matcher(StrgUtils.normalizeString(episode.getNote()));
                if (matcher.find()) {
                    foundEpisode = true;
                }
                if (invert && !foundEpisode) {
                    return true;
                }
                if (invert || !foundEpisode) continue;
                return true;
            }
            boolean foundShow = false;
            Matcher matcher = this.filterPattern.matcher(StrgUtils.normalizeString(tvShow.getNote()));
            if (matcher.find()) {
                foundShow = true;
            }
            if (!invert && foundShow) {
                return true;
            }
            if (invert && foundShow) {
                return false;
            }
            for (TvShowSeason season : tvShow.getSeasons()) {
                boolean foundSeason = false;
                matcher = this.filterPattern.matcher(StrgUtils.normalizeString(season.getNote()));
                if (matcher.find()) {
                    foundSeason = true;
                }
                if (invert && !foundSeason) {
                    return true;
                }
                if (invert || !foundSeason) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }
}

