/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractNumberTvShowUIFilter;

public class TvShowVideoBitdepthFilter
extends AbstractNumberTvShowUIFilter {
    public TvShowVideoBitdepthFilter() {
        this.spinnerLow.setEditor(this.prepareNumberEditor(this.spinnerLow, "#0 bit"));
        this.spinnerHigh.setEditor(this.prepareNumberEditor(this.spinnerHigh, "#0 bit"));
    }

    @Override
    protected SpinnerNumberModel getNumberModel() {
        return new SpinnerNumberModel(0, 0, 99, 1);
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        try {
            for (TvShowEpisode episode : episodes) {
                boolean foundEpisode = this.matchInt(episode.getMainVideoFile().getBitDepth());
                if (invert && !foundEpisode) {
                    return true;
                }
                if (invert || !foundEpisode) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.bitdepth"));
    }

    @Override
    public String getId() {
        return "tvShowVideoBitdepth";
    }
}

