/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractNumberTvShowUIFilter;

public class TvShowVideoFilesizeFilter
extends AbstractNumberTvShowUIFilter {
    public TvShowVideoFilesizeFilter() {
        this.spinnerLow.setEditor(this.prepareNumberEditor(this.spinnerLow, "#####0 M"));
        this.spinnerHigh.setEditor(this.prepareNumberEditor(this.spinnerHigh, "#####0 M"));
    }

    @Override
    protected SpinnerNumberModel getNumberModel() {
        return new SpinnerNumberModel(0, 0, 999999, 1);
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        try {
            for (TvShowEpisode episode : episodes) {
                boolean foundEpisode = this.matchInt((int)((float)episode.getVideoFilesize() / 1000000.0f));
                if (invert && !foundEpisode) {
                    return true;
                }
                if (invert || !foundEpisode) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.filesize"));
    }

    @Override
    public String getId() {
        return "tvShowVideoFilesize";
    }
}

