/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.episode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.LinkTextArea;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.ReadOnlyTextPaneHTML;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.converter.ZeroIdConverter;
import org.tinymediamanager.ui.panels.InformationPanel;
import org.tinymediamanager.ui.panels.MediaInformationLogosPanel;
import org.tinymediamanager.ui.panels.RatingPanel;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;

public class TvShowEpisodeInformationPanel
extends InformationPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeInformationPanel.class);
    private static final String LAYOUT_ARTWORK_VISIBLE = "[n:100lp:20%, grow][300lp:300lp,grow 350]";
    private static final String LAYOUT_ARTWORK_HIDDEN = "[][300lp:300lp,grow 350]";
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final TvShowEpisodeSelectionModel tvShowEpisodeSelectionModel;
    private JLabel lblTvShowName;
    private JLabel lblEpisodeTitle;
    private JTextPane taOverview;
    private MediaInformationLogosPanel panelLogos;
    private JSeparator sepLogos;
    private JLabel lblOriginalTitle;
    private JButton btnPlay;
    private JScrollPane scrollPane;
    private JLabel lblSeason;
    private JLabel lblEpisode;
    private JLabel lblAired;
    private JTextPane taTags;
    private LinkTextArea lblPath;
    private JTextPane taNote;
    private LinkLabel lblTraktTvId;
    private LinkLabel lblTvdbId;
    private LinkLabel lblImdbId;
    private LinkLabel lblTmdbId;
    private JTextPane taOtherIds;
    private RatingPanel ratingPanel;
    private JLabel lblEditionT;
    private JLabel lblEdition;

    public TvShowEpisodeInformationPanel(TvShowEpisodeSelectionModel tvShowEpisodeSelectionModel) {
        this.tvShowEpisodeSelectionModel = tvShowEpisodeSelectionModel;
        this.initComponents();
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != TvShowEpisodeSelectionModel.class) {
                return;
            }
            TvShowEpisodeSelectionModel model = (TvShowEpisodeSelectionModel)source;
            TvShowEpisode episode = model.getSelectedTvShowEpisode();
            if ("selectedTvShowEpisode".equals(property) || "poster".equals(property) || "seasonPoster".equals(property)) {
                this.setSeasonPoster(episode);
            }
            if ("selectedTvShowEpisode".equals(property) || "thumb".equals(property)) {
                this.setArtwork(episode, MediaFileType.THUMB);
            }
            if ("selectedTvShowEpisode".equals(property) || "mediaFiles".equals(property) || "mediaInformation".equals(property)) {
                this.panelLogos.setMediaInformationSource(episode);
            }
            if ("selectedTvShowEpisode".equals(property) || "rating".equals(property)) {
                this.setRating(episode);
            }
            if ("selectedTvShowEpisode".equals(property)) {
                SwingUtilities.invokeLater(() -> this.scrollPane.getVerticalScrollBar().setValue(0));
            }
        };
        this.tvShowEpisodeSelectionModel.addPropertyChangeListener(propertyChangeListener);
        this.btnPlay.addActionListener(e -> {
            MediaFile mf = this.tvShowEpisodeSelectionModel.getSelectedTvShowEpisode().getMainVideoFile();
            if (StringUtils.isNotBlank((CharSequence)mf.getFilename())) {
                try {
                    TmmUIHelper.openFile(MediaFileHelper.getMainVideoFile(mf));
                }
                catch (Exception ex) {
                    LOGGER.error("open file - '{}'", (Object)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
        this.lblPath.addActionListener(arg0 -> {
            if (!StringUtils.isEmpty((CharSequence)this.lblPath.getText())) {
                Path path = Paths.get(this.lblPath.getText(), new String[0]);
                TmmUIHelper.openFolder(path);
            }
        });
        this.lblTraktTvId.addActionListener(arg0 -> {
            Object url = "";
            int epId = tvShowEpisodeSelectionModel.getSelectedTvShowEpisode().getTraktTvId();
            if (epId > 0) {
                url = "https://trakt.tv//search/trakt/" + epId + "?id_type=episode";
            } else {
                int tvShowId = tvShowEpisodeSelectionModel.getSelectedTvShowEpisode().getTvShow().getTraktId();
                int seasonId = tvShowEpisodeSelectionModel.getSelectedTvShowEpisode().getAiredSeason();
                int episodeId = tvShowEpisodeSelectionModel.getSelectedTvShowEpisode().getAiredEpisode();
                url = "https://trakt.tv/shows/" + tvShowId + "/seasons/" + seasonId + "/episodes/" + episodeId;
            }
            try {
                TmmUIHelper.browseUrl((String)url);
            }
            catch (Exception e) {
                LOGGER.error("browse to trakt.tv episode", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblImdbId.addActionListener(arg0 -> {
            String url = "https://www.imdb.com/title/" + this.lblImdbId.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to imdbid", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblTvdbId.addActionListener(arg0 -> {
            String showId = tvShowEpisodeSelectionModel.getSelectedTvShowEpisode().getTvShow().getTvdbId();
            String url = "https://thetvdb.com/?tab=series&id=" + showId + "&tab=episode&id=" + this.lblTvdbId.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to thetvdb", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblTmdbId.addActionListener(arg0 -> {
            int tvShowId = tvShowEpisodeSelectionModel.getSelectedTvShowEpisode().getTvShow().getTmdbId();
            int seasonId = tvShowEpisodeSelectionModel.getSelectedTvShowEpisode().getAiredSeason();
            int episodeId = tvShowEpisodeSelectionModel.getSelectedTvShowEpisode().getAiredEpisode();
            String url = "https://www.themoviedb.org/tv/" + tvShowId + "/season/" + seasonId + "/episode/" + episodeId;
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to TMDB", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", LAYOUT_ARTWORK_VISIBLE, "[][grow]"));
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new ColumnLayout());
        this.add((Component)panelLeft, "cell 0 0 1 2,grow");
        for (Component component : this.generateArtworkComponents(MediaFileType.SEASON_POSTER)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.THUMB)) {
            panelLeft.add(component);
        }
        JPanel panelTitle = new JPanel();
        this.add((Component)panelTitle, "cell 1 0,growx");
        panelTitle.setLayout((LayoutManager)new MigLayout("insets 0 0 n n", "[grow][]", "[][][][shrink 0]"));
        this.lblTvShowName = new TmmLabel("", 1.33);
        panelTitle.add((Component)this.lblTvShowName, "flowx,cell 0 0,growx,wmin 0");
        this.btnPlay = new FlatButton(IconManager.PLAY_LARGE);
        panelTitle.add((Component)this.btnPlay, "cell 1 0 1 4,aligny top");
        this.lblEpisodeTitle = new TmmLabel("", 1.16);
        panelTitle.add((Component)this.lblEpisodeTitle, "cell 0 1,growx,wmin 0");
        this.lblOriginalTitle = new JLabel("");
        panelTitle.add((Component)this.lblOriginalTitle, "cell 0 2,growx,wmin 0");
        panelTitle.add((Component)new JSeparator(), "cell 0 3 2 1,growx");
        JPanel panelRight = new JPanel();
        panelRight.setLayout((LayoutManager)new MigLayout("insets 0 0 n n, hidemode 2", "[100lp,grow]", "[][shrink 0][][shrink 0][][shrink 0][][][][]"));
        this.scrollPane = new NoBorderScrollPane(panelRight);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(8);
        this.add((Component)this.scrollPane, "cell 1 1,grow, wmin 0");
        JPanel panelTopDetails = new JPanel();
        panelTopDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][][40lp!][][]", "[]2lp[][][][]"));
        panelRight.add((Component)panelTopDetails, "cell 0 0,grow");
        JLabel lblSeasonT = new JLabel(TmmResourceBundle.getString("metatag.season"));
        TmmFontHelper.changeFont(lblSeasonT, 1.166, 1);
        panelTopDetails.add((Component)lblSeasonT, "cell 0 0");
        this.lblSeason = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblSeason, 1.166);
        panelTopDetails.add((Component)this.lblSeason, "cell 1 0");
        JLabel lblEpisodeT = new JLabel(TmmResourceBundle.getString("metatag.episode"));
        TmmFontHelper.changeFont(lblEpisodeT, 1.166, 1);
        panelTopDetails.add((Component)lblEpisodeT, "cell 0 1");
        this.lblEpisode = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblEpisode, 1.166);
        panelTopDetails.add((Component)this.lblEpisode, "cell 1 1");
        TmmLabel lblAiredT = new TmmLabel(TmmResourceBundle.getString("metatag.aired"));
        panelTopDetails.add((Component)lblAiredT, "cell 0 2");
        this.lblAired = new JLabel("");
        panelTopDetails.add((Component)this.lblAired, "cell 1 2");
        TmmLabel lblImdbIdT = new TmmLabel("IMDB ID");
        panelTopDetails.add((Component)lblImdbIdT, "cell 3 0");
        this.lblImdbId = new LinkLabel();
        panelTopDetails.add((Component)this.lblImdbId, "cell 4 0");
        TmmLabel lblTvdbIdT = new TmmLabel("TheTVDB ID");
        panelTopDetails.add((Component)lblTvdbIdT, "cell 3 1");
        this.lblTvdbId = new LinkLabel();
        panelTopDetails.add((Component)this.lblTvdbId, "cell 4 1");
        TmmLabel lblTraktTvIdT = new TmmLabel("Trakt.tv ID");
        panelTopDetails.add((Component)lblTraktTvIdT, "cell 3 2");
        this.lblTraktTvId = new LinkLabel();
        panelTopDetails.add((Component)this.lblTraktTvId, "cell 4 2");
        TmmLabel lblTmdbIdT = new TmmLabel("TMDB ID");
        panelTopDetails.add((Component)lblTmdbIdT, "cell 3 3");
        this.lblTmdbId = new LinkLabel();
        panelTopDetails.add((Component)this.lblTmdbId, "cell 4 3");
        TmmLabel lblOtherIdsT = new TmmLabel(TmmResourceBundle.getString("metatag.otherids"));
        panelTopDetails.add((Component)lblOtherIdsT, "cell 3 4");
        this.taOtherIds = new ReadOnlyTextPane();
        panelTopDetails.add((Component)this.taOtherIds, "cell 4 4 2 1,growx,wmin 0");
        panelRight.add((Component)new JSeparator(), "cell 0 1,growx");
        this.ratingPanel = new RatingPanel();
        panelRight.add((Component)this.ratingPanel, "flowx,cell 0 2,aligny center");
        this.sepLogos = new JSeparator();
        panelRight.add((Component)this.sepLogos, "cell 0 3,growx");
        this.panelLogos = new MediaInformationLogosPanel();
        panelRight.add((Component)this.panelLogos, "cell 0 4,growx");
        panelRight.add((Component)new JSeparator(), "cell 0 5,growx");
        TmmLabel lblPlot = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        panelRight.add((Component)lblPlot, "cell 0 6");
        this.taOverview = new ReadOnlyTextPaneHTML();
        panelRight.add((Component)this.taOverview, "cell 0 7,growx,wmin 0,aligny top");
        panelRight.add((Component)new JSeparator(), "cell 0 8,growx");
        JPanel panelBottomDetails = new JPanel();
        panelRight.add((Component)panelBottomDetails, "cell 0 9,grow");
        panelBottomDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][10lp][200lp,grow]", "[]2lp[]2lp[]2lp[]"));
        this.lblEditionT = new TmmLabel(TmmResourceBundle.getString("metatag.edition"));
        panelBottomDetails.add((Component)this.lblEditionT, "cell 0 0");
        this.lblEdition = new JLabel("");
        panelBottomDetails.add((Component)this.lblEdition, "cell 2 0");
        TmmLabel lblTagsT = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        panelBottomDetails.add((Component)lblTagsT, "cell 0 1");
        this.taTags = new ReadOnlyTextPane();
        panelBottomDetails.add((Component)this.taTags, "cell 2 1,growx,wmin 0");
        TmmLabel lblPathT = new TmmLabel(TmmResourceBundle.getString("metatag.path"));
        panelBottomDetails.add((Component)lblPathT, "cell 0 2");
        this.lblPath = new LinkTextArea("");
        panelBottomDetails.add((Component)this.lblPath, "cell 2 2,growx,wmin 0");
        TmmLabel lblNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        panelBottomDetails.add((Component)lblNoteT, "cell 0 3");
        this.taNote = new ReadOnlyTextPaneHTML();
        panelBottomDetails.add((Component)this.taNote, "cell 2 3,growx,wmin 0");
    }

    private void setSeasonPoster(TvShowEpisode episode) {
        String posterPath = episode.getTvShowSeason().getArtworkFilename(MediaFileType.SEASON_POSTER);
        Dimension posterSize = episode.getTvShowSeason().getArtworkDimension(MediaFileType.SEASON_POSTER);
        if (StringUtils.isBlank((CharSequence)posterPath) && TvShowModuleManager.getInstance().getSettings().isSeasonArtworkFallback()) {
            posterPath = episode.getTvShowSeason().getTvShow().getArtworkFilename(MediaFileType.POSTER);
            posterSize = episode.getTvShowSeason().getTvShow().getArtworkDimension(MediaFileType.POSTER);
        }
        this.setArtwork(MediaFileType.SEASON_POSTER, posterPath, posterSize);
    }

    private void setArtwork(MediaFileType type, String artworkPath, Dimension artworkDimension) {
        List components = (List)this.artworkComponents.get((Object)type);
        if (ListUtils.isEmpty(components)) {
            return;
        }
        boolean visible = this.getShowArtworkFromSettings().contains((Object)type);
        for (Component component : components) {
            component.setVisible(visible);
            if (component instanceof ImageLabel) {
                ImageLabel imageLabel = (ImageLabel)component;
                imageLabel.clearImage();
                imageLabel.setImagePath(artworkPath);
                continue;
            }
            if (!(component instanceof JLabel)) continue;
            JLabel sizeLabel = (JLabel)component;
            if (artworkDimension.width > 0 && artworkDimension.height > 0) {
                sizeLabel.setText(TmmResourceBundle.getString("mediafiletype." + type.name().toLowerCase(Locale.ROOT)) + " - " + artworkDimension.width + "x" + artworkDimension.height);
                continue;
            }
            sizeLabel.setText(TmmResourceBundle.getString("mediafiletype." + type.name().toLowerCase(Locale.ROOT)));
        }
        this.updateArtwork();
    }

    @Override
    protected List<MediaFileType> getShowArtworkFromSettings() {
        return TvShowModuleManager.getInstance().getSettings().getShowEpisodeArtworkTypes();
    }

    @Override
    protected void setColumnLayout(boolean artworkVisible) {
        if (artworkVisible) {
            ((MigLayout)this.getLayout()).setColumnConstraints((Object)LAYOUT_ARTWORK_VISIBLE);
        } else {
            ((MigLayout)this.getLayout()).setColumnConstraints((Object)LAYOUT_ARTWORK_HIDDEN);
        }
    }

    private void setRating(TvShowEpisode episode) {
        HashMap<String, MediaRating> ratings = new HashMap<String, MediaRating>(episode.getRatings());
        MediaRating customRating = episode.getRating();
        if (customRating != MediaMetadata.EMPTY_RATING) {
            ratings.put("custom", customRating);
        }
        this.ratingPanel.setRatings(ratings);
    }

    protected void initDataBindings() {
        BeanProperty tvShowEpisodeSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowEpisode.tvShow.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty, (Object)this.lblTvShowName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowEpisode.titleForUi");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_1, (Object)this.lblEpisodeTitle, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShowEpisode.plot");
        BeanProperty JTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_3, (Object)this.taOverview, (Property)JTextPaneBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShowEpisode.originalTitle");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_2, (Object)this.lblOriginalTitle, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"showLogosPanel");
        BeanProperty jSeparatorBeanProperty = BeanProperty.create((String)"visible");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.sepLogos, (Property)jSeparatorBeanProperty);
        autoBinding_7.bind();
        BeanProperty mediaInformationLogosPanelBeanProperty = BeanProperty.create((String)"visible");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.panelLogos, (Property)mediaInformationLogosPanelBeanProperty);
        autoBinding_8.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_7 = BeanProperty.create((String)"selectedTvShowEpisode.season");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_7, (Object)this.lblSeason, (Property)jLabelBeanProperty);
        autoBinding_9.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_8 = BeanProperty.create((String)"selectedTvShowEpisode.episode");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_8, (Object)this.lblEpisode, (Property)jLabelBeanProperty);
        autoBinding_10.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_9 = BeanProperty.create((String)"selectedTvShowEpisode.firstAiredAsString");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_9, (Object)this.lblAired, (Property)jLabelBeanProperty);
        autoBinding_11.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_10 = BeanProperty.create((String)"selectedTvShowEpisode.tagsAsString");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_10, (Object)this.taTags, (Property)JTextPaneBeanProperty);
        autoBinding_12.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_11 = BeanProperty.create((String)"selectedTvShowEpisode.path");
        BeanProperty linkTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_11, (Object)this.lblPath, (Property)linkTextAreaBeanProperty);
        autoBinding_13.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_12 = BeanProperty.create((String)"selectedTvShowEpisode.note");
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_12, (Object)this.taNote, (Property)JTextPaneBeanProperty);
        autoBinding_14.bind();
        BeanProperty tvShowSelectionModelBeanProperty_13 = BeanProperty.create((String)"selectedTvShowEpisode.traktTvId");
        BeanProperty linkLabelBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowSelectionModelBeanProperty_13, (Object)this.lblTraktTvId, (Property)linkLabelBeanProperty_2);
        autoBinding_15.setConverter((Converter)new ZeroIdConverter());
        autoBinding_15.bind();
        BeanProperty tvShowSelectionModelBeanProperty_14 = BeanProperty.create((String)"selectedTvShowEpisode.imdbId");
        BeanProperty linkLabelBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_16 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowSelectionModelBeanProperty_14, (Object)this.lblImdbId, (Property)linkLabelBeanProperty_3);
        autoBinding_16.bind();
        BeanProperty tvShowSelectionModelBeanProperty_15 = BeanProperty.create((String)"selectedTvShowEpisode.tvdbId");
        BeanProperty linkLabelBeanProperty_4 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_17 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowSelectionModelBeanProperty_15, (Object)this.lblTvdbId, (Property)linkLabelBeanProperty_4);
        autoBinding_17.bind();
        BeanProperty tvShowSelectionModelBeanProperty_16 = BeanProperty.create((String)"selectedTvShowEpisode.tmdbId");
        BeanProperty linkLabelBeanProperty_5 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_18 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowSelectionModelBeanProperty_16, (Object)this.lblTmdbId, (Property)linkLabelBeanProperty_5);
        autoBinding_18.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_17 = BeanProperty.create((String)"selectedTvShowEpisode.otherIds");
        AutoBinding autoBinding_19 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_17, (Object)this.taOtherIds, (Property)JTextPaneBeanProperty);
        autoBinding_19.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedTvShowEpisode.edition.title");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_4, (Object)this.lblEdition, (Property)jLabelBeanProperty);
        autoBinding_4.bind();
    }
}

