/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.episode;

import java.beans.PropertyChangeListener;
import java.util.List;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.panels.MediaInformationPanel;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;

public class TvShowEpisodeMediaInformationPanel
extends MediaInformationPanel {
    private final TvShowEpisodeSelectionModel selectionModel;

    public TvShowEpisodeMediaInformationPanel(TvShowEpisodeSelectionModel model) {
        this.panelMediaFiles.installTmmUILayoutStore("tvshows.episode");
        this.selectionModel = model;
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != TvShowEpisodeSelectionModel.class) {
                return;
            }
            if ("selectedTvShowEpisode".equals(property) || "mediaInformation".equals(property) || "mediaFiles".equals(property) || "mediaSource".equals(property)) {
                this.fillVideoStreamDetails();
                this.buildAudioStreamDetails();
                this.buildSubtitleStreamDetails();
                try {
                    this.mediaFileEventList.getReadWriteLock().writeLock().lock();
                    this.mediaFileEventList.clear();
                    this.mediaFileEventList.addAll(this.selectionModel.getSelectedTvShowEpisode().getMediaFiles());
                }
                catch (Exception exception) {
                }
                finally {
                    this.mediaFileEventList.getReadWriteLock().writeLock().unlock();
                }
                this.panelMediaFiles.adjustColumns();
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
        this.initDataBindings();
    }

    @Override
    protected void fillVideoStreamDetails() {
        TvShowEpisode tvShowEpisode = this.selectionModel.getSelectedTvShowEpisode();
        List<MediaFile> mediaFiles = tvShowEpisode.getMediaFiles(MediaFileType.VIDEO);
        if (mediaFiles.isEmpty()) {
            return;
        }
        MediaFile mediaFile = tvShowEpisode.getMainVideoFile();
        int runtime = 0;
        for (MediaFile mf : mediaFiles) {
            runtime += mf.getDuration();
        }
        if (runtime == 0) {
            this.lblRuntime.setText("");
        } else {
            int minutes = runtime / 60 % 60;
            int hours = runtime / 3600 % 24;
            int seconds = runtime % 60;
            this.lblRuntime.setText(String.format("%dh %02dm %02ds", hours, minutes, seconds));
        }
        this.chckbxWatched.setSelected(tvShowEpisode.isWatched());
        this.lblVideoCodec.setText(mediaFile.getVideoCodec());
        if (mediaFile.getAspectRatio().floatValue() > 0.0f) {
            this.lblVideoResolution.setText(String.format("%s (%.2f:1)", mediaFile.getVideoResolution(), mediaFile.getAspectRatio()));
        } else {
            this.lblVideoResolution.setText(mediaFile.getVideoResolution());
        }
        this.lblVideoBitrate.setText(mediaFile.getVideoBitRateInKbps());
        this.lblVideoBitDepth.setText(mediaFile.getBitDepthString());
        this.lblSource.setText(tvShowEpisode.getMediaSource().toString());
        this.lblFrameRate.setText(String.format("%.2f fps", mediaFile.getFrameRate()));
        this.lblOriginalFilename.setText(tvShowEpisode.getOriginalFilename());
        this.lblHdrFormat.setText(mediaFile.getHdrFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void buildAudioStreamDetails() {
        try {
            this.audioStreamEventList.getReadWriteLock().writeLock().lock();
            this.audioStreamEventList.clear();
            TvShowEpisode tvShowEpisode = this.selectionModel.getSelectedTvShowEpisode();
            List<MediaFile> mediaFiles = tvShowEpisode.getMediaFilesContainingAudioStreams();
            for (MediaFile mediaFile : mediaFiles) {
                for (int i = 0; i < mediaFile.getAudioStreams().size(); ++i) {
                    MediaFileAudioStream audioStream = mediaFile.getAudioStreams().get(i);
                    MediaInformationPanel.AudioStreamContainer container = new MediaInformationPanel.AudioStreamContainer();
                    container.audioStream = audioStream;
                    container.source = mediaFile.getType() == MediaFileType.VIDEO ? TmmResourceBundle.getString("metatag.internal") : TmmResourceBundle.getString("metatag.external");
                    this.audioStreamEventList.add((Object)container);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.audioStreamEventList.getReadWriteLock().writeLock().unlock();
            this.tableAudioStreams.adjustColumnPreferredWidths(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void buildSubtitleStreamDetails() {
        try {
            this.subtitleEventList.getReadWriteLock().writeLock().lock();
            this.subtitleEventList.clear();
            TvShowEpisode tvShowEpisode = this.selectionModel.getSelectedTvShowEpisode();
            List<MediaFile> mediaFiles = tvShowEpisode.getMediaFilesContainingSubtitles();
            for (MediaFile mediaFile : mediaFiles) {
                for (int i = 0; i < mediaFile.getSubtitles().size(); ++i) {
                    MediaFileSubtitle subtitle = mediaFile.getSubtitles().get(i);
                    MediaInformationPanel.SubtitleContainer container = new MediaInformationPanel.SubtitleContainer();
                    container.subtitle = subtitle;
                    container.source = mediaFile.getType() == MediaFileType.VIDEO ? TmmResourceBundle.getString("metatag.internal") : TmmResourceBundle.getString("metatag.external");
                    this.subtitleEventList.add((Object)container);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.subtitleEventList.getReadWriteLock().writeLock().unlock();
            this.tableSubtitles.adjustColumnPreferredWidths(6);
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowEpisodeSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowEpisode.path");
        BeanProperty linkTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty, (Object)this.lblPath, (Property)linkTextAreaBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowEpisode.dateAddedAsString");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_1, (Object)this.lblDateAdded, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShowEpisode.watched");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_2, (Object)this.chckbxWatched, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShowEpisode.originalFilename");
        BeanProperty jLabelBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_3, (Object)this.lblOriginalFilename, (Property)jLabelBeanProperty_1);
        autoBinding_3.bind();
    }
}

