/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.season;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.panels.InformationPanel;
import org.tinymediamanager.ui.tvshows.TvShowSeasonSelectionModel;

public class TvShowSeasonInformationPanel
extends InformationPanel {
    private static final String LAYOUT_ARTWORK_VISIBLE = "[n:100lp:20%, grow][300lp:300lp,grow 350]";
    private static final String LAYOUT_ARTWORK_HIDDEN = "[][300lp:300lp,grow 350]";
    private Color defaultColor;
    private Color dummyColor;
    private final EventList<TvShowEpisode> episodeEventList;
    private final TmmTableModel<TvShowEpisode> episodeTableModel;
    private final TvShowSeasonSelectionModel tvShowSeasonSelectionModel;
    private JLabel lblTvshowTitle;
    private JLabel lblSeason;
    private JTextPane taOverview;
    private TmmTable tableEpisodes;

    public TvShowSeasonInformationPanel(TvShowSeasonSelectionModel tvShowSeasonSelectionModel) {
        this.tvShowSeasonSelectionModel = tvShowSeasonSelectionModel;
        this.episodeEventList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(TvShowEpisode.class));
        this.episodeTableModel = new TmmTableModel<TvShowEpisode>((EventList<TvShowEpisode>)GlazedListsSwing.swingThreadProxyList(this.episodeEventList), new EpisodeTableFormat());
        this.initComponents();
        this.initDataBindings();
        this.tableEpisodes.setDefaultRenderer(String.class, new EpisodeTableCellRenderer());
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != TvShowSeasonSelectionModel.class) {
                return;
            }
            TvShowSeasonSelectionModel model = (TvShowSeasonSelectionModel)source;
            TvShowSeason selectedSeason = model.getSelectedTvShowSeason();
            if ("selectedTvShowSeason".equals(property) || "season".equals(property) || "title".equals(property)) {
                if (StringUtils.isNotBlank((CharSequence)selectedSeason.getTitle())) {
                    this.lblSeason.setText(selectedSeason.getTitle() + " (" + TmmResourceBundle.getString("metatag.season") + " " + selectedSeason.getSeason() + ")");
                } else {
                    this.lblSeason.setText(TmmResourceBundle.getString("metatag.season") + " " + selectedSeason.getSeason());
                }
            }
            if ("selectedTvShowSeason".equals(property) || "poster".equals(property) || "seasonPoster".equals(property)) {
                this.setPoster(selectedSeason);
            }
            if ("selectedTvShowSeason".equals(property) || "fanart".equals(property) || "seasonFanart".equals(property)) {
                this.setFanart(selectedSeason);
            }
            if ("selectedTvShowSeason".equals(property) || "banner".equals(property) || "seasonBanner".equals(property)) {
                this.setBanner(selectedSeason);
            }
            if ("selectedTvShowSeason".equals(property) || "thumb".equals(property) || "seasonThumb".equals(property)) {
                this.setThumb(selectedSeason);
            }
            if ("selectedTvShowSeason".equals(property) || "mediaFiles".equals(property) || "addedEpisode".equals(property) || "removedEpisode".equals(property)) {
                try {
                    this.episodeEventList.getReadWriteLock().writeLock().lock();
                    this.episodeEventList.clear();
                    this.episodeEventList.addAll(selectedSeason.getEpisodesForDisplay());
                }
                catch (Exception exception) {
                }
                finally {
                    this.episodeEventList.getReadWriteLock().writeLock().unlock();
                    this.tableEpisodes.adjustColumnPreferredWidths(6);
                }
            }
        };
        tvShowSeasonSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.defaultColor = UIManager.getColor("Table.foreground");
        this.dummyColor = UIManager.getColor("Component.linkColor");
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", LAYOUT_ARTWORK_VISIBLE, "[300lp,grow]"));
        JPanel panelLeft = new JPanel();
        this.add((Component)panelLeft, "cell 0 0,grow");
        panelLeft.setLayout(new ColumnLayout());
        for (Component component : this.generateArtworkComponents(MediaFileType.SEASON_POSTER)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.SEASON_FANART)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.SEASON_BANNER)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.SEASON_THUMB)) {
            panelLeft.add(component);
        }
        JPanel panelRight = new JPanel();
        this.add((Component)panelRight, "cell 1 0,grow");
        panelRight.setLayout((LayoutManager)new MigLayout("insets 0 n n n, hidemode 2", "[100lp,grow]", "[][][shrink 0][][75lp:n][shrink 0][][25%:50%,grow]"));
        this.lblTvshowTitle = new TmmLabel("", 1.33);
        panelRight.add((Component)this.lblTvshowTitle, "cell 0 0");
        this.lblSeason = new JLabel("");
        panelRight.add((Component)this.lblSeason, "cell 0 1");
        TmmFontHelper.changeFont(this.lblSeason, 1.166, 1);
        panelRight.add((Component)new JSeparator(), "cell 0 2,growx");
        TmmLabel lblPlotT = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        panelRight.add((Component)lblPlotT, "cell 0 3");
        NoBorderScrollPane scrollPane = new NoBorderScrollPane();
        this.taOverview = new ReadOnlyTextPane();
        scrollPane.setViewportView(this.taOverview);
        panelRight.add((Component)scrollPane, "cell 0 4,growx,wmin 0,aligny top");
        panelRight.add((Component)new JSeparator(), "cell 0 5,growx");
        TmmLabel lblEpisodelistT = new TmmLabel(TmmResourceBundle.getString("metatag.episodes"));
        panelRight.add((Component)lblEpisodelistT, "cell 0 6");
        this.tableEpisodes = new TmmTable((TableModel)((Object)this.episodeTableModel));
        this.tableEpisodes.setName("tvshows.seaon.episodeTable");
        TmmUILayoutStore.getInstance().install(this.tableEpisodes);
        JScrollPane scrollPaneEpisodes = new JScrollPane();
        this.tableEpisodes.configureScrollPane(scrollPaneEpisodes);
        panelRight.add((Component)scrollPaneEpisodes, "cell 0 7,grow");
        scrollPaneEpisodes.setViewportView(this.tableEpisodes);
    }

    private void setPoster(TvShowSeason season) {
        String posterPath = season.getArtworkFilename(MediaFileType.SEASON_POSTER);
        Dimension posterSize = season.getArtworkDimension(MediaFileType.SEASON_POSTER);
        if (StringUtils.isBlank((CharSequence)posterPath) && TvShowModuleManager.getInstance().getSettings().isSeasonArtworkFallback()) {
            posterPath = season.getTvShow().getArtworkFilename(MediaFileType.POSTER);
            posterSize = season.getTvShow().getArtworkDimension(MediaFileType.POSTER);
        }
        this.setArtwork(MediaFileType.SEASON_POSTER, posterPath, posterSize);
    }

    private void setFanart(TvShowSeason season) {
        String fanartPath = season.getArtworkFilename(MediaFileType.SEASON_FANART);
        Dimension fanartSize = season.getArtworkDimension(MediaFileType.SEASON_FANART);
        if (StringUtils.isBlank((CharSequence)fanartPath) && TvShowModuleManager.getInstance().getSettings().isSeasonArtworkFallback()) {
            fanartPath = season.getTvShow().getArtworkFilename(MediaFileType.FANART);
            fanartSize = season.getTvShow().getArtworkDimension(MediaFileType.FANART);
        }
        this.setArtwork(MediaFileType.SEASON_FANART, fanartPath, fanartSize);
    }

    private void setBanner(TvShowSeason season) {
        String bannerPath = season.getArtworkFilename(MediaFileType.SEASON_BANNER);
        Dimension bannerSize = season.getArtworkDimension(MediaFileType.SEASON_BANNER);
        if (StringUtils.isBlank((CharSequence)bannerPath) && TvShowModuleManager.getInstance().getSettings().isSeasonArtworkFallback()) {
            bannerPath = season.getTvShow().getArtworkFilename(MediaFileType.BANNER);
            bannerSize = season.getTvShow().getArtworkDimension(MediaFileType.BANNER);
        }
        this.setArtwork(MediaFileType.SEASON_BANNER, bannerPath, bannerSize);
    }

    private void setThumb(TvShowSeason season) {
        String thumbPath = season.getArtworkFilename(MediaFileType.SEASON_THUMB);
        Dimension thumbSize = season.getArtworkDimension(MediaFileType.SEASON_THUMB);
        if (StringUtils.isBlank((CharSequence)thumbPath) && TvShowModuleManager.getInstance().getSettings().isSeasonArtworkFallback()) {
            thumbPath = season.getTvShow().getArtworkFilename(MediaFileType.FANART);
            thumbSize = season.getTvShow().getArtworkDimension(MediaFileType.FANART);
        }
        this.setArtwork(MediaFileType.SEASON_THUMB, thumbPath, thumbSize);
    }

    private void setArtwork(MediaFileType type, String artworkPath, Dimension artworkDimension) {
        List components = (List)this.artworkComponents.get((Object)type);
        if (ListUtils.isEmpty(components)) {
            return;
        }
        boolean visible = this.getShowArtworkFromSettings().contains((Object)type);
        for (Component component : components) {
            component.setVisible(visible);
            if (component instanceof ImageLabel) {
                ImageLabel imageLabel = (ImageLabel)component;
                imageLabel.setImagePath(artworkPath);
                continue;
            }
            if (!(component instanceof JLabel)) continue;
            JLabel sizeLabel = (JLabel)component;
            if (artworkDimension.width > 0 && artworkDimension.height > 0) {
                sizeLabel.setText(TmmResourceBundle.getString("mediafiletype." + type.name().toLowerCase(Locale.ROOT)) + " - " + artworkDimension.width + "x" + artworkDimension.height);
                continue;
            }
            sizeLabel.setText(TmmResourceBundle.getString("mediafiletype." + type.name().toLowerCase(Locale.ROOT)));
        }
        this.updateArtwork();
    }

    @Override
    protected List<MediaFileType> getShowArtworkFromSettings() {
        return TvShowModuleManager.getInstance().getSettings().getShowSeasonArtworkTypes();
    }

    @Override
    protected void setColumnLayout(boolean artworkVisible) {
        if (artworkVisible) {
            ((MigLayout)this.getLayout()).setColumnConstraints((Object)LAYOUT_ARTWORK_VISIBLE);
        } else {
            ((MigLayout)this.getLayout()).setColumnConstraints((Object)LAYOUT_ARTWORK_HIDDEN);
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowSeasonSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowSeason.tvShow.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSeasonSelectionModel, (Property)tvShowSeasonSelectionModelBeanProperty, (Object)this.lblTvshowTitle, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSeasonSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowSeason.plot");
        BeanProperty readOnlyTextPaneHTMLBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSeasonSelectionModel, (Property)tvShowSeasonSelectionModelBeanProperty_1, (Object)this.taOverview, (Property)readOnlyTextPaneHTMLBeanProperty);
        autoBinding_1.bind();
    }

    private static class EpisodeTableFormat
    extends TmmTableFormat<TvShowEpisode> {
        public EpisodeTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.episode"), "episode", TvShowEpisode::getEpisode, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", MediaEntity::getTitle, String.class);
            col.setCellTooltip(MediaEntity::getTitle);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.aired"), "aired", TvShowEpisode::getFirstAiredAsString, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
        }
    }

    private class EpisodeTableCellRenderer
    extends DefaultTableCellRenderer {
        private EpisodeTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int dataRow = table.convertRowIndexToModel(row);
            if (((TvShowEpisode)TvShowSeasonInformationPanel.this.episodeEventList.get(dataRow)).isDummy()) {
                c.setForeground(TvShowSeasonInformationPanel.this.dummyColor);
            } else {
                c.setForeground(TvShowSeasonInformationPanel.this.defaultColor);
            }
            return c;
        }
    }
}

