/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;

class TvShowImageOptionsSettingsPanel
extends JPanel {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private JCheckBox chckbxAutomaticallyScrapeImages;
    private JComboBox cbImagePosterSize;
    private JComboBox cbImageFanartSize;
    private JComboBox cbImageThumbSize;
    private JComboBox<MediaLanguages> cbScraperLanguage;
    private JList listLanguages;
    private JButton btnAddLanguage;
    private JButton btnRemoveLanguage;
    private JButton btnMoveLanguageUp;
    private JButton btnMoveLanguageDown;
    private JCheckBox chckbxResolutions;
    private JCheckBox chckbxFallback;
    private JCheckBox chckbxFanartWoText;

    TvShowImageOptionsSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnAddLanguage.addActionListener(arg0 -> {
            Object selectedItem = this.cbScraperLanguage.getSelectedItem();
            if (selectedItem instanceof MediaLanguages) {
                MediaLanguages language = (MediaLanguages)((Object)((Object)selectedItem));
                TvShowModuleManager.getInstance().getSettings().addImageScraperLanguage(language);
            }
        });
        this.btnRemoveLanguage.addActionListener(arg0 -> {
            int row = this.listLanguages.getSelectedIndex();
            if (row != -1) {
                MediaLanguages language = this.settings.getImageScraperLanguages().get(row);
                TvShowModuleManager.getInstance().getSettings().removeImageScraperLanguage(language);
            }
        });
        this.btnMoveLanguageUp.addActionListener(arg0 -> {
            int row = this.listLanguages.getSelectedIndex();
            if (row != -1 && row != 0) {
                this.settings.swapImageScraperLanguage(row, row - 1);
                this.listLanguages.setSelectedIndex(--row);
                this.listLanguages.updateUI();
            }
        });
        this.btnMoveLanguageDown.addActionListener(arg0 -> {
            int row = this.listLanguages.getSelectedIndex();
            if (row != -1 && row < this.listLanguages.getModel().getSize() - 1) {
                this.settings.swapImageScraperLanguage(row, row + 1);
                this.listLanguages.setSelectedIndex(++row);
                this.listLanguages.updateUI();
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[700lp,grow]", "[]"));
        JPanel panelOptions = new JPanel();
        panelOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][15lp!][][][][15lp!][][]"));
        TmmLabel lblOptionsT = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptionsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#advanced-options-1"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx,wmin 0");
        this.chckbxAutomaticallyScrapeImages = new JCheckBox(TmmResourceBundle.getString("Settings.default.autoscrape"));
        panelOptions.add((Component)this.chckbxAutomaticallyScrapeImages, "cell 1 0 2 1");
        JLabel lblImageTmdbPosterSize = new JLabel(TmmResourceBundle.getString("image.poster.size"));
        panelOptions.add((Component)lblImageTmdbPosterSize, "cell 1 1 2 1");
        this.cbImagePosterSize = new JComboBox<MediaArtwork.PosterSizes>(MediaArtwork.PosterSizes.values());
        panelOptions.add((Component)this.cbImagePosterSize, "cell 1 1 2 1");
        JLabel lblImageTmdbFanartSize = new JLabel(TmmResourceBundle.getString("image.fanart.size"));
        panelOptions.add((Component)lblImageTmdbFanartSize, "cell 1 2 2 1");
        this.cbImageFanartSize = new JComboBox<MediaArtwork.FanartSizes>(MediaArtwork.FanartSizes.values());
        panelOptions.add((Component)this.cbImageFanartSize, "cell 1 2 2 1");
        JLabel lblImageTmdbThumbSize = new JLabel(TmmResourceBundle.getString("image.thumb.size"));
        panelOptions.add((Component)lblImageTmdbThumbSize, "cell 1 3 2 1");
        this.cbImageThumbSize = new JComboBox<MediaArtwork.ThumbSizes>(MediaArtwork.ThumbSizes.values());
        panelOptions.add((Component)this.cbImageThumbSize, "cell 1 3 2 1");
        JLabel lblScraperLanguage = new JLabel(TmmResourceBundle.getString("Settings.preferredLanguage"));
        panelOptions.add((Component)lblScraperLanguage, "cell 1 5 2 1");
        JPanel panelLanguagegSource = new JPanel();
        panelOptions.add((Component)panelLanguagegSource, "cell 2 6,grow");
        panelLanguagegSource.setLayout((LayoutManager)new MigLayout("insets 0", "[100lp][]", "[grow][]"));
        this.listLanguages = new JList();
        this.listLanguages.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.listLanguages);
        panelLanguagegSource.add((Component)scrollPane, "cell 0 0,grow");
        this.btnMoveLanguageUp = new SquareIconButton(IconManager.ARROW_UP_INV);
        this.btnMoveLanguageUp.setToolTipText(TmmResourceBundle.getString("Button.moveup"));
        panelLanguagegSource.add((Component)this.btnMoveLanguageUp, "flowy,cell 1 0,aligny bottom");
        this.btnMoveLanguageDown = new SquareIconButton(IconManager.ARROW_DOWN_INV);
        this.btnMoveLanguageDown.setToolTipText(TmmResourceBundle.getString("Button.movedown"));
        panelLanguagegSource.add((Component)this.btnMoveLanguageDown, "cell 1 0,aligny bottom");
        this.cbScraperLanguage = new JComboBox<MediaLanguages>(MediaLanguages.allValuesSorted());
        panelLanguagegSource.add(this.cbScraperLanguage, "cell 0 1,growx");
        this.btnRemoveLanguage = new SquareIconButton(IconManager.REMOVE_INV);
        this.btnRemoveLanguage.setToolTipText(TmmResourceBundle.getString("Button.remove"));
        panelLanguagegSource.add((Component)this.btnRemoveLanguage, "cell 1 0");
        this.btnAddLanguage = new SquareIconButton(IconManager.ADD_INV);
        this.btnAddLanguage.setToolTipText(TmmResourceBundle.getString("Button.add"));
        panelLanguagegSource.add((Component)this.btnAddLanguage, "cell 1 1");
        this.chckbxFanartWoText = new JCheckBox(TmmResourceBundle.getString("Settings.default.autoscrape.fanartwotext"));
        panelOptions.add((Component)this.chckbxFanartWoText, "cell 1 7 2 1");
        this.chckbxResolutions = new JCheckBox(TmmResourceBundle.getString("Settings.default.autoscrape.resolutions"));
        panelOptions.add((Component)this.chckbxResolutions, "cell 1 9 2 1");
        this.chckbxFallback = new JCheckBox(TmmResourceBundle.getString("Settings.default.autoscrape.fallback"));
        panelOptions.add((Component)this.chckbxFallback, "cell 1 10 2 1");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"imagePosterSize");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, (Object)this.cbImagePosterSize, (Property)jComboBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"imageFanartSize");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.cbImageFanartSize, (Property)jComboBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"imageScraperLanguages");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (JList)this.listLanguages);
        jListBinding.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"imageScraperPreferFanartWoText");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.chckbxFanartWoText, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"imageScraperOtherResolutions");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.chckbxResolutions, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_3 = BeanProperty.create((String)"imageScraperFallback");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_3, (Object)this.chckbxFallback, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_4 = BeanProperty.create((String)"imageThumbSize");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_4, (Object)this.cbImageThumbSize, (Property)jComboBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"scrapeBestImage");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxAutomaticallyScrapeImages, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
    }
}

