/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowPostProcessDialog;

public class TvShowPostProcessingSettingsPanel
extends JPanel {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private TmmTable tablePostProcessesEpisode;
    private TmmTable tablePostProcessesTvShow;
    private JButton btnRemoveProcessTvShow;
    private JButton btnAddProcessTvShow;
    private JButton btnEditProcessTvShow;
    private JButton btnAddProcessEpisode;
    private JButton btnEditProcessEpisode;
    private JButton btnRemoveProcessEpisode;

    TvShowPostProcessingSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnAddProcessTvShow.addActionListener(e -> {
            TvShowPostProcessDialog.showTvShowPostProcessDialog();
            this.tablePostProcessesTvShow.adjustColumnPreferredWidths(5);
        });
        this.btnRemoveProcessTvShow.addActionListener(e -> {
            int row = this.tablePostProcessesTvShow.getSelectedRow();
            if ((row = this.tablePostProcessesTvShow.convertRowIndexToModel(row)) != -1) {
                PostProcess process = this.settings.getPostProcessTvShow().get(row);
                this.settings.removePostProcessTvShow(process);
                this.tablePostProcessesTvShow.adjustColumnPreferredWidths(5);
            }
        });
        this.btnEditProcessTvShow.addActionListener(e -> {
            PostProcess process;
            int row = this.tablePostProcessesTvShow.getSelectedRow();
            if ((row = this.tablePostProcessesTvShow.convertRowIndexToModel(row)) != -1 && (process = this.settings.getPostProcessTvShow().get(row)) != null) {
                TvShowPostProcessDialog.showTvShowPostProcessDialog(process);
                this.tablePostProcessesTvShow.adjustColumnPreferredWidths(5);
            }
        });
        this.btnAddProcessEpisode.addActionListener(e -> {
            TvShowPostProcessDialog.showEpisodePostProcessDialog();
            this.tablePostProcessesEpisode.adjustColumnPreferredWidths(5);
        });
        this.btnRemoveProcessEpisode.addActionListener(e -> {
            int row = this.tablePostProcessesEpisode.getSelectedRow();
            if ((row = this.tablePostProcessesEpisode.convertRowIndexToModel(row)) != -1) {
                PostProcess process = this.settings.getPostProcessEpisode().get(row);
                this.settings.removePostProcessEpisode(process);
            }
        });
        this.btnEditProcessEpisode.addActionListener(e -> {
            PostProcess process;
            int row = this.tablePostProcessesEpisode.getSelectedRow();
            if ((row = this.tablePostProcessesEpisode.convertRowIndexToModel(row)) != -1 && (process = this.settings.getPostProcessEpisode().get(row)) != null) {
                TvShowPostProcessDialog.showEpisodePostProcessDialog(process);
                this.tablePostProcessesEpisode.adjustColumnPreferredWidths(5);
            }
        });
        this.tablePostProcessesTvShow.getColumnModel().getColumn(0).setHeaderValue(TmmResourceBundle.getString("Settings.processname"));
        this.tablePostProcessesTvShow.getColumnModel().getColumn(1).setHeaderValue(TmmResourceBundle.getString("metatag.path"));
        this.tablePostProcessesTvShow.getColumnModel().getColumn(2).setHeaderValue(TmmResourceBundle.getString("Settings.commandname"));
        this.tablePostProcessesTvShow.adjustColumnPreferredWidths(5);
        this.tablePostProcessesEpisode.getColumnModel().getColumn(0).setHeaderValue(TmmResourceBundle.getString("Settings.processname"));
        this.tablePostProcessesEpisode.getColumnModel().getColumn(1).setHeaderValue(TmmResourceBundle.getString("metatag.path"));
        this.tablePostProcessesEpisode.getColumnModel().getColumn(2).setHeaderValue(TmmResourceBundle.getString("Settings.commandname"));
        this.tablePostProcessesEpisode.adjustColumnPreferredWidths(5);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[]"));
        JPanel panelProcess = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][300lp:600lp,grow][]", "[][grow][150lp:200lp,grow][][][grow][150lp:200lp,grow]"));
        TmmLabel lblProcess = new TmmLabel(TmmResourceBundle.getString("Settings.postprocessing"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelProcess, lblProcess, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#post-processing"));
        this.add((Component)collapsiblePanel, "growx,wmin 0");
        TmmLabel lblTvShow = new TmmLabel(TmmResourceBundle.getString("metatag.tvshow"));
        panelProcess.add((Component)lblTvShow, "cell 1 0");
        ReadOnlyTextPane tpTvShowDescription = new ReadOnlyTextPane(TmmResourceBundle.getString("Settings.tvshow.postprocess.tvshowhint"));
        panelProcess.add((Component)tpTvShowDescription, "cell 1 1 2 1,grow");
        JScrollPane spProcesses = new JScrollPane();
        panelProcess.add((Component)spProcesses, "cell 1 2,grow");
        this.tablePostProcessesTvShow = new TmmTable();
        this.tablePostProcessesTvShow.configureScrollPane(spProcesses);
        this.btnAddProcessTvShow = new JButton(TmmResourceBundle.getString("Button.add"));
        panelProcess.add((Component)this.btnAddProcessTvShow, "flowy,cell 2 2,growx,aligny top");
        this.btnEditProcessTvShow = new JButton(TmmResourceBundle.getString("Button.edit"));
        panelProcess.add((Component)this.btnEditProcessTvShow, "cell 2 2,growx");
        this.btnRemoveProcessTvShow = new JButton(TmmResourceBundle.getString("Button.remove"));
        panelProcess.add((Component)this.btnRemoveProcessTvShow, "cell 2 2,growx");
        JSeparator separator = new JSeparator();
        panelProcess.add((Component)separator, "cell 1 3 2 1,growx");
        TmmLabel lblEpisode = new TmmLabel(TmmResourceBundle.getString("metatag.episode"));
        panelProcess.add((Component)lblEpisode, "cell 1 4");
        ReadOnlyTextPane tpEpisodeDescription = new ReadOnlyTextPane(TmmResourceBundle.getString("Settings.tvshow.postprocess.episodehint"));
        panelProcess.add((Component)tpEpisodeDescription, "cell 1 5 2 1,grow");
        JScrollPane spProcesses2 = new JScrollPane();
        panelProcess.add((Component)spProcesses2, "cell 1 6,grow");
        this.tablePostProcessesEpisode = new TmmTable();
        this.tablePostProcessesEpisode.configureScrollPane(spProcesses2);
        this.btnAddProcessEpisode = new JButton(TmmResourceBundle.getString("Button.add"));
        panelProcess.add((Component)this.btnAddProcessEpisode, "flowy,cell 2 6,growx,aligny top");
        this.btnEditProcessEpisode = new JButton(TmmResourceBundle.getString("Button.edit"));
        panelProcess.add((Component)this.btnEditProcessEpisode, "cell 2 6,growx");
        this.btnRemoveProcessEpisode = new JButton(TmmResourceBundle.getString("Button.remove"));
        panelProcess.add((Component)this.btnRemoveProcessEpisode, "cell 2 6,growx");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"postProcessTvShow");
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (JTable)this.tablePostProcessesTvShow);
        BeanProperty wolBeanProperty_1 = BeanProperty.create((String)"name");
        jTableBinding.addColumnBinding((Property)wolBeanProperty_1);
        BeanProperty wolBeanProperty_3 = BeanProperty.create((String)"path");
        jTableBinding.addColumnBinding((Property)wolBeanProperty_3);
        BeanProperty wolBeanProperty_4 = BeanProperty.create((String)"command");
        jTableBinding.addColumnBinding((Property)wolBeanProperty_4);
        jTableBinding.setEditable(false);
        jTableBinding.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"postProcessEpisode");
        JTableBinding jTableBinding_1 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (JTable)this.tablePostProcessesEpisode);
        BeanProperty postProcessBeanProperty = BeanProperty.create((String)"name");
        jTableBinding_1.addColumnBinding((Property)postProcessBeanProperty);
        BeanProperty postProcessBeanProperty_1 = BeanProperty.create((String)"path");
        jTableBinding_1.addColumnBinding((Property)postProcessBeanProperty_1);
        BeanProperty postProcessBeanProperty_2 = BeanProperty.create((String)"command");
        jTableBinding_1.addColumnBinding((Property)postProcessBeanProperty_2);
        jTableBinding_1.bind();
    }
}

