/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmRoundTextArea;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.renderer.MultilineTableCellRenderer;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowJmteExplorerDialog;

public class TvShowRenamerSettingsPanel
extends JPanel
implements HierarchyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowRenamerSettingsPanel.class);
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final List<String> spaceReplacements = new ArrayList<String>(Arrays.asList("_", ".", "-"));
    private final List<String> colonReplacements = new ArrayList<String>(Arrays.asList(" ", "-", "_"));
    private LinkLabel lblExampleDatasource;
    private JLabel lblExampleFoldername;
    private JLabel lblExampleFilename;
    private JComboBox<TvShowPreviewContainer> cbTvShowForPreview;
    private JTextArea tfSeasonFolderName;
    private JCheckBox chckbxAsciiReplacement;
    private JCheckBox chckbxShowFoldernameSpaceReplacement;
    private JComboBox cbShowFoldernameSpaceReplacement;
    private JCheckBox chckbxSeasonFoldernameSpaceReplacement;
    private JComboBox cbSeasonFoldernameSpaceReplacement;
    private JCheckBox chckbxFilenameSpaceReplacement;
    private JComboBox cbFilenameSpaceReplacement;
    private JComboBox<TvShowEpisodePreviewContainer> cbEpisodeForPreview;
    private JTextArea tfTvShowFolder;
    private JTextArea tfEpisodeFilename;
    private JComboBox cbColonReplacement;
    private JTextField tfFirstCharacter;
    private JCheckBox chckbxAutomaticRename;
    private JCheckBox chckbxCleanupUnwanted;

    public TvShowRenamerSettingsPanel() {
        String colonReplacement;
        this.initComponents();
        this.initDataBindings();
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }
        };
        this.tfTvShowFolder.getDocument().addDocumentListener(documentListener);
        this.tfSeasonFolderName.getDocument().addDocumentListener(documentListener);
        this.tfEpisodeFilename.getDocument().addDocumentListener(documentListener);
        this.tfFirstCharacter.getDocument().addDocumentListener(documentListener);
        this.cbTvShowForPreview.addActionListener(arg0 -> {
            this.buildAndInstallEpisodeArray();
            this.createRenamerExample();
        });
        String replacement = this.settings.getRenamerShowPathnameSpaceReplacement();
        int index = this.spaceReplacements.indexOf(replacement);
        if (index >= 0) {
            this.cbShowFoldernameSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.spaceReplacements.indexOf(replacement = this.settings.getRenamerSeasonPathnameSpaceReplacement())) >= 0) {
            this.cbSeasonFoldernameSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.spaceReplacements.indexOf(replacement = this.settings.getRenamerFilenameSpaceReplacement())) >= 0) {
            this.cbFilenameSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.colonReplacements.indexOf(colonReplacement = this.settings.getRenamerColonReplacement())) >= 0) {
            this.cbColonReplacement.setSelectedIndex(index);
        }
        ActionListener renamerActionListener = arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        };
        this.chckbxShowFoldernameSpaceReplacement.addActionListener(renamerActionListener);
        this.chckbxSeasonFoldernameSpaceReplacement.addActionListener(renamerActionListener);
        this.chckbxFilenameSpaceReplacement.addActionListener(renamerActionListener);
        this.chckbxAsciiReplacement.addActionListener(renamerActionListener);
        this.cbEpisodeForPreview.addActionListener(arg0 -> this.createRenamerExample());
        this.cbShowFoldernameSpaceReplacement.addActionListener(renamerActionListener);
        this.cbSeasonFoldernameSpaceReplacement.addActionListener(renamerActionListener);
        this.cbFilenameSpaceReplacement.addActionListener(renamerActionListener);
        this.cbColonReplacement.addActionListener(renamerActionListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[][15lp!][][15lp!][]"));
        JPanel panelPatterns = new JPanel((LayoutManager)new MigLayout("insets 0, hidemode 1", "[20lp!][15lp][][400lp,grow][grow]", "[][][][][][][]"));
        TmmLabel lblPatternsT = new TmmLabel(TmmResourceBundle.getString("Settings.tvshow.renamer.title"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelPatterns, lblPatternsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#renamer"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx,wmin 0");
        JLabel lblTvShowFolder = new JLabel(TmmResourceBundle.getString("Settings.tvshowfoldername"));
        panelPatterns.add((Component)lblTvShowFolder, "cell 1 0 2 1,alignx right");
        this.tfTvShowFolder = new TmmRoundTextArea();
        panelPatterns.add((Component)this.tfTvShowFolder, "cell 3 0, growx, wmin 0");
        FlatButton btnReset = new FlatButton(IconManager.UNDO_GREY);
        btnReset.setToolTipText(TmmResourceBundle.getString("Settings.renamer.reverttodefault"));
        btnReset.addActionListener(l -> this.tfTvShowFolder.setText("${showTitle} (${showYear})"));
        panelPatterns.add((Component)btnReset, "cell 3 0, aligny top");
        JLabel lblDefault = new JLabel(TmmResourceBundle.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 1 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, 0.83333);
        ReadOnlyTextArea tpDefaultFolderPattern = new ReadOnlyTextArea("${showTitle} (${showYear})");
        panelPatterns.add((Component)tpDefaultFolderPattern, "cell 3 1,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultFolderPattern, 0.83333);
        JLabel lblSeasonFolderName = new JLabel(TmmResourceBundle.getString("Settings.tvshowseasonfoldername"));
        panelPatterns.add((Component)lblSeasonFolderName, "cell 1 2 2 1,alignx right");
        this.tfSeasonFolderName = new TmmRoundTextArea();
        panelPatterns.add((Component)this.tfSeasonFolderName, "cell 3 2, growx, wmin 0");
        btnReset = new FlatButton(IconManager.UNDO_GREY);
        btnReset.setToolTipText(TmmResourceBundle.getString("Settings.renamer.reverttodefault"));
        btnReset.addActionListener(l -> this.tfSeasonFolderName.setText("Season ${seasonNr}"));
        panelPatterns.add((Component)btnReset, "cell 3 2, aligny top");
        lblDefault = new JLabel(TmmResourceBundle.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 3 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, 0.83333);
        ReadOnlyTextArea tpDefaultSeasonPattern = new ReadOnlyTextArea("Season ${seasonNr}");
        panelPatterns.add((Component)tpDefaultSeasonPattern, "cell 3 3,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultSeasonPattern, 0.83333);
        JLabel lblEpisodeFileName = new JLabel(TmmResourceBundle.getString("Settings.tvshowfilename"));
        panelPatterns.add((Component)lblEpisodeFileName, "cell 1 4 2 1,alignx right");
        this.tfEpisodeFilename = new TmmRoundTextArea();
        panelPatterns.add((Component)this.tfEpisodeFilename, "cell 3 4, growx, wmin 0");
        btnReset = new FlatButton(IconManager.UNDO_GREY);
        btnReset.setToolTipText(TmmResourceBundle.getString("Settings.renamer.reverttodefault"));
        btnReset.addActionListener(l -> this.tfEpisodeFilename.setText("${showTitle} - S${seasonNr2}E${episodeNr2} - ${title}"));
        panelPatterns.add((Component)btnReset, "cell 3 4, aligny top");
        lblDefault = new JLabel(TmmResourceBundle.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 5 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, 0.83333);
        ReadOnlyTextArea tpDefaultFilePattern = new ReadOnlyTextArea("${showTitle} - S${seasonNr2}E${episodeNr2} - ${title}");
        panelPatterns.add((Component)tpDefaultFilePattern, "cell 3 5,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultFilePattern, 0.83333);
        JLabel lblRenamerHintT = new JLabel(TmmResourceBundle.getString("Settings.tvshow.renamer.hint"));
        panelPatterns.add((Component)lblRenamerHintT, "cell 1 6 3 1");
        JButton btnJmteExplorer = new JButton(TmmResourceBundle.getString("jmteexplorer.title"));
        btnJmteExplorer.addActionListener(e -> {
            TvShowJmteExplorerDialog dialog = new TvShowJmteExplorerDialog((Window)((JDialog)this.getTopLevelAncestor()));
            dialog.setVisible(true);
        });
        panelPatterns.add((Component)btnJmteExplorer, "cell 4 0");
        JPanel panelAdvancedOptions = new JPanel();
        panelAdvancedOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][][][]"));
        TmmLabel lblAdvancedOptions = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelAdvancedOptions, lblAdvancedOptions, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#advanced-options-3"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx");
        this.chckbxAutomaticRename = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.automaticrename"));
        panelAdvancedOptions.add((Component)this.chckbxAutomaticRename, "cell 1 0 2 1");
        JLabel lblAutomaticRenameHint = new JLabel(IconManager.HINT);
        lblAutomaticRenameHint.setToolTipText(TmmResourceBundle.getString("Settings.tvshow.automaticrename.desc"));
        panelAdvancedOptions.add((Component)lblAutomaticRenameHint, "cell 1 0 2 1");
        this.chckbxShowFoldernameSpaceReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.showfolderspacereplacement"));
        this.chckbxShowFoldernameSpaceReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.folderspacereplacement.hint"));
        panelAdvancedOptions.add((Component)this.chckbxShowFoldernameSpaceReplacement, "cell 1 1 2 1");
        this.cbShowFoldernameSpaceReplacement = new JComboBox<Object>(this.spaceReplacements.toArray());
        panelAdvancedOptions.add((Component)this.cbShowFoldernameSpaceReplacement, "cell 1 1 2 1");
        this.chckbxSeasonFoldernameSpaceReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.seasonfolderspacereplacement"));
        this.chckbxSeasonFoldernameSpaceReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.folderspacereplacement.hint"));
        panelAdvancedOptions.add((Component)this.chckbxSeasonFoldernameSpaceReplacement, "cell 1 2 2 1");
        this.cbSeasonFoldernameSpaceReplacement = new JComboBox<Object>(this.spaceReplacements.toArray());
        panelAdvancedOptions.add((Component)this.cbSeasonFoldernameSpaceReplacement, "cell 1 2 2 1");
        this.chckbxFilenameSpaceReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.spacereplacement"));
        this.chckbxFilenameSpaceReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.spacereplacement.hint"));
        panelAdvancedOptions.add((Component)this.chckbxFilenameSpaceReplacement, "cell 1 3 2 1");
        this.cbFilenameSpaceReplacement = new JComboBox<Object>(this.spaceReplacements.toArray());
        panelAdvancedOptions.add((Component)this.cbFilenameSpaceReplacement, "cell 1 3 2 1");
        JLabel lblColonReplacement = new JLabel(TmmResourceBundle.getString("Settings.renamer.colonreplacement"));
        panelAdvancedOptions.add((Component)lblColonReplacement, "cell 1 4 2 1");
        lblColonReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.colonreplacement.hint"));
        this.cbColonReplacement = new JComboBox<Object>(this.colonReplacements.toArray());
        panelAdvancedOptions.add((Component)this.cbColonReplacement, "cell 1 4 2 1");
        this.chckbxAsciiReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.asciireplacement"));
        panelAdvancedOptions.add((Component)this.chckbxAsciiReplacement, "cell 1 5 2 1");
        JLabel lblAsciiHint = new JLabel(TmmResourceBundle.getString("Settings.renamer.asciireplacement.hint"));
        panelAdvancedOptions.add((Component)lblAsciiHint, "cell 2 6");
        TmmFontHelper.changeFont((JComponent)lblAsciiHint, 0.83333);
        this.chckbxCleanupUnwanted = new JCheckBox(TmmResourceBundle.getString("Settings.cleanupfiles"));
        panelAdvancedOptions.add((Component)this.chckbxCleanupUnwanted, "cell 1 7 2 1");
        JLabel lblFirstCharacterT = new JLabel(TmmResourceBundle.getString("Settings.renamer.firstnumbercharacterreplacement"));
        panelAdvancedOptions.add((Component)lblFirstCharacterT, "flowx,cell 1 8 2 1");
        this.tfFirstCharacter = new JTextField();
        panelAdvancedOptions.add((Component)this.tfFirstCharacter, "cell 1 9 2 1");
        this.tfFirstCharacter.setColumns(2);
        JPanel panelExample = new JPanel();
        panelExample.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][][300lp,grow]", "[][]10lp![][][]"));
        lblAdvancedOptions = new TmmLabel(TmmResourceBundle.getString("Settings.example"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelExample, lblAdvancedOptions, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#example"));
        this.add((Component)collapsiblePanel, "cell 0 4,growx, wmin 0");
        JLabel lblExampleTvShowT = new JLabel(TmmResourceBundle.getString("metatag.tvshow"));
        panelExample.add((Component)lblExampleTvShowT, "cell 1 0");
        this.cbTvShowForPreview = new JComboBox();
        panelExample.add(this.cbTvShowForPreview, "cell 2 0,growx,wmin 0");
        JLabel lblExampleEpisodeT = new JLabel(TmmResourceBundle.getString("metatag.episode"));
        panelExample.add((Component)lblExampleEpisodeT, "cell 1 1");
        this.cbEpisodeForPreview = new JComboBox();
        panelExample.add(this.cbEpisodeForPreview, "cell 2 1,growx,wmin 0");
        TmmLabel lblDatasourceT = new TmmLabel(TmmResourceBundle.getString("metatag.datasource"));
        panelExample.add((Component)lblDatasourceT, "cell 1 2");
        this.lblExampleDatasource = new LinkLabel("");
        panelExample.add((Component)this.lblExampleDatasource, "cell 2 2, wmin 0");
        TmmLabel lblFoldernameT = new TmmLabel(TmmResourceBundle.getString("Settings.renamer.folder"));
        panelExample.add((Component)lblFoldernameT, "cell 1 3");
        this.lblExampleFoldername = new JLabel("");
        panelExample.add((Component)this.lblExampleFoldername, "cell 2 3, wmin 0");
        TmmLabel lblFilenameT = new TmmLabel(TmmResourceBundle.getString("Settings.renamer.file"));
        panelExample.add((Component)lblFilenameT, "cell 1 4");
        this.lblExampleFilename = new JLabel("");
        panelExample.add((Component)this.lblExampleFilename, "cell 2 4, wmin 0");
    }

    @Override
    public void hierarchyChanged(HierarchyEvent arg0) {
        if (this.isShowing()) {
            this.buildAndInstallTvShowArray();
            this.buildAndInstallEpisodeArray();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    private void buildAndInstallTvShowArray() {
        this.cbTvShowForPreview.removeAllItems();
        ArrayList<TvShow> allTvShows = new ArrayList<TvShow>(TvShowModuleManager.getInstance().getTvShowList().getTvShows());
        allTvShows.sort(new TvShowComparator());
        TvShow sel = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShow();
        for (TvShow tvShow : allTvShows) {
            TvShowPreviewContainer container = new TvShowPreviewContainer();
            container.tvShow = tvShow;
            this.cbTvShowForPreview.addItem(container);
            if (sel == null || !tvShow.equals(sel)) continue;
            this.cbTvShowForPreview.setSelectedItem(container);
        }
    }

    private void buildAndInstallEpisodeArray() {
        this.cbEpisodeForPreview.removeAllItems();
        Object obj = this.cbTvShowForPreview.getSelectedItem();
        if (obj instanceof TvShowPreviewContainer) {
            TvShowPreviewContainer c = (TvShowPreviewContainer)this.cbTvShowForPreview.getSelectedItem();
            List<TvShowEpisode> sel = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
            for (TvShowEpisode episode : c.tvShow.getEpisodes()) {
                TvShowEpisodePreviewContainer container = new TvShowEpisodePreviewContainer();
                container.episode = episode;
                this.cbEpisodeForPreview.addItem(container);
                if (sel == null || sel.size() <= 0 || !episode.equals(sel.get(0))) continue;
                this.cbEpisodeForPreview.setSelectedItem(container);
            }
        }
    }

    private void createRenamerExample() {
        SwingUtilities.invokeLater(() -> {
            Object container;
            TvShow tvShow = null;
            TvShowEpisode episode = null;
            if (this.cbTvShowForPreview.getSelectedItem() instanceof TvShowPreviewContainer) {
                container = (TvShowPreviewContainer)this.cbTvShowForPreview.getSelectedItem();
                tvShow = ((TvShowPreviewContainer)container).tvShow;
            }
            if (this.cbEpisodeForPreview.getSelectedItem() instanceof TvShowEpisodePreviewContainer) {
                container = (TvShowEpisodePreviewContainer)this.cbEpisodeForPreview.getSelectedItem();
                episode = ((TvShowEpisodePreviewContainer)container).episode;
            }
            if (tvShow != null && episode != null) {
                String tvShowDir = TvShowRenamer.getTvShowFoldername(this.tfTvShowFolder.getText(), tvShow);
                MediaFile episodeMf = TvShowRenamer.generateEpisodeFilenames(this.tfEpisodeFilename.getText(), tvShow, episode.getMainVideoFile(), FilenameUtils.getBaseName((String)episode.getMainVideoFile().getFilename())).get(0);
                String newFilenameAndPath = episodeMf.getFile().toString().replace(episode.getTvShow().getPath() + File.separator, "");
                this.lblExampleDatasource.setText(tvShow.getDataSource());
                this.lblExampleFoldername.setText(tvShowDir.replace(tvShow.getDataSource() + File.separator, ""));
                this.lblExampleFilename.setText(newFilenameAndPath);
            } else {
                this.lblExampleDatasource.setText("");
                this.lblExampleFoldername.setText("");
                this.lblExampleFilename.setText("");
            }
        });
    }

    private void checkChanges() {
        String spaceReplacement = (String)this.cbShowFoldernameSpaceReplacement.getSelectedItem();
        this.settings.setRenamerShowPathnameSpaceReplacement(spaceReplacement);
        spaceReplacement = (String)this.cbSeasonFoldernameSpaceReplacement.getSelectedItem();
        this.settings.setRenamerSeasonPathnameSpaceReplacement(spaceReplacement);
        spaceReplacement = (String)this.cbFilenameSpaceReplacement.getSelectedItem();
        this.settings.setRenamerFilenameSpaceReplacement(spaceReplacement);
        String colonReplacement = (String)this.cbColonReplacement.getSelectedItem();
        this.settings.setRenamerColonReplacement(colonReplacement);
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"asciiReplacement");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.chckbxAsciiReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"renamerShowPathnameSpaceSubstitution");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.chckbxShowFoldernameSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowSettingsBeanProperty_7 = BeanProperty.create((String)"renamerSeasonPathnameSpaceSubstitution");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_7, (Object)this.chckbxSeasonFoldernameSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty tvShowSettingsBeanProperty_8 = BeanProperty.create((String)"renamerFilenameSpaceSubstitution");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_8, (Object)this.chckbxFilenameSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"renamerTvShowFoldername");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.tfTvShowFolder, (Property)jTextFieldBeanProperty_1);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"renamerFilename");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.tfEpisodeFilename, (Property)jTextFieldBeanProperty_2);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_3 = BeanProperty.create((String)"renamerSeasonFoldername");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_3, (Object)this.tfSeasonFolderName, (Property)jTextFieldBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_4 = BeanProperty.create((String)"renamerFirstCharacterNumberReplacement");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_4, (Object)this.tfFirstCharacter, (Property)jTextFieldBeanProperty_3);
        autoBinding_3.bind();
        BeanProperty tvShowSettingsBeanProperty_5 = BeanProperty.create((String)"renameAfterScrape");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_5, (Object)this.chckbxAutomaticRename, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty tvShowSettingsBeanProperty_6 = BeanProperty.create((String)"renamerCleanupUnwanted");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_6, (Object)this.chckbxCleanupUnwanted, (Property)jCheckBoxBeanProperty);
        autoBinding_9.bind();
    }

    private static class TvShowComparator
    implements Comparator<TvShow> {
        private TvShowComparator() {
        }

        @Override
        public int compare(TvShow arg0, TvShow arg1) {
            return arg0.getTitle().compareTo(arg1.getTitle());
        }
    }

    private static class TvShowPreviewContainer {
        TvShow tvShow;

        private TvShowPreviewContainer() {
        }

        public String toString() {
            return this.tvShow.getTitle();
        }
    }

    private static class TvShowEpisodePreviewContainer {
        TvShowEpisode episode;

        private TvShowEpisodePreviewContainer() {
        }

        public String toString() {
            return this.episode.getSeason() + "." + this.episode.getEpisode() + " " + this.episode.getTitle();
        }
    }

    private static class TvShowRenamerExampleTableFormat
    extends TmmTableFormat<TvShowRenamerExample> {
        public TvShowRenamerExampleTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.token.name"), "name", token -> token.completeToken, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.token"), "description", token -> token.description, String.class);
            col.setCellRenderer(new MultilineTableCellRenderer());
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Settings.renamer.value"), "value", token -> token.example, String.class);
            col.setCellRenderer(new MultilineTableCellRenderer());
            this.addColumn(col);
        }
    }

    private static class TvShowRenamerExample
    extends AbstractModelObject {
        private static final Pattern TOKEN_PATTERN = Pattern.compile("^\\$\\{(.*?)([\\}\\[;\\.]+.*)");
        private final String token;
        private final String completeToken;
        private String longToken = "";
        private String description;
        private String example = "";

        public TvShowRenamerExample(String token) {
            this.token = token;
            this.completeToken = this.createCompleteToken();
            try {
                this.description = TmmResourceBundle.getString("Settings.tvshow.renamer." + token);
            }
            catch (Exception e) {
                this.description = "";
            }
        }

        private String createCompleteToken() {
            Object result = this.token;
            Matcher matcher = TOKEN_PATTERN.matcher(this.token);
            if (matcher.find() && matcher.groupCount() > 1) {
                String alias = matcher.group(1);
                String sourceToken = TvShowRenamer.getTokenMap().get(alias);
                if (StringUtils.isNotBlank((CharSequence)sourceToken)) {
                    result = "<html>" + this.token + "<br>${" + sourceToken + matcher.group(2) + "</html>";
                    this.longToken = "${" + sourceToken + matcher.group(2);
                }
            }
            return result;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getExample() {
            return this.example;
        }

        public void setExample(String example) {
            this.example = example;
        }

        private void createExample(TvShowEpisode episode) {
            String oldValue = this.example;
            this.example = episode == null ? "" : TvShowRenamer.createDestination(this.token, Collections.singletonList(episode));
            this.firePropertyChange("example", oldValue, this.example);
        }
    }
}

