/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.DateField;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.connector.TvShowConnectors;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonNfoNaming;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.JHintCheckBox;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.LocaleComboBox;
import org.tinymediamanager.ui.components.TmmLabel;

class TvShowScraperNfoSettingsPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowScraperNfoSettingsPanel.class);
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final ItemListener checkBoxListener;
    private final ItemListener comboBoxListener;
    private JComboBox<TvShowConnectors> cbNfoFormat;
    private JComboBox<CertificationStyleWrapper> cbCertificationStyle;
    private JCheckBox chckbxWriteCleanNfo;
    private final List<LocaleComboBox> locales = new ArrayList<LocaleComboBox>();
    private JComboBox cbNfoLanguage;
    private JComboBox<DateField> cbDatefield;
    private JCheckBox chckbxEpisodeNfo1;
    private JCheckBox chckbxTvShowNfo1;
    private JCheckBox chckbxSeasonNfo1;
    private JCheckBox chckbxWriteEpisodeguide;
    private JCheckBox chckbxWriteDateEnded;
    private JCheckBox chckbxEmbedAllActors;
    private JCheckBox chckbxFirstStudio;
    private JHintCheckBox chckbxLockdata;
    private JCheckBox chckbxNewEpisodeguideFormat;
    private JHintCheckBox chckbxTrailer;
    private JHintCheckBox chckbxFileinfo;

    TvShowScraperNfoSettingsPanel() {
        this.checkBoxListener = e -> this.checkChanges();
        this.comboBoxListener = e -> this.checkChanges();
        LocaleComboBox actualLocale = null;
        LocaleComboBox fallbackLocale = null;
        Locale settingsLang = Utils.getLocaleFromLanguage(this.settings.getNfoLanguage().toString());
        for (Locale l : Utils.getLanguages()) {
            LocaleComboBox localeComboBox = new LocaleComboBox(l);
            this.locales.add(localeComboBox);
            if (l.equals(settingsLang)) {
                actualLocale = localeComboBox;
            }
            if (!settingsLang.getLanguage().equals(l.getLanguage())) continue;
            fallbackLocale = localeComboBox;
        }
        Collections.sort(this.locales);
        this.initComponents();
        this.initDataBindings();
        if (actualLocale != null) {
            this.cbNfoLanguage.setSelectedItem(actualLocale);
        } else {
            this.cbNfoLanguage.setSelectedItem(fallbackLocale);
        }
        this.cbNfoLanguage.addItemListener(this.comboBoxListener);
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName()) || "wizard".equals(evt.getPropertyName())) {
                this.buildComboBoxes();
                this.buildCheckBoxes();
            }
        });
        this.buildCheckBoxes();
        this.buildComboBoxes();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[]"));
        JPanel panelNfo = new JPanel();
        panelNfo.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][15lp!][][][][][][][15lp!][][][][][][][]"));
        TmmLabel lblNfoT = new TmmLabel(TmmResourceBundle.getString("Settings.nfo"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelNfo, lblNfoT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#nfo-settings"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JLabel lblNfoFormatT = new JLabel(TmmResourceBundle.getString("Settings.nfoFormat"));
        panelNfo.add((Component)lblNfoFormatT, "cell 1 0 2 1");
        this.cbNfoFormat = new JComboBox<TvShowConnectors>(TvShowConnectors.values());
        panelNfo.add(this.cbNfoFormat, "cell 1 0 2 1");
        DocsButton docsButton = new DocsButton("/tvshows/nfo-formats");
        panelNfo.add((Component)docsButton, "cell 1 0 2 1");
        JLabel lblNfoFileNaming = new JLabel(TmmResourceBundle.getString("Settings.nofFileNaming"));
        panelNfo.add((Component)lblNfoFileNaming, "cell 1 1 2 1");
        JPanel panel = new JPanel();
        panelNfo.add((Component)panel, "cell 2 2");
        panel.setLayout((LayoutManager)new MigLayout("insets 0", "[][]", "[][][]"));
        JLabel lblTvShow = new JLabel(TmmResourceBundle.getString("metatag.tvshow"));
        panel.add((Component)lblTvShow, "cell 0 0");
        this.chckbxTvShowNfo1 = new JCheckBox("tvshow.nfo");
        panel.add((Component)this.chckbxTvShowNfo1, "cell 1 0");
        JLabel lblSeason = new JLabel(TmmResourceBundle.getString("metatag.season"));
        panel.add((Component)lblSeason, "cell 0 1");
        this.chckbxSeasonNfo1 = new JCheckBox("<season_folder>" + File.separator + "season.nfo");
        panel.add((Component)this.chckbxSeasonNfo1, "cell 1 1");
        JLabel lblEpisode = new JLabel(TmmResourceBundle.getString("metatag.episode"));
        panel.add((Component)lblEpisode, "cell 0 2");
        this.chckbxEpisodeNfo1 = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.episodename") + ".nfo");
        panel.add((Component)this.chckbxEpisodeNfo1, "cell 1 2");
        this.chckbxWriteCleanNfo = new JCheckBox(TmmResourceBundle.getString("Settings.writecleannfo"));
        panelNfo.add((Component)this.chckbxWriteCleanNfo, "cell 1 3 2 1");
        JLabel lblNfoDatefield = new JLabel(TmmResourceBundle.getString("Settings.dateadded"));
        panelNfo.add((Component)lblNfoDatefield, "cell 1 5 2 1");
        this.cbDatefield = new JComboBox<DateField>(DateField.values());
        panelNfo.add(this.cbDatefield, "cell 1 5 2 1");
        JLabel lblNfoLanguage = new JLabel(TmmResourceBundle.getString("Settings.nfolanguage"));
        panelNfo.add((Component)lblNfoLanguage, "cell 1 6 2 1");
        this.cbNfoLanguage = new JComboBox<Object>(this.locales.toArray());
        panelNfo.add((Component)this.cbNfoLanguage, "cell 1 6 2 1");
        JLabel lblNfoLanguageDesc = new JLabel(TmmResourceBundle.getString("Settings.nfolanguage.desc"));
        panelNfo.add((Component)lblNfoLanguageDesc, "cell 2 7");
        JLabel lblCertificationFormatT = new JLabel(TmmResourceBundle.getString("Settings.certificationformat"));
        panelNfo.add((Component)lblCertificationFormatT, "cell 1 8 2 1");
        this.cbCertificationStyle = new JComboBox();
        panelNfo.add(this.cbCertificationStyle, "cell 1 8 2 1,wmin 0");
        this.chckbxEmbedAllActors = new JCheckBox(TmmResourceBundle.getString("Settings.nfo.includeallactors"));
        panelNfo.add((Component)this.chckbxEmbedAllActors, "cell 1 9 2 1");
        this.chckbxFirstStudio = new JCheckBox(TmmResourceBundle.getString("Settings.singlestudio"));
        panelNfo.add((Component)this.chckbxFirstStudio, "cell 1 10 2 1");
        this.chckbxWriteEpisodeguide = new JCheckBox(TmmResourceBundle.getString("Settings.writeepisodeguide"));
        panelNfo.add((Component)this.chckbxWriteEpisodeguide, "cell 1 12 2 1");
        this.chckbxNewEpisodeguideFormat = new JCheckBox(TmmResourceBundle.getString("Settings.writeepisodeguide.newstyle"));
        panelNfo.add((Component)this.chckbxNewEpisodeguideFormat, "cell 2 13");
        LinkLabel lblEpisodeGuideLink = new LinkLabel("https://forum.kodi.tv/showthread.php?tid=370489");
        lblEpisodeGuideLink.addActionListener(arg0 -> {
            try {
                TmmUIHelper.browseUrl(lblEpisodeGuideLink.getText());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)lblEpisodeGuideLink.getText(), "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        panelNfo.add((Component)lblEpisodeGuideLink, "cell 2 14");
        this.chckbxTrailer = new JHintCheckBox(TmmResourceBundle.getString("Settings.nfo.trailer"));
        this.chckbxTrailer.setToolTipText(TmmResourceBundle.getString("Settings.nfo.trailer.hint"));
        this.chckbxTrailer.setHintIcon(IconManager.HINT);
        panelNfo.add((Component)this.chckbxTrailer, "cell 1 15 2 1");
        this.chckbxFileinfo = new JHintCheckBox(TmmResourceBundle.getString("Settings.nfo.fileinfo"));
        this.chckbxFileinfo.setToolTipText(TmmResourceBundle.getString("Settings.nfo.fileinfo.hint"));
        this.chckbxFileinfo.setHintIcon(IconManager.HINT);
        panelNfo.add((Component)this.chckbxFileinfo, "cell 1 16 2 1");
        this.chckbxWriteDateEnded = new JCheckBox(TmmResourceBundle.getString("Settings.nfo.writeenddate"));
        panelNfo.add((Component)this.chckbxWriteDateEnded, "cell 1 17 2 1");
        this.chckbxLockdata = new JHintCheckBox(TmmResourceBundle.getString("Settings.lockdata"));
        this.chckbxLockdata.setToolTipText(TmmResourceBundle.getString("Settings.lockdata.hint"));
        this.chckbxLockdata.setHintIcon(IconManager.HINT);
        panelNfo.add((Component)this.chckbxLockdata, "cell 1 18 2 1");
    }

    private void checkChanges() {
        CertificationStyleWrapper wrapper;
        LocaleComboBox loc = (LocaleComboBox)this.cbNfoLanguage.getSelectedItem();
        if (loc != null) {
            Locale actualLocale = this.settings.getNfoLanguage();
            if (!loc.getLocale().equals(actualLocale)) {
                this.settings.setNfoLanguage(loc.getLocale());
            }
        }
        if ((wrapper = (CertificationStyleWrapper)this.cbCertificationStyle.getSelectedItem()) != null && this.settings.getCertificationStyle() != wrapper.style) {
            this.settings.setCertificationStyle(wrapper.style);
        }
        this.settings.clearNfoFilenames();
        if (this.chckbxTvShowNfo1.isSelected()) {
            this.settings.addNfoFilename(TvShowNfoNaming.TV_SHOW);
        }
        this.settings.clearSeasonNfoFilenames();
        if (this.chckbxSeasonNfo1.isSelected()) {
            this.settings.addSeasonNfoFilename(TvShowSeasonNfoNaming.SEASON_FOLDER);
        }
        this.settings.clearEpisodeNfoFilenames();
        if (this.chckbxEpisodeNfo1.isSelected()) {
            this.settings.addEpisodeNfoFilename(TvShowEpisodeNfoNaming.FILENAME);
        }
    }

    private void buildComboBoxes() {
        this.cbCertificationStyle.removeItemListener(this.comboBoxListener);
        this.cbCertificationStyle.removeAllItems();
        for (CertificationStyle style : CertificationStyle.values()) {
            CertificationStyleWrapper wrapper = new CertificationStyleWrapper();
            wrapper.style = style;
            this.cbCertificationStyle.addItem(wrapper);
            if (style != this.settings.getCertificationStyle()) continue;
            this.cbCertificationStyle.setSelectedItem(wrapper);
        }
        this.cbCertificationStyle.addItemListener(this.comboBoxListener);
    }

    private void buildCheckBoxes() {
        List<TvShowEpisodeNfoNaming> TvShowEpisodeNfoNamings;
        List<TvShowSeasonNfoNaming> seasonNfoNamings;
        this.chckbxTvShowNfo1.removeItemListener(this.checkBoxListener);
        this.chckbxSeasonNfo1.removeItemListener(this.checkBoxListener);
        this.chckbxEpisodeNfo1.removeItemListener(this.checkBoxListener);
        this.clearSelection(this.chckbxTvShowNfo1, this.chckbxSeasonNfo1, this.chckbxEpisodeNfo1);
        List<TvShowNfoNaming> tvShowNfoNamings = this.settings.getNfoFilenames();
        if (tvShowNfoNamings.contains(TvShowNfoNaming.TV_SHOW)) {
            this.chckbxTvShowNfo1.setSelected(true);
        }
        if ((seasonNfoNamings = this.settings.getSeasonNfoFilenames()).contains(TvShowSeasonNfoNaming.SEASON_FOLDER)) {
            this.chckbxSeasonNfo1.setSelected(true);
        }
        if ((TvShowEpisodeNfoNamings = this.settings.getEpisodeNfoFilenames()).contains(TvShowEpisodeNfoNaming.FILENAME)) {
            this.chckbxEpisodeNfo1.setSelected(true);
        }
        this.chckbxTvShowNfo1.addItemListener(this.checkBoxListener);
        this.chckbxSeasonNfo1.addItemListener(this.checkBoxListener);
        this.chckbxEpisodeNfo1.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.setSelected(false);
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"tvShowConnector");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, this.cbNfoFormat, (Property)jComboBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"writeCleanNfo");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.chckbxWriteCleanNfo, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_3 = BeanProperty.create((String)"nfoDateAddedField");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_3, this.cbDatefield, (Property)jComboBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSettingsBeanProperty_4 = BeanProperty.create((String)"nfoWriteEpisodeguide");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_4, (Object)this.chckbxWriteEpisodeguide, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty_5 = BeanProperty.create((String)"nfoWriteDateEnded");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_5, (Object)this.chckbxWriteDateEnded, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowSettingsBeanProperty_6 = BeanProperty.create((String)"nfoWriteAllActors");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_6, (Object)this.chckbxEmbedAllActors, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty tvShowSettingsBeanProperty_7 = BeanProperty.create((String)"nfoWriteSingleStudio");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_7, (Object)this.chckbxFirstStudio, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty tvShowSettingsBeanProperty_8 = BeanProperty.create((String)"nfoWriteLockdata");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_8, (Object)this.chckbxLockdata, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty tvShowSettingsBeanProperty_9 = BeanProperty.create((String)"nfoWriteNewEpisodeguideStyle");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_9, (Object)this.chckbxNewEpisodeguideFormat, (Property)jCheckBoxBeanProperty);
        autoBinding_9.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"nfoWriteTrailer");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.chckbxTrailer, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowSettingsBeanProperty_10 = BeanProperty.create((String)"nfoWriteFileinfo");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_10, (Object)this.chckbxFileinfo, (Property)jCheckBoxBeanProperty);
        autoBinding_10.bind();
    }

    private static class CertificationStyleWrapper {
        private CertificationStyle style;

        private CertificationStyleWrapper() {
        }

        public String toString() {
            String bundleTag = TmmResourceBundle.getString("Settings.certification." + this.style.name().toLowerCase(Locale.ROOT));
            return bundleTag.replace("{}", CertificationStyle.formatCertification(MediaCertification.DE_FSK16, this.style));
        }
    }
}

